/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.util.Properties;

public class Printer
implements PlugInFilter {
    private ImagePlus imp;
    private static double scaling = 100.0;
    private static boolean drawBorder = false;
    private static boolean center = true;
    private static boolean label = false;
    private static Properties printPrefs = new Properties();
    static /* synthetic */ Class class$ij$plugin$filter$Printer;

    public int setup(String arg, ImagePlus imp) {
        if (arg.equals("setup")) {
            this.pageSetup();
            return 4096;
        }
        this.imp = imp;
        IJ.register(class$ij$plugin$filter$Printer == null ? (class$ij$plugin$filter$Printer = Printer.class$("ij.plugin.filter.Printer")) : class$ij$plugin$filter$Printer);
        return 159;
    }

    public void run(ImageProcessor ip) {
        this.print(this.imp);
    }

    void pageSetup() {
        GenericDialog gd = new GenericDialog("Page Setup", IJ.getInstance());
        gd.addNumericField("Scaling (5-500%):", scaling, 0);
        gd.addCheckbox("Draw Border", drawBorder);
        gd.addCheckbox("Center on Page", center);
        gd.addCheckbox("Print Title", label);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        scaling = gd.getNextNumber();
        if (scaling < 5.0) {
            scaling = 5.0;
        }
        drawBorder = gd.getNextBoolean();
        center = gd.getNextBoolean();
        label = gd.getNextBoolean();
    }

    void print(ImagePlus imp) {
        ImageWindow win = imp.getWindow();
        ImageCanvas ic = win.getCanvas();
        Toolkit toolkit = win.getToolkit();
        PrintJob job = toolkit.getPrintJob(win, imp.getTitle(), printPrefs);
        if (job == null) {
            return;
        }
        Graphics g = job.getGraphics();
        if (g == null) {
            return;
        }
        Dimension pageSize = job.getPageDimension();
        if (IJ.debugMode) {
            IJ.write("pageSize: " + pageSize);
        }
        double scale = scaling / 100.0;
        int imageWidth = imp.getWidth();
        int imageHeight = imp.getHeight();
        int width = (int)((double)imageWidth * scale);
        int height = (int)((double)imageHeight * scale);
        int margin = 20;
        int labelHeight = 0;
        int maxWidth = pageSize.width - margin * 2;
        int maxHeight = pageSize.height - (margin + labelHeight) * 2;
        g.setColor(Color.black);
        if (label) {
            labelHeight = 15;
            g.setFont(new Font("SanSerif", 0, 12));
            g.drawString(imp.getTitle(), margin + 5, margin + labelHeight - 3);
        }
        if (width > maxWidth || height > maxHeight) {
            double hscale = (double)maxWidth / (double)imageWidth;
            double vscale = (double)maxHeight / (double)imageHeight;
            scale = hscale <= vscale ? hscale : vscale;
            width = (int)((double)imageWidth * scale);
            height = (int)((double)imageHeight * scale);
        }
        if (center) {
            g.translate((pageSize.width - width) / 2, labelHeight + (pageSize.height - height) / 2);
        } else {
            g.translate(margin, margin + labelHeight);
        }
        if (drawBorder) {
            g.drawRect(-1, -1, width + 1, height + 1);
        }
        g.setClip(0, 0, width, height);
        ic.print(g, scale);
        g.dispose();
        job.end();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

