/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;

public class EDM
implements PlugInFilter {
    ImagePlus imp;
    String arg;
    int maxEDM;
    short[] xCoordinate;
    short[] yCoordinate;
    int[] levelStart;
    int[] levelOffset;
    int[] histogram;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        this.arg = arg;
        return 129;
    }

    public void run(ImageProcessor ip) {
        ImageStatistics stats = this.imp.getStatistics();
        if (stats.histogram[0] + stats.histogram[255] != stats.pixelCount) {
            IJ.error("8-bit binary image (0 and 255) required.");
            return;
        }
        ImageProcessor ip2 = this.makeEDM(ip);
        if (this.arg.equals("points")) {
            this.findUltimatePoints(ip2);
            new ImagePlus("Ultimate Points", ip2).show();
        } else {
            new ImagePlus("EDM", ip2).show();
        }
    }

    public ImageProcessor makeEDM(ImageProcessor ip) {
        int offset;
        int one = 41;
        int sqrt2 = 58;
        int sqrt5 = 92;
        this.imp.killRoi();
        int width = this.imp.getWidth();
        int height = this.imp.getHeight();
        int rowsize = width;
        int xmax = width - 3;
        int ymax = height - 3;
        ImageProcessor ip16 = ip.convertToShort(false);
        ip16.multiply(one);
        short[] image16 = (short[])ip16.getPixels();
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                offset = x + y * rowsize;
                if (image16[offset] > 0) {
                    if (x < 2 || x > xmax || y < 2 || y > ymax) {
                        this.setEdgeValue(offset, rowsize, image16, x, y, xmax, ymax);
                    } else {
                        this.setValue(offset, rowsize, image16);
                    }
                }
                ++x;
            }
            ++y;
        }
        int y2 = height - 1;
        while (y2 >= 0) {
            int x = width - 1;
            while (x >= 0) {
                offset = x + y2 * rowsize;
                if (image16[offset] > 0) {
                    if (x < 2 || x > xmax || y2 < 2 || y2 > ymax) {
                        this.setEdgeValue(offset, rowsize, image16, x, y2, xmax, ymax);
                    } else {
                        this.setValue(offset, rowsize, image16);
                    }
                }
                --x;
            }
            --y2;
        }
        ImageProcessor ip2 = ip.createProcessor(width, height);
        byte[] image8 = (byte[])ip2.getPixels();
        this.convertToBytes(width, height, image16, image8);
        return ip2;
    }

    void setValue(int offset, int rowsize, short[] image16) {
        int one = 41;
        int sqrt2 = 58;
        int sqrt5 = 92;
        int r1 = offset - rowsize - rowsize - 2;
        int r2 = r1 + rowsize;
        int r3 = r2 + rowsize;
        int r4 = r3 + rowsize;
        int r5 = r4 + rowsize;
        int v = image16[r2 + 2] + one;
        int min = Short.MAX_VALUE;
        if (v < min) {
            min = v;
        }
        if ((v = image16[r3 + 1] + one) < min) {
            min = v;
        }
        if ((v = image16[r3 + 3] + one) < min) {
            min = v;
        }
        if ((v = image16[r4 + 2] + one) < min) {
            min = v;
        }
        if ((v = image16[r2 + 1] + sqrt2) < min) {
            min = v;
        }
        if ((v = image16[r2 + 3] + sqrt2) < min) {
            min = v;
        }
        if ((v = image16[r4 + 1] + sqrt2) < min) {
            min = v;
        }
        if ((v = image16[r4 + 3] + sqrt2) < min) {
            min = v;
        }
        if ((v = image16[r1 + 1] + sqrt5) < min) {
            min = v;
        }
        if ((v = image16[r1 + 3] + sqrt5) < min) {
            min = v;
        }
        if ((v = image16[r2 + 4] + sqrt5) < min) {
            min = v;
        }
        if ((v = image16[r4 + 4] + sqrt5) < min) {
            min = v;
        }
        if ((v = image16[r5 + 3] + sqrt5) < min) {
            min = v;
        }
        if ((v = image16[r5 + 1] + sqrt5) < min) {
            min = v;
        }
        if ((v = image16[r4] + sqrt5) < min) {
            min = v;
        }
        if ((v = image16[r2] + sqrt5) < min) {
            min = v;
        }
        image16[offset] = (short)min;
    }

    void setEdgeValue(int offset, int rowsize, short[] image16, int x, int y, int xmax, int ymax) {
        int one = 41;
        int sqrt2 = 58;
        int sqrt5 = 92;
        int r1 = offset - rowsize - rowsize - 2;
        int r2 = r1 + rowsize;
        int r3 = r2 + rowsize;
        int r4 = r3 + rowsize;
        int r5 = r4 + rowsize;
        int min = Short.MAX_VALUE;
        short offimage = image16[r3 + 2];
        int v = y < 2 ? offimage + one : image16[r2 + 2] + one;
        if (v < min) {
            min = v;
        }
        if ((v = x < 2 ? offimage + one : image16[r3 + 1] + one) < min) {
            min = v;
        }
        if ((v = x > xmax ? offimage + one : image16[r3 + 3] + one) < min) {
            min = v;
        }
        if ((v = y > ymax ? offimage + one : image16[r4 + 2] + one) < min) {
            min = v;
        }
        if ((v = x < 2 || y < 2 ? offimage + sqrt2 : image16[r2 + 1] + sqrt2) < min) {
            min = v;
        }
        if ((v = x > xmax || y < 2 ? offimage + sqrt2 : image16[r2 + 3] + sqrt2) < min) {
            min = v;
        }
        if ((v = x < 2 || y > ymax ? offimage + sqrt2 : image16[r4 + 1] + sqrt2) < min) {
            min = v;
        }
        if ((v = x > xmax || y > ymax ? offimage + sqrt2 : image16[r4 + 3] + sqrt2) < min) {
            min = v;
        }
        if ((v = x < 2 || y < 2 ? offimage + sqrt5 : image16[r1 + 1] + sqrt5) < min) {
            min = v;
        }
        if ((v = x > xmax || y < 2 ? offimage + sqrt5 : image16[r1 + 3] + sqrt5) < min) {
            min = v;
        }
        if ((v = x > xmax || y < 2 ? offimage + sqrt5 : image16[r2 + 4] + sqrt5) < min) {
            min = v;
        }
        if ((v = x > xmax || y > ymax ? offimage + sqrt5 : image16[r4 + 4] + sqrt5) < min) {
            min = v;
        }
        if ((v = x > xmax || y > ymax ? offimage + sqrt5 : image16[r5 + 3] + sqrt5) < min) {
            min = v;
        }
        if ((v = x < 2 || y > ymax ? offimage + sqrt5 : image16[r5 + 1] + sqrt5) < min) {
            min = v;
        }
        if ((v = x < 2 || y > ymax ? offimage + sqrt5 : image16[r4] + sqrt5) < min) {
            min = v;
        }
        if ((v = x < 2 || y < 2 ? offimage + sqrt5 : image16[r2] + sqrt5) < min) {
            min = v;
        }
        image16[offset] = (short)min;
    }

    void convertToBytes(int width, int height, short[] image16, byte[] image8) {
        int one = 41;
        int round = one / 2;
        this.maxEDM = 0;
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int offset = x + y * width;
                int v = (image16[offset] + round) / one;
                if (v > 255) {
                    v = 255;
                }
                if (v > this.maxEDM) {
                    this.maxEDM = v;
                }
                image8[offset] = (byte)v;
                ++x;
            }
            ++y;
        }
    }

    public void findUltimatePoints(ImageProcessor ip) {
        int i;
        this.smoothEDM(ip);
        this.makeCoordinateArrays(ip);
        byte[] image = (byte[])ip.getPixels();
        ImageProcessor ip2 = ip.duplicate();
        byte[] image2 = (byte[])ip2.getPixels();
        int width = ip.getWidth();
        int height = ip.getHeight();
        int rowsize = width;
        int xmax = width - 1;
        int ymax = height - 1;
        int level = this.maxEDM - 1;
        while (level >= 1) {
            int count;
            do {
                count = 0;
                i = 0;
                while (i < this.histogram[level]) {
                    int CoordOffset = this.levelStart[level] + i;
                    short x = this.xCoordinate[CoordOffset];
                    short y = this.yCoordinate[CoordOffset];
                    int offset = x + y * rowsize;
                    if ((image[offset] & 0xFF) != 255) {
                        boolean setPixel = false;
                        if (x > 0 && y > 0 && (image[offset - rowsize - 1] & 0xFF) > level) {
                            setPixel = true;
                        }
                        if (y > 0 && (image[offset - rowsize] & 0xFF) > level) {
                            setPixel = true;
                        }
                        if (x < xmax && y > 0 && (image[offset - rowsize + 1] & 0xFF) > level) {
                            setPixel = true;
                        }
                        if (x < xmax && (image[offset + 1] & 0xFF) > level) {
                            setPixel = true;
                        }
                        if (x < xmax && y < ymax && (image[offset + rowsize + 1] & 0xFF) > level) {
                            setPixel = true;
                        }
                        if (y < ymax && (image[offset + rowsize] & 0xFF) > level) {
                            setPixel = true;
                        }
                        if (x > 0 && y < ymax && (image[offset + rowsize - 1] & 0xFF) > level) {
                            setPixel = true;
                        }
                        if (x > 0 && (image[offset - 1] & 0xFF) > level) {
                            setPixel = true;
                        }
                        if (setPixel) {
                            image[offset] = -1;
                            ++count;
                        }
                    }
                    ++i;
                }
            } while (count != 0);
            --level;
        }
        i = 0;
        while (i < width * height) {
            if ((image[i] & 0xFF) == 255) {
                image[i] = 0;
            }
            ++i;
        }
    }

    void smoothEDM(ImageProcessor edm) {
        byte[] image = (byte[])edm.getPixels();
        ImageProcessor ip2 = edm.duplicate();
        byte[] image2 = (byte[])ip2.getPixels();
        int width = edm.getWidth();
        int height = edm.getHeight();
        int rowsize = width;
        int xmax = width - 1;
        int ymax = height - 1;
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int offset = x + y * rowsize;
                if (image2[offset] != 1) {
                    int sum = image2[offset] * 2;
                    if (x > 0 && y > 0) {
                        sum += image2[offset - rowsize - 1];
                    }
                    if (y > 0) {
                        sum += image2[offset - rowsize];
                    }
                    if (x < xmax && y > 0) {
                        sum += image2[offset - rowsize + 1];
                    }
                    if (x < xmax) {
                        sum += image2[offset + 1];
                    }
                    if (x < xmax && y < ymax) {
                        sum += image2[offset + rowsize + 1];
                    }
                    if (y < ymax) {
                        sum += image2[offset + rowsize];
                    }
                    if (x > 0 && y < ymax) {
                        sum += image2[offset + rowsize - 1];
                    }
                    if (x > 0) {
                        sum += image2[offset - 1];
                    }
                    image[offset] = (byte)(sum / 10);
                }
                ++x;
            }
            ++y;
        }
    }

    void makeCoordinateArrays(ImageProcessor edm) {
        int width = edm.getWidth();
        int height = edm.getHeight();
        this.histogram = edm.getHistogram();
        int ArraySize = 0;
        int i = 0;
        while (i < this.maxEDM - 1) {
            ArraySize += this.histogram[i];
            ++i;
        }
        this.xCoordinate = new short[ArraySize];
        this.yCoordinate = new short[ArraySize];
        byte[] image = (byte[])edm.getPixels();
        int offset = 0;
        this.levelStart = new int[256];
        int i2 = 0;
        while (i2 < 256) {
            this.levelStart[i2] = offset;
            if (i2 > 0 && i2 < this.maxEDM) {
                offset += this.histogram[i2];
            }
            ++i2;
        }
        this.levelOffset = new int[256];
        int rowsize = width;
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int v = image[x + y * rowsize] & 0xFF;
                if (v > 0 && v < this.maxEDM) {
                    offset = this.levelStart[v] + this.levelOffset[v];
                    this.xCoordinate[offset] = (short)x;
                    this.yCoordinate[offset] = (short)y;
                    int n = v;
                    this.levelOffset[n] = this.levelOffset[n] + 1;
                }
                ++x;
            }
            ++y;
        }
    }
}

