/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.awt.Frame;

public class Duplicater
implements PlugInFilter {
    ImagePlus imp;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return 159;
    }

    public void run(ImageProcessor ip) {
        this.duplicate(this.imp);
    }

    public void duplicate(ImagePlus imp) {
        ImageProcessor ip2 = imp.getProcessor().crop();
        imp.killRoi();
        imp.trimProcessor();
        String title = imp.getTitle();
        String newTitle = imp.getStackSize() > 1 ? title + "-" + imp.getCurrentSlice() : (!title.endsWith("-copy") ? title + "-copy" : title);
        if (!IJ.altKeyDown()) {
            newTitle = this.getString("Duplicate...", "Title: ", newTitle);
        }
        if (newTitle.equals("")) {
            return;
        }
        ImagePlus imp2 = imp.createImagePlus();
        imp2.setProcessor(newTitle, ip2);
        imp2.show();
    }

    String getString(String title, String prompt, String defaultString) {
        Frame win = this.imp.getWindow();
        if (win == null) {
            win = IJ.getInstance();
        }
        GenericDialog gd = new GenericDialog(title, win);
        gd.addStringField(prompt, defaultString, 20);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return "";
        }
        return gd.getNextString();
    }
}

