/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.plugin.filter.PlugInFilter;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.util.StringTokenizer;

public class Convolver
implements PlugInFilter {
    static final int BYTE = 0;
    static final int SHORT = 1;
    static final int FLOAT = 2;
    static final int RGB = 3;
    ImagePlus imp;
    static String kernelText = ".0625  .125  .0625\n.125    .25    .125\n.0625  .125  .0625";
    static boolean normalize = true;
    static boolean createSelection = false;
    int kw;
    int kh;
    static float[] kernel;
    static int slice;
    static boolean canceled;
    static ImageWindow win;
    static /* synthetic */ Class class$ij$plugin$filter$Convolver;

    public int setup(String arg, ImagePlus imp) {
        IJ.register(class$ij$plugin$filter$Convolver == null ? (class$ij$plugin$filter$Convolver = Convolver.class$("ij.plugin.filter.Convolver")) : class$ij$plugin$filter$Convolver);
        this.imp = imp;
        slice = 0;
        canceled = false;
        return IJ.setupDialog(imp, 31);
    }

    public void run(ImageProcessor ip) {
        if (canceled) {
            return;
        }
        if (++slice == 1) {
            kernel = this.getKernel();
            if (kernel == null) {
                canceled = true;
                return;
            }
            if ((this.kw & 1) == 0) {
                IJ.showMessage("Convolver", "The kernel must be square and have an\nodd width. This kernel is " + this.kw + "x" + this.kh + ".");
                canceled = true;
                return;
            }
            win = this.imp.getWindow();
            Convolver.win.running = true;
            IJ.showStatus("Convolver: convolving with " + this.kw + "x" + this.kh + " kernel");
            this.imp.startTiming();
        }
        if (!Convolver.win.running) {
            canceled = true;
            return;
        }
        this.convolve(ip, kernel, this.kw, this.kh);
        if (slice > 1) {
            IJ.showStatus(slice + "/" + this.imp.getStackSize());
        }
        if (slice == this.imp.getStackSize()) {
            ip.resetMinAndMax();
            if (createSelection) {
                this.imp.setRoi(this.kw / 2, this.kh / 2, this.imp.getWidth() - this.kw / 2 * 2, this.imp.getHeight() - this.kh / 2 * 2);
            }
        }
    }

    float[] getKernel() {
        GenericDialog gd = new GenericDialog("Convolver...", IJ.getInstance());
        gd.addTextAreas(kernelText, null, 10, 30);
        gd.addCheckbox("Normalize Kernel", normalize);
        gd.addCheckbox("Create Selection", createSelection);
        gd.showDialog();
        if (gd.wasCanceled()) {
            canceled = true;
            return null;
        }
        kernelText = gd.getNextText();
        normalize = gd.getNextBoolean();
        createSelection = gd.getNextBoolean();
        StringTokenizer st = new StringTokenizer(kernelText);
        int n = st.countTokens();
        this.kh = this.kw = (int)Math.sqrt(n);
        n = this.kw * this.kh;
        float[] k = new float[n];
        int i = 0;
        while (i < n) {
            k[i] = (float)this.getNum(st);
            ++i;
        }
        return k;
    }

    double getNum(StringTokenizer st) {
        Double d;
        String token = st.nextToken();
        try {
            d = new Double(token);
        }
        catch (NumberFormatException e) {
            d = null;
        }
        if (d != null) {
            return d;
        }
        return 0.0;
    }

    public void convolve(ImageProcessor ip, float[] kernel, int kw, int kh) {
        int type = ip instanceof ByteProcessor ? 0 : (ip instanceof ShortProcessor ? 1 : (ip instanceof FloatProcessor ? 2 : 3));
        if (type == 3) {
            this.convolveRGB(ip, kernel, kw, kh);
            return;
        }
        ImageProcessor ip2 = ip.convertToFloat();
        this.convolveFloat(ip2, kernel, kw, kh);
        switch (type) {
            case 0: {
                ip2 = ip2.convertToByte(false);
                byte[] pixels = (byte[])ip.getPixels();
                byte[] pixels2 = (byte[])ip2.getPixels();
                System.arraycopy(pixels2, 0, pixels, 0, pixels.length);
                break;
            }
            case 1: {
                ip2 = ip2.convertToShort(false);
                short[] pixels16 = (short[])ip.getPixels();
                short[] pixels16b = (short[])ip2.getPixels();
                System.arraycopy(pixels16b, 0, pixels16, 0, pixels16.length);
                break;
            }
        }
    }

    public void convolveRGB(ImageProcessor ip, float[] kernel, int kw, int kh) {
        int width = ip.getWidth();
        int height = ip.getHeight();
        int size = width * height;
        byte[] r = new byte[size];
        byte[] g = new byte[size];
        byte[] b = new byte[size];
        ((ColorProcessor)ip).getRGB(r, g, b);
        ByteProcessor rip = new ByteProcessor(width, height, r, null);
        ByteProcessor gip = new ByteProcessor(width, height, g, null);
        ByteProcessor bip = new ByteProcessor(width, height, b, null);
        ImageProcessor ip2 = rip.convertToFloat();
        this.convolveFloat(ip2, kernel, kw, kh);
        ImageProcessor r2 = ip2.convertToByte(false);
        ip2 = gip.convertToFloat();
        this.convolveFloat(ip2, kernel, kw, kh);
        ImageProcessor g2 = ip2.convertToByte(false);
        ip2 = bip.convertToFloat();
        this.convolveFloat(ip2, kernel, kw, kh);
        ImageProcessor b2 = ip2.convertToByte(false);
        ((ColorProcessor)ip).setRGB((byte[])r2.getPixels(), (byte[])g2.getPixels(), (byte[])b2.getPixels());
    }

    public void convolveFloat(ImageProcessor ip, float[] kernel, int kw, int kh) {
        int width = ip.getWidth();
        int height = ip.getHeight();
        int uc = kw / 2;
        int vc = kh / 2;
        float[] pixels = (float[])ip.getPixels();
        float[] pixels2 = (float[])ip.getPixelsCopy();
        int i = 0;
        while (i < width * height) {
            pixels[i] = 0.0f;
            ++i;
        }
        double scale = 1.0;
        if (normalize) {
            double sum = 0.0;
            int i2 = 0;
            while (i2 < kernel.length) {
                sum += (double)kernel[i2];
                ++i2;
            }
            if (sum != 0.0) {
                scale = (float)(1.0 / sum);
            }
        }
        int progress = Math.max(height / 25, 1);
        int y = vc;
        while (y < height - vc) {
            if (y % progress == 0) {
                IJ.showProgress((double)y / (double)height);
            }
            int x = uc;
            while (x < width - uc) {
                double sum = 0.0;
                int i3 = 0;
                int v = -vc;
                while (v <= vc) {
                    int offset = x + (y + v) * width;
                    int u = -uc;
                    while (u <= uc) {
                        sum += (double)(pixels2[offset + u] * kernel[i3++]);
                        ++u;
                    }
                    ++v;
                }
                pixels[x + y * width] = (float)(sum * scale);
                ++x;
            }
            ++y;
        }
        IJ.showProgress(1.0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

