/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.ImageWindow;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.text.TextWindow;
import java.awt.Font;

public class Benchmark
implements PlugInFilter {
    String arg;
    ImagePlus imp;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        if (arg.equals("show")) {
            this.showBenchmarkResults();
            return 4096;
        }
        if (arg.equals("particles")) {
            this.showParticlesResults();
            return 4096;
        }
        this.arg = arg;
        if (arg.equals("draw")) {
            return 31;
        }
        return 151;
    }

    public void run(ImageProcessor ip) {
        Thread.currentThread().setPriority(1);
        if (this.arg.equals("draw")) {
            ImageWindow win = this.imp.getWindow();
            win.running = true;
            int loops = 200;
            long startTime = System.currentTimeMillis();
            int i = 0;
            while (i < loops) {
                this.imp.draw();
                Thread.yield();
                if (i % 5 == 0) {
                    IJ.showProgress((double)i / (double)loops);
                }
                if (!win.running) {
                    IJ.showProgress(1.0);
                    return;
                }
                ++i;
            }
            IJ.showProgress(1.0);
            int pixels = this.imp.getWidth() * this.imp.getHeight() * loops;
            long time = System.currentTimeMillis() - startTime;
            double seconds = (double)time / 1000.0;
            IJ.write(IJ.d2s((double)pixels / seconds / 1000000.0) + " million pixels per second");
            return;
        }
        ip.setInterpolate(false);
        int i = 0;
        while (i < 4) {
            ip.invert();
            this.imp.updateAndDraw();
            ++i;
        }
        int i2 = 0;
        while (i2 < 4) {
            ip.flipVertical();
            this.imp.updateAndDraw();
            ++i2;
        }
        ip.flipHorizontal();
        this.imp.updateAndDraw();
        ip.flipHorizontal();
        this.imp.updateAndDraw();
        int i3 = 0;
        while (i3 < 6) {
            ip.smooth();
            this.imp.updateAndDraw();
            ++i3;
        }
        ip.reset();
        int i4 = 0;
        while (i4 < 6) {
            ip.sharpen();
            this.imp.updateAndDraw();
            ++i4;
        }
        ip.reset();
        ip.smooth();
        this.imp.updateAndDraw();
        ip.findEdges();
        this.imp.updateAndDraw();
        ip.invert();
        this.imp.updateAndDraw();
        ip.autoThreshold();
        this.imp.updateAndDraw();
        ip.reset();
        ip.medianFilter();
        this.imp.updateAndDraw();
        int i5 = 0;
        while (i5 < 360) {
            ip.reset();
            ip.rotate(i5);
            this.imp.updateAndDraw();
            i5 += 15;
        }
        double scale = 1.5;
        int i6 = 0;
        while (i6 < 8) {
            ip.reset();
            ip.scale(scale, scale);
            this.imp.updateAndDraw();
            scale *= 1.5;
            ++i6;
        }
        int i7 = 0;
        while (i7 < 12) {
            ip.reset();
            ip.scale(scale /= 1.5, scale);
            this.imp.updateAndDraw();
            ++i7;
        }
        ip.reset();
        this.imp.updateAndDraw();
    }

    void showBenchmarkResults() {
        TextWindow tw = new TextWindow("ImageJ Benchmark", "", 450, 450);
        tw.setFont(new Font("Monospaced", 0, 12));
        tw.append("Time in seconds needed to perform 62 image processing");
        tw.append("operations on the 512x512 \"Mandrill\" image");
        tw.append("---------------------------------------------------------");
        tw.append(" 3.3   Pentium 4/1.4, Win2K  IE 5.0");
        tw.append(" 5.3   Pentium 3/750, Win98  IE 5.0");
        tw.append(" 5.6   Pentium 4/1.4, Win2K  JDK 1.3");
        tw.append(" 6.0   Pentium 3/750, Win98  Netscape 4.7");
        tw.append(" 8.6   PPC G4/400, MacOS     MRJ 2.2");
        tw.append(" 9.1   Pentium 2/400, Win95  JRE 1.1.8");
        tw.append(" 9.2   Pentium 2/400, Win95  IE 4.0");
        tw.append(" 9.8   Pentium 2/400, Linux  IBM JDK 1.1.8");
        tw.append("  11   Pentium 2/400, Win95  JDK 1.2 (24% slower)");
        tw.append("  11   Pentium 2/400, Win95  Netscape 4.5");
        tw.append("  14   PPC G3/300, MacOS     MRJ 2.1");
        tw.append("  21   Pentium 2/400, Win95  JDK 1.3 (>2 times slower!!)");
        tw.append("  38   PPC 604/132, MacOS    MRJ 2.1ea2");
        tw.append("  61   PPC 604/132, MacOS    MRJ 2.0");
        tw.append("  89   Pentium/100, Win95    JRE 1.1.6");
        tw.append("  96   Pentium/400, Linux    Sun JDK 1.2.2 (17 with JIT)");
        tw.append("");
    }

    void showParticlesResults() {
        TextWindow tw = new TextWindow("Particles Benchmark", "", 450, 500);
        tw.setFont(new Font("Monospaced", 0, 12));
        tw.append("These are times in seconds needed to measure the size");
        tw.append("and location of 5097 objects in a 2000x1000 binary image.");
        tw.append("Tests were run on 400Mhz Pentiums and a 400Mhz G3 Mac.");
        tw.append("");
        tw.append("24  Netscape 4.5");
        tw.append("24  Internet Explorer 4.0");
        tw.append("28  JDK 1.3");
        tw.append("30  JDK 1.2");
        tw.append("33  JDK 1.1.8");
        tw.append("35  MacOS Runtime for Java 2.2");
        tw.append("60  Sun JDK 1.2.2 for Linux");
        tw.append("70  IBM JDK 1.1.8 for Linux");
        tw.append("");
        tw.append("To run the benchmark:");
        tw.append("");
        tw.append("1) Open the test image using File/Open Samples/Particles.");
        tw.append("2) Check \"Area\" and \"Centroid\" in Analalyze/Set Measurements.");
        tw.append("3) Select Analyze/Analyze Particles.");
        tw.append("3) Check \"Display Results\" and then click \"OK\".");
    }
}

