/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.ImageWindow;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;

public class StackEditor
implements PlugIn {
    String arg;
    ImagePlus imp;
    int nSlices;
    int width;
    int height;

    public void run(String arg) {
        this.imp = WindowManager.getCurrentImage();
        if (this.imp == null) {
            IJ.noImage();
            return;
        }
        this.nSlices = this.imp.getStackSize();
        this.width = this.imp.getWidth();
        this.height = this.imp.getHeight();
        if (arg.equals("tostack")) {
            this.convertImagesToStack();
            return;
        }
        if (this.nSlices < 2) {
            IJ.error("Stack requred");
            return;
        }
        if (arg.equals("add")) {
            this.addSlice();
        } else if (arg.equals("delete")) {
            this.deleteSlice();
        } else if (arg.equals("toimages")) {
            this.convertStackToImages(this.imp);
        }
    }

    void addSlice() {
        if (!this.imp.lock()) {
            return;
        }
        ImageStack stack = this.imp.getStack();
        ImageProcessor ip = this.imp.getProcessor();
        int n = this.imp.getCurrentSlice();
        if (IJ.altKeyDown()) {
            --n;
        }
        stack.addSlice(null, ip.createProcessor(this.width, this.height), n);
        this.imp.setStack(null, stack);
        this.imp.setSlice(n + 1);
        this.imp.unlock();
    }

    void deleteSlice() {
        if (!this.imp.lock()) {
            return;
        }
        ImageStack stack = this.imp.getStack();
        int n = this.imp.getCurrentSlice();
        stack.deleteSlice(n);
        if (stack.getSize() == 1) {
            this.imp.setProcessor(null, stack.getProcessor(1));
            new ImageWindow(this.imp);
        } else {
            this.imp.setStack(null, stack);
            if (n-- < 1) {
                n = 1;
            }
            this.imp.setSlice(n);
        }
        this.imp.unlock();
    }

    public void convertImagesToStack() {
        int[] wList = WindowManager.getIDList();
        if (wList == null) {
            IJ.error("No images are open.");
            return;
        }
        if (wList.length < 2) {
            IJ.error("There must be at least two open images.");
            return;
        }
        ImagePlus[] image = new ImagePlus[wList.length];
        int i = 0;
        while (i < wList.length) {
            image[i] = WindowManager.getImage(wList[i]);
            if (image[i].getStackSize() > 1) {
                IJ.error("None of the open images can be a stack.");
                return;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < wList.length - 1) {
            if (image[i2].getType() != image[i2 + 1].getType()) {
                IJ.error("All open images must be the same type.");
                return;
            }
            if (image[i2].getWidth() != image[i2 + 1].getWidth() || image[i2].getHeight() != image[i2 + 1].getHeight()) {
                IJ.error("All open images must be the same size.");
                return;
            }
            ++i2;
        }
        int width = image[0].getWidth();
        int height = image[0].getHeight();
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        ImageStack stack = new ImageStack(width, height);
        int i3 = 0;
        while (i3 < wList.length) {
            ImageProcessor ip = image[i3].getProcessor();
            if (ip.getMin() < min) {
                min = ip.getMin();
            }
            if (ip.getMax() > max) {
                max = ip.getMax();
            }
            stack.addSlice(null, ip);
            image[i3].changes = false;
            image[i3].getWindow().close();
            ++i3;
        }
        ImagePlus imp = new ImagePlus("Stack", stack);
        if (imp.getType() == 1 || imp.getType() == 2) {
            imp.getProcessor().setMinAndMax(min, max);
        }
        imp.show();
    }

    public void convertStackToImages(ImagePlus imp) {
        boolean ok;
        if (!imp.lock()) {
            return;
        }
        ImageStack stack = imp.getStack();
        int size = stack.getSize();
        if (size > 30 && !(ok = IJ.showMessageWithCancel("Convert to Images?", "Are you sure you want to convert this\nstack to " + size + " separate windows?"))) {
            imp.unlock();
            return;
        }
        int i = 1;
        while (i <= size) {
            String label = stack.getSliceLabel(i);
            String title = label != null && !label.equals("") ? label : this.getDigits(i);
            new ImagePlus(title, stack.getProcessor(i)).show();
            ++i;
        }
        imp.changes = false;
        ImageWindow win = imp.getWindow();
        if (win != null) {
            win.close();
        }
        imp.unlock();
    }

    String getDigits(int n) {
        String digits = "00000000" + n;
        return digits.substring(digits.length() - 4, digits.length());
    }
}

