/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.Line;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.StackProcessor;
import java.awt.Rectangle;
import java.awt.image.ColorModel;

public class Slicer
implements PlugIn {
    private double xinc;
    private double yinc;
    private double xstart;
    private double ystart;
    private double xend;
    private double yend;
    private double dx;
    private double dy;
    private int number;
    private double zscale;
    private static int swidth = 1;
    private static boolean interpolate = true;
    private ColorModel cmod;
    private int width;
    private int height;
    private ImagePlus imp;
    static /* synthetic */ Class class$ij$plugin$Slicer;

    public void run(String arg) {
        this.imp = WindowManager.getCurrentImage();
        if (this.imp == null) {
            IJ.noImage();
            return;
        }
        if (this.imp.getStackSize() < 2) {
            IJ.error("Stack required");
            return;
        }
        Roi roi = this.imp.getRoi();
        if (roi == null || roi.getType() != 5 && roi.getType() != 0) {
            IJ.error("Straight line or rectangular selection required");
            return;
        }
        if (roi.getType() == 0) {
            swidth = roi.getBoundingRect().height;
        }
        Calibration cal = this.imp.getCalibration();
        GenericDialog gd = new GenericDialog("Slice Parameters", IJ.getInstance());
        gd.addNumericField("Z-Spacing (" + cal.getUnits() + "):", cal.pixelDepth, 1);
        gd.addNumericField("Slice Width (pixels):", swidth, 0);
        gd.addCheckbox("Interpolate", interpolate);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        cal.pixelDepth = gd.getNextNumber();
        this.imp.setCalibration(cal);
        this.zscale = cal.pixelDepth / cal.pixelWidth;
        swidth = (int)gd.getNextNumber();
        interpolate = gd.getNextBoolean();
        long tstart = System.currentTimeMillis();
        if (!this.imp.lock()) {
            return;
        }
        ImagePlus oimg = this.sliceImage(this.imp, roi);
        this.imp.unlock();
        long tstop = System.currentTimeMillis();
        double seconds = (double)(tstop - tstart) / 1000.0;
        oimg.show("Slicer: " + IJ.d2s(seconds, 2) + " seconds");
        IJ.register(class$ij$plugin$Slicer == null ? (class$ij$plugin$Slicer = Slicer.class$("ij.plugin.Slicer")) : class$ij$plugin$Slicer);
    }

    public void setZScaling(double zscale) {
        this.zscale = zscale;
    }

    public void setSliceWidth(int swidth) {
        Slicer.swidth = swidth;
    }

    public ImagePlus sliceImage(ImagePlus imp, Roi roi) {
        this.adjustParameters(imp);
        this.initParameters(imp);
        ImageStack stack = imp.getStack();
        ImageStack ostack = this.stackSlice(stack, roi);
        if (this.zscale != 1.0) {
            ostack = this.applyZScaling(ostack);
        }
        return new ImagePlus("Slice", ostack);
    }

    private ImageStack stackSlice(ImageStack stack, Roi roi) {
        this.setLineParams(roi);
        double nrm = Math.sqrt(this.dx * this.dx + this.dy * this.dy);
        double sXInc = -this.dy / nrm;
        double sYInc = this.dx / nrm;
        ImageStack ostack = new ImageStack(this.number, stack.getSize(), this.cmod);
        int n = 0;
        while (n < swidth) {
            ImageProcessor ip = this.processorSlice(stack, roi);
            int type = this.imp.getType();
            switch (type) {
                case 0: {
                    ip = ip.convertToByte(false);
                    break;
                }
                case 1: {
                    ip = ip.convertToShort(false);
                }
            }
            ostack.addSlice("", ip);
            this.xstart += sXInc;
            this.ystart += sYInc;
            this.xend += sXInc;
            this.yend += sYInc;
            if (n % 3 == 0) {
                IJ.showProgress((double)n / (double)swidth);
            }
            ++n;
        }
        IJ.showProgress(1.0);
        return ostack;
    }

    private ImageProcessor processorSlice(ImageStack stack, Roi roi) {
        ImageProcessor sp = stack.getProcessor(1);
        int width = this.number;
        int height = stack.getSize();
        ImageProcessor oip = this.imp.getType() == 4 ? sp.createProcessor(width, height) : new FloatProcessor(width, height, new float[width * height], this.cmod);
        ImageProcessor sip = sp.createProcessor(sp.getWidth(), sp.getHeight());
        sip.setInterpolate(interpolate);
        int row = stack.getSize() - 1;
        int n = 1;
        while (n <= stack.getSize()) {
            sip.setPixels(stack.getPixels(n));
            this.line2Image(sip, oip, row);
            ++n;
            --row;
        }
        sip = null;
        return oip;
    }

    private ImageStack applyZScaling(ImageStack stack) {
        if (this.zscale > 25.0) {
            this.zscale = 25.0;
        }
        if (this.zscale < 0.05) {
            this.zscale = 0.05;
        }
        ImageProcessor ip = stack.getProcessor(1);
        StackProcessor sp = new StackProcessor(stack, ip);
        ip.setInterpolate(interpolate);
        return sp.resize(this.imp.getWidth(), (int)(this.zscale * (double)stack.getHeight()));
    }

    private void line2Image(ImageProcessor ip, ImageProcessor oip, int row) {
        boolean interpolateLine;
        double rx = this.xstart;
        double ry = this.ystart;
        boolean bl = interpolateLine = interpolate && (this.xinc != 1.0 || this.yinc != 0.0);
        if (oip instanceof FloatProcessor) {
            int n = 0;
            while (n < this.number) {
                double value = interpolateLine ? ip.getInterpolatedPixel(rx, ry) : (double)ip.getPixel((int)(rx + 0.5), (int)(ry + 0.5));
                rx += this.xinc;
                ry += this.yinc;
                oip.putPixelValue(n, row, value);
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.number) {
                int ivalue = ip.getPixel((int)(rx + 0.5), (int)(ry + 0.5));
                rx += this.xinc;
                ry += this.yinc;
                oip.putPixel(n, row, ivalue);
                ++n;
            }
        }
    }

    private void setLineParams(Roi roi) {
        if (roi.getType() == 0) {
            Rectangle r = roi.getBoundingRect();
            this.dx = r.width;
            this.dy = 0.0;
            this.number = (int)this.dx;
            this.xinc = 1.0;
            this.yinc = 0.0;
            this.xstart = r.x;
            this.ystart = r.y;
            this.xend = this.xstart + (double)r.width;
            this.yend = this.ystart;
        } else {
            Line line = (Line)roi;
            this.dx = line.x2 - line.x1;
            this.dy = line.y2 - line.y1;
            this.number = (int)Math.round(Math.sqrt(this.dx * this.dx + this.dy * this.dy)) + 1;
            this.xinc = this.dx / (double)this.number;
            this.yinc = this.dy / (double)this.number;
            this.xstart = line.x1;
            this.ystart = line.y1;
            this.xend = line.x2;
            this.yend = line.y2;
        }
    }

    private void adjustParameters(ImagePlus imp) {
        if (this.zscale < 0.0) {
            this.zscale = 1.0;
        }
        int w = imp.getWidth();
        int h = imp.getHeight();
        int maxwidth = (int)Math.sqrt(w * w + h * h);
        if (swidth < 1 || swidth > maxwidth) {
            swidth = 1;
        }
    }

    private void initParameters(ImagePlus imp) {
        this.cmod = imp.getProcessor().getColorModel();
        this.width = imp.getWidth();
        this.height = imp.getHeight();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

