/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.OvalRoi;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.io.OpenDialog;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class RoiReader
implements PlugIn {
    final int polygon = 0;
    final int rect = 1;
    final int oval = 2;
    final int line = 3;
    final int freeLine = 4;
    final int segLine = 5;
    final int noRoi = 6;
    final int freehand = 7;
    final int traced = 8;
    byte[] data;

    public void run(String arg) {
        OpenDialog od = new OpenDialog("Open ROI...", arg);
        String dir = od.getDirectory();
        String name = od.getFileName();
        if (name == null) {
            return;
        }
        try {
            this.openRoi(dir, name);
        }
        catch (IOException e) {
            String msg = e.getMessage();
            if (msg == null || msg.equals("")) {
                msg = "" + e;
            }
            IJ.showMessage("ROI Reader", msg);
        }
    }

    public void openRoi(String dir, String name) throws IOException {
        String path = dir + name;
        File f = new File(path);
        int size = (int)f.length();
        if (size > 5000) {
            throw new IOException("This is not an ImageJ ROI");
        }
        FileInputStream fis = new FileInputStream(path);
        this.data = new byte[size];
        int total = 0;
        while (total < size) {
            total += fis.read(this.data, total, size - total);
        }
        if (this.getByte(0) != 73 || this.getByte(1) != 111) {
            throw new IOException("This is not an ImageJ ROI");
        }
        int type = this.getByte(6);
        int top = this.getShort(8);
        int left = this.getShort(10);
        int bottom = this.getShort(12);
        int right = this.getShort(14);
        int width = right - left;
        int height = bottom - top;
        int n = this.getShort(16);
        ImagePlus img = WindowManager.getCurrentImage();
        if (img == null || img.getWidth() < left + width || img.getHeight() < top + height) {
            ByteProcessor ip = new ByteProcessor(left + width + 10, top + height + 10);
            ((ImageProcessor)ip).setColor(Color.white);
            ip.fill();
            img = new ImagePlus(name, ip);
            img.show();
        }
        Roi roi = null;
        switch (type) {
            case 1: {
                img.setRoi(left, top, width, height);
                break;
            }
            case 2: {
                roi = new OvalRoi(left, top, width, height, img);
                img.setRoi(roi);
                break;
            }
            case 3: {
                int x1 = (int)this.getFloat(18);
                int y1 = (int)this.getFloat(22);
                int x2 = (int)this.getFloat(26);
                int y2 = (int)this.getFloat(30);
                break;
            }
            case 0: 
            case 7: 
            case 8: {
                if (n == 0) break;
                int[] x = new int[n];
                int[] y = new int[n];
                int base1 = 64;
                int base2 = base1 + 2 * n;
                int i = 0;
                while (i < n) {
                    int ytmp;
                    int xtmp = this.getShort(base1 + i * 2);
                    if (xtmp < 0) {
                        xtmp = 0;
                    }
                    if ((ytmp = this.getShort(base2 + i * 2)) < 0) {
                        ytmp = 0;
                    }
                    x[i] = left + xtmp;
                    y[i] = top + ytmp;
                    ++i;
                }
                int roiType = type == 0 ? 2 : (type == 7 ? 3 : 4);
                roi = new PolygonRoi(x, y, n, img, roiType);
                img.setRoi(roi);
                break;
            }
        }
    }

    int getByte(int base) {
        return this.data[base] & 0xFF;
    }

    int getShort(int base) {
        int b0 = this.data[base] & 0xFF;
        int b1 = this.data[base + 1] & 0xFF;
        return (short)((b0 << 8) + b1);
    }

    int getInt(int base) {
        int b0 = this.data[base] & 0xFF;
        int b1 = this.data[base + 1] & 0xFF;
        int b2 = this.data[base + 2] & 0xFF;
        int b3 = this.data[base + 3] & 0xFF;
        return (b0 << 24) + (b1 << 16) + (b2 << 8) + b3;
    }

    float getFloat(int base) {
        return Float.intBitsToFloat(this.getInt(base));
    }
}

