/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.io.OpenDialog;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamTokenizer;

public class PGM_Reader
extends ImagePlus
implements PlugIn {
    private int width;
    private int height;
    private boolean rawBits;

    public void run(String arg) {
        ImageProcessor ip;
        OpenDialog od = new OpenDialog("PGM Reader...", arg);
        String directory = od.getDirectory();
        String name = od.getFileName();
        if (name == null) {
            return;
        }
        String path = directory + name;
        IJ.showStatus("Opening: " + path);
        try {
            ip = this.openFile(path);
        }
        catch (Exception e) {
            IJ.showMessage("PGM Reader", e.getMessage());
            return;
        }
        this.setProcessor(name, ip);
        if (arg.equals("")) {
            this.show();
        }
    }

    public ImageProcessor openFile(String path) throws IOException {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(path));
        StreamTokenizer tok = new StreamTokenizer(is);
        tok.resetSyntax();
        tok.wordChars(33, 255);
        tok.whitespaceChars(0, 32);
        tok.parseNumbers();
        tok.eolIsSignificant(true);
        tok.commentChar(35);
        this.openHeader(tok);
        byte[] pixels = new byte[this.width * this.height];
        ByteProcessor ip = new ByteProcessor(this.width, this.height, pixels, null);
        if (this.rawBits) {
            this.openRawImage(is, this.width * this.height, pixels);
        } else {
            this.openAsciiImage(tok, this.width * this.height, pixels);
        }
        return ip;
    }

    public void openHeader(StreamTokenizer tok) throws IOException {
        String magicNumber = this.getWord(tok);
        if (magicNumber.equals("P5")) {
            this.rawBits = true;
        } else if (!magicNumber.equals("P2")) {
            throw new IOException("PGM files must start with \"P2\" or \"P5\"");
        }
        this.width = this.getInt(tok);
        this.height = this.getInt(tok);
        int maxValue = this.getInt(tok);
        if (this.width == -1 || this.height == -1 || maxValue == -1) {
            throw new IOException("Error opening PGM header..");
        }
        if (maxValue > 255) {
            throw new IOException("The maximum gray vale is larger than 255.");
        }
    }

    public void openAsciiImage(StreamTokenizer tok, int size, byte[] pixels) throws IOException {
        int i = 0;
        int inc = size / 20;
        while (tok.nextToken() != -1) {
            if (tok.ttype != -2) continue;
            pixels[i++] = (byte)((int)tok.nval & 0xFF);
            if (i % inc != 0) continue;
            IJ.showProgress(0.5 + (double)i / (double)size / 2.0);
        }
        IJ.showProgress(1.0);
    }

    public void openRawImage(InputStream is, int size, byte[] pixels) throws IOException {
        int count = 0;
        while (count < size && count >= 0) {
            count = is.read(pixels, count, size - count);
        }
    }

    String getWord(StreamTokenizer tok) throws IOException {
        while (tok.nextToken() != -1) {
            if (tok.ttype != -3) continue;
            return tok.sval;
        }
        return null;
    }

    int getInt(StreamTokenizer tok) throws IOException {
        while (tok.nextToken() != -1) {
            if (tok.ttype != -2) continue;
            return (int)tok.nval;
        }
        return -1;
    }
}

