/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.gui.ProfilePlot;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.measure.Calibration;
import ij.plugin.Plots;
import ij.plugin.PlotsCanvas;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Rectangle;

public class GelAnalyzer
implements PlugIn {
    static int saveID;
    static int nLanes;
    static Rectangle firstRect;
    static final int MAX_LANES = 100;
    static int[] y;
    static PlotsCanvas plotsCanvas;
    static boolean uncalibratedOD;
    static boolean labelWithPercentages;
    boolean invertedLut;
    static /* synthetic */ Class class$ij$plugin$GelAnalyzer;

    public void run(String arg) {
        Roi roi;
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            IJ.noImage();
            return;
        }
        if (arg.equals("reset")) {
            nLanes = 0;
            saveID = imp.getID();
            if (plotsCanvas != null) {
                plotsCanvas.reset();
            }
            return;
        }
        if (arg.equals("percent") && plotsCanvas != null) {
            plotsCanvas.displayPercentages();
            return;
        }
        if (arg.equals("label") && plotsCanvas != null) {
            if (GelAnalyzer.plotsCanvas.counter == 0) {
                this.show("There are no peak area measurements.");
            } else {
                plotsCanvas.labelPeaks();
            }
            return;
        }
        if (arg.equals("options")) {
            GenericDialog gd = new GenericDialog("Gel Analyzer Options...", IJ.getInstance());
            gd.addCheckbox("Uncalibrated OD", uncalibratedOD);
            gd.addCheckbox("Label with Percentages", labelWithPercentages);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return;
            }
            uncalibratedOD = gd.getNextBoolean();
            labelWithPercentages = gd.getNextBoolean();
            return;
        }
        if (imp.getID() != saveID) {
            nLanes = 0;
            saveID = imp.getID();
        }
        if ((roi = imp.getRoi()) != null && arg.equals("perimeter")) {
            IJ.write("Perimeter: " + roi.getLength());
            return;
        }
        if (roi == null || roi.getType() != 0) {
            this.show("Rectangular selection required.");
            return;
        }
        this.invertedLut = imp.isInvertedLut();
        Rectangle rect = roi.getBoundingRect();
        if (nLanes == 0) {
            IJ.register(class$ij$plugin$GelAnalyzer == null ? (class$ij$plugin$GelAnalyzer = GelAnalyzer.class$("ij.plugin.GelAnalyzer")) : class$ij$plugin$GelAnalyzer);
        }
        if (arg.equals("first")) {
            this.selectFirstLane(rect);
            return;
        }
        if (nLanes == 0) {
            this.show("You must first use the \"Outline First Lane\" command.");
            return;
        }
        if (arg.equals("next")) {
            this.selectNextLane(rect);
            return;
        }
        if (arg.equals("plot")) {
            if (rect.y != y[nLanes]) {
                this.selectNextLane(rect);
            }
            this.plotLanes(imp);
            return;
        }
    }

    void selectFirstLane(Rectangle rect) {
        if (rect.height >= rect.width) {
            this.show("Lanes must be horizontal.");
            return;
        }
        IJ.showStatus("Lane 1 selected");
        firstRect = rect;
        nLanes = 1;
        GelAnalyzer.y[1] = rect.y;
    }

    void selectNextLane(Rectangle rect) {
        if (rect.width != GelAnalyzer.firstRect.width || rect.height != GelAnalyzer.firstRect.height) {
            this.show("Selections must all be the same size.");
            return;
        }
        if (nLanes < 100) {
            ++nLanes;
        }
        IJ.showStatus("Lane " + nLanes + " selected");
        GelAnalyzer.y[GelAnalyzer.nLanes] = rect.y;
    }

    double od(double v) {
        if (this.invertedLut) {
            if (v == 255.0) {
                v = 254.5;
            }
            return 0.434294481 * Math.log(255.0 / (255.0 - v));
        }
        if (v == 0.0) {
            v = 0.5;
        }
        return 0.434294481 * Math.log(255.0 / v);
    }

    void plotLanes(ImagePlus imp) {
        int plotHeight;
        Calibration cal = imp.getCalibration();
        if (uncalibratedOD) {
            cal.setFunction(21, null, "Uncalibrated OD");
        } else if (cal.getFunction() == 21) {
            cal.setFunction(20, null, "Gray Value");
        }
        int topMargin = 16;
        int bottomBorder = 2;
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        double[][] profiles = new double[101][];
        IJ.showStatus("Plotting " + nLanes + " lanes");
        int i = 1;
        while (i <= nLanes) {
            imp.setRoi(GelAnalyzer.firstRect.x, y[i], GelAnalyzer.firstRect.width, GelAnalyzer.firstRect.height);
            ProfilePlot pp = new ProfilePlot(imp);
            profiles[i] = pp.getProfile();
            if (pp.getMin() < min) {
                min = pp.getMin();
            }
            if (pp.getMax() > max) {
                max = pp.getMax();
            }
            ++i;
        }
        int plotWidth = GelAnalyzer.firstRect.width;
        if (plotWidth < 500) {
            plotWidth = 500;
        }
        if (plotWidth > 2 * GelAnalyzer.firstRect.width) {
            plotWidth = 2 * GelAnalyzer.firstRect.width;
        }
        if ((plotHeight = plotWidth / 2) < 200) {
            plotHeight = 200;
        }
        if (plotHeight > 400) {
            plotHeight = 400;
        }
        ByteProcessor ip = new ByteProcessor(plotWidth, topMargin + nLanes * plotHeight + bottomBorder);
        ((ImageProcessor)ip).setColor(Color.white);
        ip.fill();
        ((ImageProcessor)ip).setColor(Color.black);
        int h = ip.getHeight();
        ip.moveTo(0, 0);
        ip.lineTo(plotWidth - 1, 0);
        ip.lineTo(plotWidth - 1, h - 1);
        ip.lineTo(0, h - 1);
        ip.lineTo(0, 0);
        ip.moveTo(0, h - 2);
        ip.lineTo(plotWidth - 1, h - 2);
        String s = imp.getTitle() + "; ";
        s = cal.calibrated() ? s + cal.getValueUnit() : s + "**Uncalibrated**";
        ip.moveTo(5, topMargin);
        ip.drawString(s);
        double xScale = (double)plotWidth / (double)profiles[1].length;
        double yScale = max - min == 0.0 ? 1.0 : (double)plotHeight / (max - min);
        int i2 = 1;
        while (i2 <= nLanes) {
            double[] profile = profiles[i2];
            int top = (i2 - 1) * plotHeight + topMargin;
            int base = top + plotHeight;
            ip.moveTo(0, base);
            ip.lineTo((int)((double)profile.length * xScale), base);
            ip.moveTo(0, base - (int)((profile[0] - min) * yScale));
            int j = 1;
            while (j < profile.length) {
                ip.lineTo((int)((double)j * xScale + 0.5), base - (int)((profile[j] - min) * yScale + 0.5));
                ++j;
            }
            ++i2;
        }
        Plots plots = new Plots();
        plots.setProcessor("Plots", ip);
        ip.setThreshold(0.0, 0.0, 2);
        ((ImagePlus)plots).show();
        nLanes = 0;
        saveID = 0;
        Toolbar toolbar = Toolbar.getInstance();
        toolbar.setColor(Color.black);
        toolbar.setTool(4);
        ImageWindow win = WindowManager.getCurrentWindow();
        plotsCanvas = (PlotsCanvas)win.getCanvas();
    }

    void show(String msg) {
        IJ.showMessage("Gel Analyzer", msg);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        nLanes = 0;
        y = new int[101];
        uncalibratedOD = true;
        labelWithPercentages = true;
    }
}

