/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.process.ColorProcessor;
import java.awt.Color;

class ColorGenerator
extends ColorProcessor {
    int w;
    int h;
    int[] colors = new int[]{0x8B0000, 0xCD5C5C, 0xFF0000, 16758465, 14381203, 16716947, 0x800080, 12211667, 0xEE82EE, 0xFF00FF, 4734347, 205, 255, 11584734, 49151, 6266528, 65535, 2142890, 6737322, 64154, 0x228B22, 65280, 10145074, 0x808000, 0xFFFF00, 12433259, 15787660, 12092939, 16762880, 16768685, 16750080, 13789470, 0xFF5000, 15308410, 16768732, 16772043};

    public ColorGenerator(int width, int height, int[] pixels) {
        super(width, height, pixels);
    }

    void drawColors(int colorWidth, int colorHeight, int columns, int rows) {
        this.w = colorWidth;
        this.h = colorHeight;
        this.drawColor(0, 0, Color.black);
        this.drawRamp();
        this.drawColor(columns - 1, 0, Color.white);
        int x = 0;
        int y = 1;
        int i = 0;
        while (i < this.colors.length) {
            this.drawColor(x, y, new Color(this.colors[i]));
            if (++x == columns) {
                x = 0;
                if (++y == rows) break;
            }
            ++i;
        }
        this.setRoi(null);
    }

    void drawColor(int x, int y, Color c) {
        this.setRoi(x * this.w, y * this.h, this.w, this.h);
        this.setColor(c);
        this.fill();
    }

    void drawRamp() {
        int y = 0;
        while (y < this.h) {
            int x = this.w;
            while (x < this.w + 256) {
                byte b;
                byte g = b = (byte)(x - this.w);
                byte r = b;
                this.pixels[y * this.width + x] = 0xFF000000 | r << 16 & 0xFF0000 | g << 8 & 0xFF00 | b & 0xFF;
                ++x;
            }
            ++y;
        }
    }
}

