/*
 * Decompiled with CFR 0.152.
 */
package ij.measure;

import ij.ImagePlus;
import ij.measure.CurveFitter;

public class Calibration {
    public static final int STRAIGHT_LINE = 0;
    public static final int POLY2 = 1;
    public static final int POLY3 = 2;
    public static final int POLY4 = 3;
    public static final int EXPONENTIAL = 4;
    public static final int POWER = 5;
    public static final int LOG = 6;
    public static final int RODBARD = 7;
    public static final int GAMMA_VARIATE = 8;
    public static final int NONE = 20;
    public static final int UNCALIBRATED_OD = 21;
    public double pixelWidth = 1.0;
    public double pixelHeight = 1.0;
    public double pixelDepth = 1.0;
    public int xOrigin;
    public int yOrigin;
    public boolean invertY;
    private double[] coefficients;
    private String unit = "pixel";
    private String units;
    private String valueUnit = "Gray Value";
    private int function = 20;
    private float[] cTable;
    private boolean invertedLut;
    private int bitDepth = 8;

    public Calibration(ImagePlus imp) {
        if (imp != null) {
            if (imp.getType() == 1) {
                this.bitDepth = 16;
            }
            this.invertedLut = imp.isInvertedLut();
        }
    }

    public Calibration() {
    }

    public boolean scaled() {
        return this.pixelWidth != 1.0 || this.pixelHeight != 1.0;
    }

    public void setUnit(String unit) {
        this.unit = unit == null ? "pixel" : unit;
        this.units = null;
    }

    public String getUnit() {
        return this.unit;
    }

    public String getUnits() {
        if (this.units == null) {
            this.units = this.unit.equals("pixel") ? "pixels" : (this.unit.equals("micron") ? "microns" : (this.unit.equals("inch") ? "inches" : this.unit));
        }
        return this.units;
    }

    public double getX(int x) {
        return (double)(x - this.xOrigin) * this.pixelWidth;
    }

    public double getY(int y) {
        return (double)(y - this.yOrigin) * this.pixelHeight;
    }

    public void setFunction(int function, double[] coefficients, String unit) {
        if (function == 20) {
            this.disableDensityCalibration();
            return;
        }
        if (coefficients == null && function >= 0 && function <= 8) {
            return;
        }
        this.function = function;
        this.coefficients = coefficients;
        if (unit != null) {
            this.valueUnit = unit;
        }
        this.cTable = null;
    }

    public void disableDensityCalibration() {
        this.function = 20;
        this.coefficients = null;
        this.cTable = null;
        this.valueUnit = "Gray Value";
    }

    public String getValueUnit() {
        return this.valueUnit;
    }

    public double[] getCoefficients() {
        return this.coefficients;
    }

    public boolean calibrated() {
        return this.function != 20;
    }

    public int getFunction() {
        return this.function;
    }

    public float[] getCTable() {
        if (this.cTable == null) {
            this.makeCTable();
        }
        return this.cTable;
    }

    void makeCTable() {
        if (this.bitDepth == 16) {
            this.make16BitCTable();
            return;
        }
        if (this.function == 21) {
            this.cTable = new float[256];
            int i = 0;
            while (i < 256) {
                this.cTable[i] = (float)this.od(i);
                ++i;
            }
        } else if (this.function >= 0 && this.function <= 8 && this.coefficients != null) {
            this.cTable = new float[256];
            int i = 0;
            while (i < 256) {
                this.cTable[i] = (float)CurveFitter.f(this.function, this.coefficients, i);
                ++i;
            }
        } else {
            this.cTable = null;
        }
    }

    void make16BitCTable() {
        if (this.function >= 0 && this.function <= 8 && this.coefficients != null) {
            this.cTable = new float[65536];
            int i = 0;
            while (i < 65536) {
                this.cTable[i] = (float)CurveFitter.f(this.function, this.coefficients, i);
                ++i;
            }
        } else {
            this.cTable = null;
        }
    }

    double od(double v) {
        if (this.invertedLut) {
            if (v == 255.0) {
                v = 254.5;
            }
            return 0.434294481 * Math.log(255.0 / (255.0 - v));
        }
        if (v == 0.0) {
            v = 0.5;
        }
        return 0.434294481 * Math.log(255.0 / v);
    }

    public double getCValue(int value) {
        if (this.function == 20) {
            return value;
        }
        if (this.function >= 0 && this.function <= 8 && this.coefficients != null) {
            return CurveFitter.f(this.function, this.coefficients, value);
        }
        if (this.cTable == null) {
            this.makeCTable();
        }
        if (this.cTable != null && value >= 0 && value < this.cTable.length) {
            return this.cTable[value];
        }
        return value;
    }

    public Calibration copy() {
        Calibration copy = new Calibration();
        copy.pixelWidth = this.pixelWidth;
        copy.pixelHeight = this.pixelHeight;
        copy.pixelDepth = this.pixelDepth;
        copy.unit = this.unit;
        copy.units = this.units;
        copy.valueUnit = this.valueUnit;
        copy.function = this.function;
        copy.coefficients = this.coefficients;
        copy.cTable = this.cTable;
        copy.invertedLut = this.invertedLut;
        copy.bitDepth = this.bitDepth;
        return copy;
    }

    public String toString() {
        return "w=" + this.pixelWidth + ", h=" + this.pixelHeight + ", d=" + this.pixelDepth + ", unit=" + this.unit + ", f=" + this.function + ", nc=" + (this.coefficients != null ? "" + this.coefficients.length : "null") + ", table=" + (this.cTable != null ? "" + this.cTable.length : "null") + ", vunit=" + this.valueUnit;
    }
}

