/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.IJ;
import ij.ImageJ;
import ij.io.OpenDialog;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;

public class SaveDialog {
    private String dir;
    private String name;

    public SaveDialog(String title, String defaultName, String extension) {
        String defaultDir;
        ImageJ ij = IJ.getInstance();
        Frame parent = ij != null ? ij : new Frame();
        FileDialog fd = new FileDialog(parent, title, 1);
        if (defaultName != null) {
            int dotIndex;
            if (defaultName != null && (dotIndex = defaultName.lastIndexOf(".")) >= 0) {
                defaultName = defaultName.substring(0, dotIndex) + extension;
            }
            fd.setFile(defaultName);
        }
        if ((defaultDir = OpenDialog.getDefaultDirectory()) != null) {
            fd.setDirectory(defaultDir);
        }
        ((Component)fd).setVisible(true);
        this.name = fd.getFile();
        this.dir = fd.getDirectory();
        if (this.name != null && this.dir != null) {
            OpenDialog.setDefaultDirectory(this.dir);
        }
        fd.dispose();
        if (ij == null) {
            parent.dispose();
        }
        IJ.showStatus(title + ": " + this.dir + this.name);
    }

    public String getDirectory() {
        return this.dir;
    }

    public String getFileName() {
        return this.name;
    }
}

