/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Hashtable;

public class PluginClassLoader
extends ClassLoader {
    String path;
    Hashtable cache = new Hashtable();

    public PluginClassLoader(String path) {
        this.path = path;
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class c;
        block5: {
            c = (Class)this.cache.get(name);
            if (c == null) {
                try {
                    return this.findSystemClass(name);
                }
                catch (ClassNotFoundException e) {
                    c = this.loadIt(this.path, name);
                    if (c == null) {
                        c = this.loadFromSubdirectory(this.path, name);
                    }
                    if (c != null) break block5;
                    throw new ClassNotFoundException(name);
                }
            }
        }
        if (c != null && resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    Class loadIt(String path, String classname) {
        String filename = classname.replace('.', '/');
        filename = filename + ".class";
        File fullname = new File(path, filename);
        try {
            FileInputStream is = new FileInputStream(fullname);
            int bufsize = (int)fullname.length();
            byte[] buf = new byte[bufsize];
            ((InputStream)is).read(buf, 0, bufsize);
            ((InputStream)is).close();
            Class<?> c = this.defineClass(classname, buf, 0, buf.length);
            this.cache.put(classname, c);
            return c;
        }
        catch (Exception e) {
            return null;
        }
    }

    Class loadFromSubdirectory(String path, String name) {
        String separator = System.getProperty("file.separator");
        File f = new File(path);
        String[] list = f.list();
        if (list != null) {
            int i = 0;
            while (i < list.length) {
                Class c;
                f = new File(path, list[i]);
                if (f.isDirectory() && (c = this.loadIt(path + list[i], name)) != null) {
                    return c;
                }
                ++i;
            }
        }
        return null;
    }
}

