/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.Undo;
import ij.WindowManager;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Line;
import ij.gui.Toolbar;
import ij.measure.Calibration;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

public class Roi
implements Cloneable {
    public static final int CONSTRUCTING = 0;
    public static final int MOVING = 1;
    public static final int RESIZING = 2;
    public static final int NORMAL = 3;
    public static final int RECTANGLE = 0;
    public static final int OVAL = 1;
    public static final int POLYGON = 2;
    public static final int FREEROI = 3;
    public static final int TRACED_ROI = 4;
    public static final int LINE = 5;
    public static final int POLYLINE = 6;
    public static final int FREELINE = 7;
    public static final int HANDLE_SIZE = 4;
    int startX;
    int startY;
    int x;
    int y;
    int width;
    int height;
    int state;
    public static Roi previousRoi = null;
    protected static Color ROIColor = Prefs.getColor("roicolor", Color.yellow);
    protected static int pasteMode = 0;
    protected int type;
    protected int xMax;
    protected int yMax;
    protected ImagePlus imp;
    protected ImageCanvas ic;
    protected int oldX;
    protected int oldY;
    protected int oldWidth;
    protected int oldHeight;
    protected int clipX;
    protected int clipY;
    protected int clipWidth;
    protected int clipHeight;
    protected ImagePlus clipboard = null;
    protected boolean constrain = false;
    protected boolean updateFullWindow;

    public Roi(int x, int y, int width, int height, ImagePlus imp) {
        this.setImage(imp);
        if (width > this.xMax) {
            width = this.xMax;
        }
        if (height > this.yMax) {
            height = this.yMax;
        }
        this.setLocation(x, y);
        this.width = width;
        this.height = height;
        this.oldWidth = width;
        this.oldHeight = height;
        this.clipX = x;
        this.clipY = y;
        this.clipWidth = width;
        this.clipHeight = height;
        this.state = 3;
        Graphics g = this.ic.getGraphics();
        this.draw(g);
        g.dispose();
        this.type = 0;
    }

    public Roi(int x, int y, ImagePlus imp) {
        if (imp != null) {
            this.setImage(imp);
        }
        this.setLocation(x, y);
        this.width = 0;
        this.height = 0;
        this.state = 0;
        this.type = 0;
    }

    public void setLocation(int x, int y) {
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        if (x + this.width > this.xMax) {
            x = this.xMax - this.width;
        }
        if (y + this.height > this.yMax) {
            y = this.yMax - this.height;
        }
        this.x = x;
        this.y = y;
        this.startX = x;
        this.startY = y;
        this.oldX = x;
        this.oldY = y;
        this.oldWidth = 0;
        this.oldHeight = 0;
    }

    public void setImage(ImagePlus imp) {
        this.imp = imp;
        ImageWindow win = imp.getWindow();
        if (win != null) {
            this.ic = win.getCanvas();
        }
        this.xMax = imp.getWidth();
        this.yMax = imp.getHeight();
    }

    public int getType() {
        return this.type;
    }

    public int getState() {
        return this.state;
    }

    public double getLength() {
        return 2 * (this.width + this.height);
    }

    public Rectangle getBoundingRect() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized Object clone() {
        try {
            void e;
            Roi r = (Roi)super.clone();
            previousRoi = null;
            r.imp = null;
            return e;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    protected void grow(int xNew, int yNew) {
        if (this.clipboard != null) {
            return;
        }
        if (xNew < 0) {
            xNew = 0;
        }
        if (yNew < 0) {
            yNew = 0;
        }
        if (this.constrain) {
            int dx = xNew - this.x;
            int dy = yNew - this.y;
            int d = dx < dy ? dx : dy;
            xNew = this.x + d;
            yNew = this.y + d;
        }
        this.width = Math.abs(xNew - this.startX);
        this.height = Math.abs(yNew - this.startY);
        this.x = xNew >= this.startX ? this.startX : this.startX - this.width;
        int n = this.y = yNew >= this.startY ? this.startY : this.startY - this.height;
        if (this.x + this.width > this.xMax) {
            this.width = this.xMax - this.x;
        }
        if (this.y + this.height > this.yMax) {
            this.height = this.yMax - this.y;
        }
        this.updateClipRect();
        this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
        this.oldX = this.x;
        this.oldY = this.y;
        this.oldWidth = this.width;
        this.oldHeight = this.height;
    }

    void move(int xNew, int yNew) {
        this.x += xNew - this.startX;
        this.y += yNew - this.startY;
        if (this.x < 0) {
            this.x = 0;
        }
        if (this.y < 0) {
            this.y = 0;
        }
        if (this.x + this.width > this.xMax) {
            this.x = this.xMax - this.width;
        }
        if (this.y + this.height > this.yMax) {
            this.y = this.yMax - this.height;
        }
        this.startX = xNew;
        this.startY = yNew;
        this.updateClipRect();
        this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
        this.oldX = this.x;
        this.oldY = this.y;
    }

    public void nudge(int key) {
        switch (key) {
            case 38: {
                --this.y;
                if (this.y >= 0) break;
                this.y = 0;
                break;
            }
            case 40: {
                ++this.y;
                if (this.y + this.height < this.yMax) break;
                this.y = this.yMax - this.height;
                break;
            }
            case 37: {
                --this.x;
                if (this.x >= 0) break;
                this.x = 0;
                break;
            }
            case 39: {
                ++this.x;
                if (this.x + this.width < this.xMax) break;
                this.x = this.xMax - this.width;
            }
        }
        this.updateClipRect();
        this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
        this.oldX = this.x;
        this.oldY = this.y;
    }

    public void nudgeCorner(int key) {
        if (this.type > 1 || this.clipboard != null) {
            return;
        }
        switch (key) {
            case 38: {
                --this.height;
                if (this.height >= 1) break;
                this.height = 1;
                break;
            }
            case 40: {
                ++this.height;
                if (this.y + this.height <= this.yMax) break;
                this.height = this.yMax - this.y;
                break;
            }
            case 37: {
                --this.width;
                if (this.width >= 1) break;
                this.width = 1;
                break;
            }
            case 39: {
                ++this.width;
                if (this.x + this.width <= this.xMax) break;
                this.width = this.xMax - this.x;
            }
        }
        this.updateClipRect();
        this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
        this.oldX = this.x;
        this.oldY = this.y;
    }

    protected void updateClipRect() {
        this.clipX = this.x <= this.oldX ? this.x : this.oldX;
        this.clipY = this.y <= this.oldY ? this.y : this.oldY;
        this.clipWidth = (this.x + this.width >= this.oldX + this.oldWidth ? this.x + this.width : this.oldX + this.oldWidth) - this.clipX + 1;
        this.clipHeight = (this.y + this.height >= this.oldY + this.oldHeight ? this.y + this.height : this.oldY + this.oldHeight) - this.clipY + 1;
        double mag = this.ic.getMagnification();
        if (mag < 1.0) {
            this.clipWidth += (int)(1.0 / mag);
            this.clipHeight += (int)(1.0 / mag);
        }
    }

    protected void handleMouseDrag(int sx, int sy, boolean constrain) {
        this.constrain = constrain;
        int ox = this.ic.offScreenX(sx);
        int oy = this.ic.offScreenY(sy);
        switch (this.state) {
            case 0: {
                this.grow(ox, oy);
                break;
            }
            case 1: {
                this.move(ox, oy);
                break;
            }
        }
    }

    int getHandleSize() {
        double mag = this.ic.getMagnification();
        double size = 4.0 / mag;
        return (int)(size * mag);
    }

    public void draw(Graphics g) {
        double mag = this.ic.getMagnification();
        g.setColor(ROIColor);
        int sx1 = this.ic.screenX(this.x);
        int sy1 = this.ic.screenY(this.y);
        int sx2 = sx1 + (int)((double)this.width * mag) - 1;
        int sy2 = sy1 + (int)((double)this.height * mag) - 1;
        g.drawRect(sx1, sy1, sx2 - sx1, sy2 - sy1);
        if (sx2 - sx1 > 2 && sy2 - sy1 > 2) {
            int handleSize = this.getHandleSize();
            g.fillRect(sx2 - 4, sy2 - 4, 4, 4);
        }
        this.showStatus();
        if (this.updateFullWindow) {
            this.updateFullWindow = false;
            this.imp.draw();
        }
    }

    public void drawPixels() {
        this.endPaste();
        ImageProcessor ip = this.imp.getProcessor();
        ip.moveTo(this.x, this.y);
        ip.lineTo(this.x + this.width - 1, this.y);
        ip.lineTo(this.x + this.width - 1, this.y + this.height - 1);
        ip.lineTo(this.x, this.y + this.height - 1);
        ip.lineTo(this.x, this.y);
        if (Line.getWidth() > 1) {
            this.updateFullWindow = true;
        }
    }

    public boolean contains(int x, int y) {
        Rectangle r = new Rectangle(this.x, this.y, this.width, this.height);
        return r.contains(x, y);
    }

    boolean insideHandle(int sx, int sy) {
        if (this.type != 0) {
            return false;
        }
        return sx >= this.ic.screenX(this.x + this.width) - 8 && sy >= this.ic.screenY(this.y + this.height) - 8;
    }

    protected void handleMouseDown(int sx, int sy) {
        if (this.state == 3) {
            if (this.insideHandle(sx, sy)) {
                this.state = 0;
                this.startX = this.x;
                this.startY = this.y;
            } else {
                this.state = 1;
                this.startX = this.ic.offScreenX(sx);
                this.startY = this.ic.offScreenY(sy);
            }
            this.showStatus();
        }
    }

    protected void handleMouseUp(int screenX, int screenY) {
        this.state = 3;
    }

    protected void showStatus() {
        String value;
        if (this.state != 0 && this.type == 0 && this.width <= 25 && this.height <= 25) {
            ImageProcessor ip = this.imp.getProcessor();
            double v = ip.getPixelValue(this.x, this.y);
            int digits = this.imp.getType() == 0 || this.imp.getType() == 1 ? 0 : 2;
            value = ", value=" + IJ.d2s(v, digits);
        } else {
            value = "";
        }
        Calibration cal = this.imp.getCalibration();
        if (cal.scaled()) {
            IJ.showStatus("Location = (" + IJ.d2s((double)this.x * cal.pixelWidth) + "," + IJ.d2s((double)this.y * cal.pixelHeight) + "), width=" + IJ.d2s((double)this.width * cal.pixelWidth) + ", height=" + IJ.d2s((double)this.height * cal.pixelHeight) + value);
        } else {
            IJ.showStatus("Location = (" + this.x + "," + this.y + "), width=" + this.width + ", height=" + this.height + value);
        }
    }

    public int[] getMask() {
        return null;
    }

    void startPaste(ImagePlus clipboard) {
        IJ.showStatus("Pasting...");
        this.imp.getProcessor().snapshot();
        this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
        Toolbar.getInstance().setTool(0);
        this.clipboard = clipboard;
    }

    void updatePaste() {
        if (this.clipboard != null) {
            ImageProcessor ip = this.imp.getProcessor();
            ip.reset();
            ip.copyBits(this.clipboard.getProcessor(), this.x, this.y, pasteMode);
            this.ic.setImageUpdated();
        }
    }

    public void endPaste() {
        if (this.clipboard != null) {
            ImageProcessor ip = this.imp.getProcessor();
            if (pasteMode != 0) {
                ip.reset();
            }
            ip.copyBits(this.clipboard.getProcessor(), this.x, this.y, pasteMode);
            ip.snapshot();
            this.clipboard = null;
            this.imp.updateAndDraw();
            Undo.setup(1, this.imp);
        }
    }

    public void abortPaste() {
        this.clipboard = null;
        this.imp.getProcessor().reset();
        this.imp.updateAndDraw();
    }

    public double getAngle(int x1, int y1, int x2, int y2) {
        double dx = x2 - x1;
        double dy = y1 - y2;
        double angle = dx != 0.0 ? Math.atan(dy / dx) : (dy >= 0.0 ? 1.5707963267948966 : -1.5707963267948966);
        angle = 57.29577951308232 * angle;
        int quadrant = dx >= 0.0 && dy >= 0.0 ? 0 : (dx < 0.0 ? 2 : 3);
        switch (quadrant) {
            case 0: {
                break;
            }
            case 2: {
                angle += 180.0;
                break;
            }
            case 3: {
                angle += 360.0;
            }
        }
        return angle;
    }

    public static Color getColor() {
        return ROIColor;
    }

    public static void setColor(Color c) {
        ROIColor = c;
    }

    public static void setPasteMode(int transferMode) {
        int previousMode = pasteMode;
        pasteMode = transferMode;
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            return;
        }
        if (previousMode != 0) {
            ImageProcessor ip = imp.getProcessor();
            ip.reset();
            if (pasteMode != 0) {
                // empty if block
            }
        }
        imp.updateAndDraw();
    }

    public String toString() {
        return "Roi: type=" + this.type + ", x=" + this.x + ", y=" + this.y + ", width=" + this.width + ", height=" + this.height;
    }
}

