/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.MultiLineLabel;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class GenericDialog
extends Dialog
implements ActionListener {
    public static final int MAX_ITEMS = 20;
    private TextField[] numberField;
    private double[] defaultValues;
    private String[] defaultText;
    private TextField[] stringField;
    private Checkbox[] checkbox;
    private Choice[] choice;
    private Button cancel;
    private Button okay;
    private TextArea textArea1;
    private TextArea textArea2;
    private boolean wasCanceled;
    private int y;
    private int nfIndex;
    private int sfIndex;
    private int cbIndex;
    private int choiceIndex;
    private GridBagLayout grid = new GridBagLayout();
    private GridBagConstraints c = new GridBagConstraints();
    private boolean firstNumericField = true;
    private boolean firstStringField = true;
    private boolean firstCheckbox = true;
    private boolean firstChoice = true;
    private boolean invalidNumber;
    private boolean firstPaint = true;

    public GenericDialog(String title) {
        super(WindowManager.getCurrentImage() != null ? WindowManager.getCurrentImage().getWindow() : IJ.getInstance(), title, true);
        this.setLayout(this.grid);
    }

    public GenericDialog(String title, Frame parent) {
        super(parent, title, true);
        this.setLayout(this.grid);
    }

    public void addNumericField(String label, double defaultValue, int digits) {
        Label theLabel = this.makeLabel(label);
        this.c.gridx = 0;
        this.c.gridy = this.y;
        this.c.anchor = 13;
        this.c.gridwidth = 1;
        this.c.insets = this.firstNumericField ? new Insets(5, 0, 3, 0) : new Insets(0, 0, 3, 0);
        this.grid.setConstraints(theLabel, this.c);
        this.add(theLabel);
        if (this.numberField == null) {
            this.numberField = new TextField[20];
            this.defaultValues = new double[20];
            this.defaultText = new String[20];
        }
        this.numberField[this.nfIndex] = new TextField(IJ.d2s(defaultValue, digits), 6);
        this.numberField[this.nfIndex].addActionListener(this);
        this.defaultValues[this.nfIndex] = defaultValue;
        this.defaultText[this.nfIndex] = this.numberField[this.nfIndex].getText();
        this.c.gridx = 1;
        this.c.gridy = this.y;
        this.c.anchor = 17;
        this.grid.setConstraints(this.numberField[this.nfIndex], this.c);
        this.numberField[this.nfIndex].setEditable(true);
        if (this.firstNumericField) {
            this.numberField[this.nfIndex].selectAll();
        }
        this.firstNumericField = false;
        this.add(this.numberField[this.nfIndex]);
        ++this.y;
        ++this.nfIndex;
    }

    private Label makeLabel(String label) {
        if (IJ.isMacintosh()) {
            label = label + " ";
        }
        return new Label(label);
    }

    public void addStringField(String label, String defaultText) {
        this.addStringField(label, defaultText, 8);
    }

    public void addStringField(String label, String defaultText, int columns) {
        Label theLabel = this.makeLabel(label);
        this.c.gridx = 0;
        this.c.gridy = this.y;
        this.c.anchor = 13;
        this.c.gridwidth = 1;
        this.c.insets = this.firstStringField ? new Insets(5, 0, 5, 0) : new Insets(0, 0, 5, 0);
        this.grid.setConstraints(theLabel, this.c);
        this.add(theLabel);
        if (this.stringField == null) {
            this.stringField = new TextField[20];
        }
        this.stringField[this.sfIndex] = new TextField(defaultText, columns);
        this.stringField[this.sfIndex].addActionListener(this);
        this.c.gridx = 1;
        this.c.gridy = this.y++;
        this.c.anchor = 17;
        this.grid.setConstraints(this.stringField[this.sfIndex], this.c);
        this.stringField[this.sfIndex].setEditable(true);
        this.add(this.stringField[this.sfIndex]);
        ++this.sfIndex;
    }

    public void addCheckbox(String label, boolean defaultValue) {
        if (this.checkbox == null) {
            this.checkbox = new Checkbox[20];
        }
        this.checkbox[this.cbIndex] = new Checkbox(label);
        this.c.gridx = 0;
        this.c.gridy = this.y;
        this.c.gridwidth = 2;
        this.c.anchor = 17;
        this.c.insets = this.firstCheckbox ? new Insets(15, 20, 0, 0) : new Insets(0, 20, 0, 0);
        this.firstCheckbox = false;
        this.grid.setConstraints(this.checkbox[this.cbIndex], this.c);
        this.checkbox[this.cbIndex].setState(defaultValue);
        this.add(this.checkbox[this.cbIndex]);
        ++this.y;
        ++this.cbIndex;
    }

    public void addCheckboxGroup(int rows, int columns, String[] labels, boolean[] defaultValues) {
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(rows, columns, 10, 0));
        int startCBIndex = this.cbIndex;
        int i1 = 0;
        int[] index = new int[labels.length];
        if (this.checkbox == null) {
            this.checkbox = new Checkbox[20];
        }
        int row = 0;
        while (row < rows) {
            int col = 0;
            while (col < columns) {
                int i2 = col * rows + row;
                if (i2 >= labels.length) break;
                index[i1] = i2;
                this.checkbox[this.cbIndex] = new Checkbox(labels[i1]);
                this.checkbox[this.cbIndex].setState(defaultValues[i1]);
                ++this.cbIndex;
                ++i1;
                ++col;
            }
            ++row;
        }
        int i = 0;
        while (i < i1) {
            panel.add(this.checkbox[startCBIndex + index[i]]);
            ++i;
        }
        this.c.gridx = 0;
        this.c.gridy = this.y++;
        this.c.gridwidth = 2;
        this.c.anchor = 17;
        this.c.insets = new Insets(10, 0, 0, 0);
        this.grid.setConstraints(panel, this.c);
        this.add(panel);
    }

    public void addChoice(String label, String[] items, String defaultItem) {
        Label theLabel = this.makeLabel(label);
        this.c.gridx = 0;
        this.c.gridy = this.y;
        this.c.anchor = 13;
        this.c.gridwidth = 1;
        this.c.insets = this.firstChoice ? new Insets(5, 0, 5, 0) : new Insets(0, 0, 5, 0);
        this.grid.setConstraints(theLabel, this.c);
        this.add(theLabel);
        if (this.choice == null) {
            this.choice = new Choice[20];
        }
        this.choice[this.choiceIndex] = new Choice();
        int i = 0;
        while (i < items.length) {
            this.choice[this.choiceIndex].addItem(items[i]);
            ++i;
        }
        this.choice[this.choiceIndex].select(defaultItem);
        this.c.gridx = 1;
        this.c.gridy = this.y++;
        this.c.anchor = 17;
        this.grid.setConstraints(this.choice[this.choiceIndex], this.c);
        this.firstChoice = false;
        this.add(this.choice[this.choiceIndex]);
        ++this.choiceIndex;
    }

    public void addMessage(String text) {
        Component theLabel = text.indexOf(10) >= 0 ? new MultiLineLabel(text) : new Label(text);
        this.c.gridx = 0;
        this.c.gridy = this.y;
        this.c.gridwidth = 2;
        this.c.anchor = 17;
        this.c.insets = new Insets(text.equals("") ? 0 : 10, 20, 0, 0);
        this.grid.setConstraints(theLabel, this.c);
        this.add(theLabel);
        ++this.y;
    }

    public void addTextAreas(String text1, String text2, int rows, int columns) {
        if (this.textArea1 != null) {
            return;
        }
        Panel panel = new Panel();
        this.textArea1 = new TextArea(text1, rows, columns, 3);
        panel.add(this.textArea1);
        if (text2 != null) {
            this.textArea2 = new TextArea(text2, rows, columns, 3);
            panel.add(this.textArea2);
        }
        this.c.gridx = 0;
        this.c.gridy = this.y++;
        this.c.gridwidth = 2;
        this.c.anchor = 17;
        this.c.insets = new Insets(15, 20, 0, 0);
        this.grid.setConstraints(panel, this.c);
        this.add(panel);
    }

    public boolean wasCanceled() {
        return this.wasCanceled;
    }

    public double getNextNumber() {
        Double d;
        if (this.numberField == null || this.numberField[this.nfIndex] == null) {
            return -1.0;
        }
        String theText = this.numberField[this.nfIndex].getText();
        String originalText = this.defaultText[this.nfIndex];
        double defaultValue = this.defaultValues[this.nfIndex];
        ++this.nfIndex;
        if (theText.equals(originalText)) {
            return defaultValue;
        }
        try {
            d = new Double(theText);
        }
        catch (NumberFormatException e) {
            d = null;
        }
        if (d != null) {
            return d;
        }
        this.invalidNumber = true;
        return 0.0;
    }

    public boolean invalidNumber() {
        boolean wasInvalid = this.invalidNumber;
        this.invalidNumber = false;
        return wasInvalid;
    }

    public String getNextString() {
        if (this.stringField == null || this.stringField[this.sfIndex] == null) {
            return "";
        }
        return this.stringField[this.sfIndex++].getText();
    }

    public boolean getNextBoolean() {
        if (this.checkbox == null || this.checkbox[this.cbIndex] == null) {
            return false;
        }
        return this.checkbox[this.cbIndex++].getState();
    }

    public String getNextChoice() {
        if (this.choice == null || this.choice[this.choiceIndex] == null) {
            return "";
        }
        return this.choice[this.choiceIndex++].getSelectedItem();
    }

    public int getNextChoiceIndex() {
        if (this.choice == null || this.choice[this.choiceIndex] == null) {
            return -1;
        }
        return this.choice[this.choiceIndex++].getSelectedIndex();
    }

    public String getNextText() {
        String text;
        if (this.textArea1 != null) {
            this.textArea1.selectAll();
            text = this.textArea1.getText();
            this.textArea1 = null;
        } else if (this.textArea2 != null) {
            this.textArea2.selectAll();
            text = this.textArea2.getText();
            this.textArea2 = null;
        } else {
            text = null;
        }
        return text;
    }

    public void showDialog() {
        if (this.stringField != null && this.stringField[0] != null && this.numberField == null) {
            this.stringField[0].selectAll();
        }
        Panel buttons = new Panel();
        buttons.setLayout(new FlowLayout(1, 5, 0));
        this.cancel = new Button("Cancel");
        this.cancel.addActionListener(this);
        buttons.add(this.cancel);
        this.okay = new Button("  OK  ");
        this.okay.addActionListener(this);
        buttons.add(this.okay);
        this.c.gridx = 0;
        this.c.gridy = this.y;
        this.c.anchor = 13;
        this.c.gridwidth = 2;
        this.c.insets = new Insets(20, 0, 0, 0);
        this.grid.setConstraints(buttons, this.c);
        this.add(buttons);
        this.nfIndex = 0;
        this.sfIndex = 0;
        this.cbIndex = 0;
        this.choiceIndex = 0;
        this.pack();
        GUI.center(this);
        ((Component)this).setVisible(true);
        IJ.wait(250);
    }

    public void actionPerformed(ActionEvent e) {
        this.wasCanceled = e.getSource() == this.cancel;
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public Insets getInsets() {
        return new Insets(40, 20, 20, 20);
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.firstPaint && this.numberField != null && this.numberField[0] != null) {
            this.numberField[0].requestFocus();
        }
        this.firstPaint = false;
    }
}

