/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.Converter;
import ij.IJ;
import ij.ImagePlus;
import ij.Menus;
import ij.Undo;
import ij.gui.ImageWindow;
import java.awt.CheckboxMenuItem;
import java.awt.MenuItem;
import java.util.Vector;

public class WindowManager {
    private static Vector windowList = new Vector();
    private static ImageWindow currentWindow = null;

    public static synchronized void setCurrentWindow(ImageWindow win) {
        ImagePlus imp;
        if (win == currentWindow || win == null || windowList.size() == 0) {
            return;
        }
        if (IJ.debugMode && win != null) {
            IJ.write(win.getImagePlus().getTitle() + ": setCurrentWindow (previous=" + (currentWindow != null ? currentWindow.getImagePlus().getTitle() : "null") + ")");
        }
        if (currentWindow != null && (imp = currentWindow.getImagePlus()) != null && imp.lockSilently()) {
            imp.trimProcessor();
            if (!Converter.newWindowCreated) {
                imp.saveRoi();
            }
            Converter.newWindowCreated = false;
            imp.unlock();
        }
        Undo.reset();
        currentWindow = !win.isClosed() && win.getImagePlus() != null ? win : null;
        Menus.updateMenus();
    }

    public static ImageWindow getCurrentWindow() {
        if (IJ.debugMode) {
            IJ.write("ImageWindow.getCurrentWindow");
        }
        return currentWindow;
    }

    static int getCurrentIndex() {
        return windowList.indexOf(currentWindow);
    }

    public static synchronized ImagePlus getCurrentImage() {
        if (IJ.debugMode) {
            IJ.write("ImageWindow.getCurrentImage");
        }
        if (currentWindow != null) {
            return currentWindow.getImagePlus();
        }
        return null;
    }

    public static int getWindowCount() {
        return windowList.size();
    }

    public static synchronized int[] getIDList() {
        int nWindows = windowList.size();
        if (nWindows == 0) {
            return null;
        }
        int[] list = new int[nWindows];
        int i = 0;
        while (i < nWindows) {
            ImageWindow win = (ImageWindow)windowList.elementAt(i);
            list[i] = win.getImagePlus().getID();
            ++i;
        }
        return list;
    }

    public static synchronized ImagePlus getImage(int imageID) {
        if (IJ.debugMode) {
            IJ.write("ImageWindow.getImage");
        }
        if (imageID >= 0) {
            return null;
        }
        ImagePlus imp = null;
        int i = 0;
        while (i < windowList.size()) {
            ImageWindow win = (ImageWindow)windowList.elementAt(i);
            ImagePlus imp2 = win.getImagePlus();
            if (imageID == imp2.getID()) {
                imp = imp2;
                break;
            }
            ++i;
        }
        return imp;
    }

    public static synchronized void addWindow(ImageWindow win) {
        if (IJ.debugMode) {
            IJ.write(win.getImagePlus().getTitle() + ": addWindow");
        }
        windowList.addElement(win);
        Menus.extendWindowMenu(win.getImagePlus());
        WindowManager.setCurrentWindow(win);
    }

    public static synchronized void removeWindow(ImageWindow win) {
        int index;
        if (IJ.debugMode) {
            IJ.write(win.getImagePlus().getTitle() + ": removeWindow (" + windowList.size() + ")");
        }
        if ((index = windowList.indexOf(win)) == -1) {
            return;
        }
        if (windowList.size() > 1) {
            int newIndex = index - 1;
            if (newIndex < 0) {
                newIndex = windowList.size() - 1;
            }
            WindowManager.setCurrentWindow((ImageWindow)windowList.elementAt(newIndex));
        } else {
            currentWindow = null;
        }
        Menus.trimWindowMenu(windowList.size() - index);
        windowList.removeElementAt(index);
        int i = index;
        while (i < windowList.size()) {
            ImageWindow w = (ImageWindow)windowList.elementAt(i);
            Menus.extendWindowMenu(w.getImagePlus());
            ++i;
        }
        Menus.updateMenus();
        Undo.reset();
    }

    public static synchronized boolean closeAllWindows() {
        while (windowList.size() > 0) {
            ImagePlus imp = ((ImageWindow)windowList.elementAt(0)).getImagePlus();
            if (!((ImageWindow)windowList.elementAt(0)).close()) {
                return false;
            }
            IJ.wait(100);
        }
        return true;
    }

    public static void putBehind() {
        if (IJ.debugMode) {
            IJ.write("putBehind");
        }
        if (windowList.size() < 1 || currentWindow == null) {
            return;
        }
        int index = windowList.indexOf(currentWindow);
        if (--index < 0) {
            index = windowList.size() - 1;
        }
        ImageWindow win = (ImageWindow)windowList.elementAt(index);
        WindowManager.setCurrentWindow(win);
        win.toFront();
        Menus.updateMenus();
    }

    static synchronized void activateWindow(String menuItemLabel, MenuItem item) {
        int i = 0;
        while (i < windowList.size()) {
            ImageWindow win = (ImageWindow)windowList.elementAt(i);
            if (menuItemLabel.startsWith(win.getImagePlus().getTitle())) {
                WindowManager.setCurrentWindow(win);
                win.toFront();
                int index = windowList.indexOf(win);
                int n = Menus.window.getItemCount();
                int j = 3;
                while (j < n) {
                    MenuItem mi = Menus.window.getItem(j);
                    ((CheckboxMenuItem)mi).setState(j - 3 == index);
                    ++j;
                }
                break;
            }
            ++i;
        }
    }

    static void showList() {
        if (IJ.debugMode) {
            int i = 0;
            while (i < windowList.size()) {
                ImageWindow win = (ImageWindow)windowList.elementAt(i);
                ImagePlus imp = win.getImagePlus();
                IJ.write(i + " " + imp.getTitle() + (win == currentWindow ? "*" : ""));
                ++i;
            }
            IJ.write(" ");
        }
    }
}

