/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.IJ;
import ij.ImageJ;
import ij.Menus;
import ij.gui.ImageCanvas;
import ij.gui.PlotWindow;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.io.ImportDialog;
import ij.io.JpegEncoder;
import ij.io.OpenDialog;
import ij.plugin.filter.Analyzer;
import ij.plugin.filter.ParticleAnalyzer;
import ij.process.ImageConverter;
import ij.util.Tools;
import java.applet.Applet;
import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class Prefs {
    public static final String PROPS_NAME = "IJ_Props.txt";
    public static final String PREFS_NAME = "IJ_Prefs.txt";
    public static final String DIR_IMAGE = "dir.image";
    public static final String FCOLOR = "fcolor";
    public static final String BCOLOR = "bcolor";
    public static final String ROICOLOR = "roicolor";
    public static final String JPEG = "jpeg";
    public static final String USE_POINTER = "pcursor";
    public static final String SCALE_CONVERSIONS = "scale";
    static String separator = System.getProperty("file.separator");
    static Properties prefs = new Properties();
    static Properties props = new Properties(prefs);
    static String prefsDir;
    static String imagesURL;
    static String homeDir;

    public static String load(ImageJ ij, Applet applet) {
        InputStream f = ij.getClass().getResourceAsStream("/IJ_Props.txt");
        if (applet != null) {
            return Prefs.loadAppletProps(f, applet);
        }
        homeDir = System.getProperty("user.dir");
        String userHome = System.getProperty("user.home");
        String osName = System.getProperty("os.name");
        prefsDir = osName.indexOf("Windows", 0) > -1 ? homeDir : userHome;
        if (f == null) {
            try {
                f = new FileInputStream(homeDir + "/" + PROPS_NAME);
            }
            catch (FileNotFoundException e) {
                f = null;
            }
        }
        if (f == null) {
            return "IJ_Props.txt not found in ij.jar or in " + homeDir;
        }
        f = new BufferedInputStream(f);
        try {
            props.load(f);
            f.close();
        }
        catch (IOException e) {
            return "Error loading IJ_Props.txt";
        }
        imagesURL = props.getProperty("images.location");
        Prefs.loadPreferences();
        return "";
    }

    static String loadAppletProps(InputStream f, Applet applet) {
        if (f == null) {
            return "IJ_Props.txt not found in ij.jar";
        }
        try {
            props.load(f);
            f.close();
        }
        catch (IOException e) {
            return "Error loading IJ_Props.txt";
        }
        try {
            URL url = new URL(applet.getDocumentBase(), "images/");
            imagesURL = url.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public static String getImagesURL() {
        return imagesURL;
    }

    public static String getHomeDir() {
        return homeDir;
    }

    public static String getString(String key) {
        return props.getProperty(key);
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        if (props == null) {
            return defaultValue;
        }
        String s = props.getProperty(key);
        if (s == null) {
            return defaultValue;
        }
        return s.equals("true");
    }

    public static int getInt(String key, int defaultValue) {
        if (props == null) {
            return defaultValue;
        }
        String s = props.getProperty(key);
        if (s != null) {
            try {
                return Integer.decode(s);
            }
            catch (NumberFormatException e) {
                IJ.write("" + e);
            }
        }
        return defaultValue;
    }

    public static double getDouble(String key, double defaultValue) {
        if (props == null) {
            return defaultValue;
        }
        String s = props.getProperty(key);
        Double d = null;
        if (s != null) {
            try {
                d = new Double(s);
            }
            catch (NumberFormatException e) {
                d = null;
            }
            if (d != null) {
                return d;
            }
        }
        return defaultValue;
    }

    public static Color getColor(String key, Color defaultColor) {
        int i = Prefs.getInt(key, 2730);
        if (i == 2730) {
            return defaultColor;
        }
        return new Color(i >> 16 & 0xFF, i >> 8 & 0xFF, i & 0xFF);
    }

    public static String getFileSeparator() {
        return separator;
    }

    static void loadPreferences() {
        String path = prefsDir + separator + PREFS_NAME;
        try {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(path));
            prefs.load(is);
            ((InputStream)is).close();
        }
        catch (Exception e) {
            return;
        }
    }

    static void savePreferences() {
        try {
            Properties prefs = new Properties();
            String dir = OpenDialog.getDefaultDirectory();
            if (dir != null) {
                ((Hashtable)prefs).put(DIR_IMAGE, Prefs.escapeBackSlashes(dir));
            }
            ((Hashtable)prefs).put(ROICOLOR, Tools.c2hex(Roi.getColor()));
            ((Hashtable)prefs).put(FCOLOR, Tools.c2hex(Toolbar.getForegroundColor()));
            ((Hashtable)prefs).put(BCOLOR, Tools.c2hex(Toolbar.getBackgroundColor()));
            ((Hashtable)prefs).put(JPEG, Integer.toString(JpegEncoder.getQuality()));
            ((Hashtable)prefs).put(USE_POINTER, ImageCanvas.usePointer ? "true" : "false");
            ((Hashtable)prefs).put(SCALE_CONVERSIONS, ImageConverter.getDoScaling() ? "true" : "false");
            Menus.savePreferences(prefs);
            ParticleAnalyzer.savePreferences(prefs);
            Analyzer.savePreferences(prefs);
            ImportDialog.savePreferences(prefs);
            PlotWindow.savePreferences(prefs);
            String path = prefsDir + separator + PREFS_NAME;
            Prefs.savePrefs(prefs, path);
        }
        catch (Exception e) {
            IJ.write("<<Unable to save preferences>>");
            IJ.wait(2000);
        }
    }

    static void savePrefs(Properties prefs, String path) throws IOException {
        FileOutputStream fos = new FileOutputStream(path);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        PrintWriter pw = new PrintWriter(bos);
        pw.println("# ImageJ 1.22d Preferences");
        pw.println("# " + new Date());
        pw.println("");
        Enumeration e = ((Hashtable)prefs).keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            pw.print(key);
            pw.write(61);
            pw.println((String)((Hashtable)prefs).get(key));
        }
        pw.close();
    }

    static String escapeBackSlashes(String s) {
        StringBuffer sb = new StringBuffer(s.length() + 10);
        char[] chars = s.toCharArray();
        int i = 0;
        while (i < chars.length) {
            sb.append(chars[i]);
            if (chars[i] == '\\') {
                sb.append('\\');
            }
            ++i;
        }
        return sb.toString();
    }
}

