/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.IJ;
import ij.ImagePlus;
import ij.io.FileInfo;
import ij.io.FileOpener;
import ij.io.Opener;
import java.io.File;

public class Macros {
    public void run(String command) {
        IJ.run(command);
    }

    public void open() {
        Opener o = new Opener();
        o.openImage();
    }

    public boolean open(String path) {
        if (path == null || path.equals("")) {
            this.open();
        } else {
            Opener o = new Opener();
            ImagePlus img = o.openImage(this.getDir(path), this.getName(path));
            if (img == null) {
                return false;
            }
            img.show();
        }
        return true;
    }

    public boolean importRaw(String path, String args, int width, int height, int offset) {
        return this.importRaw(path, args, width, height, offset, 1, 0);
    }

    public boolean importRaw(String path, String args, int width, int height, int offset, int nImages, int gap) {
        File f = new File(path);
        args = args.toLowerCase();
        FileInfo fi = new FileInfo();
        fi.fileFormat = 1;
        fi.fileName = this.getName(path);
        fi.directory = this.getDir(path);
        fi.width = width;
        fi.height = height;
        fi.offset = offset;
        fi.nImages = nImages;
        fi.gapBetweenImages = gap;
        fi.intelByteOrder = args.indexOf("little") >= 0;
        boolean bl = fi.whiteIsZero = args.indexOf("white") >= 0;
        fi.fileType = args.indexOf("16-bit") >= 0 ? (args.indexOf("unsigned") >= 0 ? 2 : 1) : (args.indexOf("32-bit") >= 0 ? (args.indexOf("integer") >= 0 ? 3 : 4) : (args.indexOf("RGB") >= 0 ? (args.indexOf("planar") >= 0 ? 7 : 6) : 0));
        if (IJ.debugMode) {
            IJ.write("importRaw(): " + fi);
        }
        FileOpener fo = new FileOpener(fi);
        fo.open();
        return true;
    }

    public String getName(String path) {
        int i = path.lastIndexOf(47);
        if (i == -1) {
            i = path.lastIndexOf(92);
        }
        if (i > 0) {
            return path.substring(i + 1);
        }
        return path;
    }

    public String getDir(String path) {
        int i = path.lastIndexOf(47);
        if (i == -1) {
            i = path.lastIndexOf(92);
        }
        if (i > 0) {
            return path.substring(0, i + 1);
        }
        return "";
    }
}

