/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.process.ColorProcessor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelGrabber;

public class LookUpTable {
    private int width;
    private int height;
    private byte[] pixels;
    private int mapSize = 0;
    private ColorModel cm;
    private byte[] rLUT;
    private byte[] gLUT;
    private byte[] bLUT;

    public LookUpTable(Image img) {
        PixelGrabber pg = new PixelGrabber(img, 0, 0, 1, 1, false);
        try {
            pg.grabPixels();
            this.cm = pg.getColorModel();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.getColors(this.cm);
    }

    public LookUpTable(ColorModel cm) {
        this.getColors(cm);
    }

    void getColors(ColorModel cm) {
        if (cm instanceof IndexColorModel) {
            IndexColorModel m = (IndexColorModel)cm;
            this.mapSize = m.getMapSize();
            this.rLUT = new byte[this.mapSize];
            this.gLUT = new byte[this.mapSize];
            this.bLUT = new byte[this.mapSize];
            m.getReds(this.rLUT);
            m.getGreens(this.gLUT);
            m.getBlues(this.bLUT);
        }
    }

    public int getMapSize() {
        return this.mapSize;
    }

    public byte[] getReds() {
        return this.rLUT;
    }

    public byte[] getGreens() {
        return this.gLUT;
    }

    public byte[] getBlues() {
        return this.bLUT;
    }

    public ColorModel getColorModel() {
        return this.cm;
    }

    public boolean isGrayscale() {
        boolean isGray = true;
        if (this.mapSize < 256) {
            return false;
        }
        int i = 0;
        while (i < this.mapSize) {
            if (this.rLUT[i] != this.gLUT[i] || this.gLUT[i] != this.bLUT[i]) {
                isGray = false;
            }
            ++i;
        }
        return isGray;
    }

    public void drawColorBar(Graphics g, int x, int y, int width, int height) {
        if (this.mapSize == 0) {
            return;
        }
        ColorProcessor cp = new ColorProcessor(width, height);
        double scale = 256.0 / (double)this.mapSize;
        int i = 0;
        while (i < 256) {
            int index = (int)((double)i / scale);
            cp.setColor(new Color(this.rLUT[index] & 0xFF, this.gLUT[index] & 0xFF, this.bLUT[index] & 0xFF));
            cp.moveTo(i, 0);
            cp.lineTo(i, height);
            ++i;
        }
        g.drawImage(cp.createImage(), x, y, null);
        g.setColor(Color.black);
        g.drawRect(x, y, width, height);
    }

    public void drawUnscaledColorBar(Graphics g, int x, int y, int width, int height) {
        ColorProcessor cp = new ColorProcessor(width, height);
        if (this.mapSize == 0) {
            int i = 0;
            while (i < 256) {
                cp.setColor(new Color(i, i, i));
                cp.moveTo(i, 0);
                cp.lineTo(i, height);
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.mapSize) {
                cp.setColor(new Color(this.rLUT[i] & 0xFF, this.gLUT[i] & 0xFF, this.bLUT[i] & 0xFF));
                cp.moveTo(i, 0);
                cp.lineTo(i, height);
                ++i;
            }
        }
        g.drawImage(cp.createImage(), x, y, null);
        g.setColor(Color.black);
        g.drawRect(x, y, width, height);
    }

    public static ColorModel createGrayscaleColorModel(boolean invert) {
        byte[] rLUT = new byte[256];
        byte[] gLUT = new byte[256];
        byte[] bLUT = new byte[256];
        if (invert) {
            int i = 0;
            while (i < 256) {
                rLUT[255 - i] = (byte)i;
                gLUT[255 - i] = (byte)i;
                bLUT[255 - i] = (byte)i;
                ++i;
            }
        } else {
            int i = 0;
            while (i < 256) {
                rLUT[i] = (byte)i;
                gLUT[i] = (byte)i;
                bLUT[i] = (byte)i;
                ++i;
            }
        }
        return new IndexColorModel(8, 256, rLUT, gLUT, bLUT);
    }
}

