/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.Executer;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Menus;
import ij.Prefs;
import ij.Undo;
import ij.WindowManager;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.MessageDialog;
import ij.gui.ProgressBar;
import ij.gui.Roi;
import ij.gui.TextRoi;
import ij.gui.Toolbar;
import ij.io.PluginClassLoader;
import ij.plugin.PlugIn;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.text.TextPanel;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuComponent;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.ImageProducer;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;

public class ImageJ
extends Frame
implements ActionListener,
MouseListener,
KeyListener,
WindowListener,
ItemListener {
    public static final String VERSION = "1.22d";
    private Toolbar toolbar;
    private Panel statusBar;
    private ProgressBar progressBar;
    private Label statusLine;
    private TextPanel textPanel;
    private boolean firstTime = true;
    private Applet applet;
    private Vector classes = new Vector();
    private static PluginClassLoader classLoader;
    private boolean notVerified = true;
    private static boolean wasMaximized;

    public ImageJ() {
        this((Applet)null);
    }

    public ImageJ(Applet applet) {
        super("ImageJ");
        this.applet = applet;
        String status = Prefs.load(this, applet);
        Menus m = new Menus(this, applet);
        m.addMenuBar();
        m.installPopupMenu(this);
        this.notVerified = true;
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(2, 1));
        this.toolbar = new Toolbar();
        this.toolbar.addKeyListener(this);
        panel.add(this.toolbar);
        this.statusBar = new Panel();
        this.statusBar.setLayout(new BorderLayout());
        this.statusBar.setForeground(Color.black);
        this.statusBar.setBackground(Color.lightGray);
        this.statusLine = new Label();
        this.statusLine.addKeyListener(this);
        this.statusLine.addMouseListener(this);
        this.statusBar.add("Center", this.statusLine);
        this.progressBar = new ProgressBar(90, 16);
        this.progressBar.addKeyListener(this);
        this.progressBar.addMouseListener(this);
        this.statusBar.add("East", this.progressBar);
        panel.add(this.statusBar);
        this.add("North", panel);
        this.textPanel = new TextPanel();
        this.textPanel.setTitle("results.txt");
        this.textPanel.setBackground(Color.white);
        this.textPanel.setFont(new Font("Monospaced", 0, 12));
        this.textPanel.addKeyListener(this);
        this.add("Center", this.textPanel);
        IJ.init(this, applet, this.textPanel);
        IJ.write("ImageJ 1.22d");
        if (!status.equals("")) {
            IJ.write("<<" + status + ">>");
        }
        IJ.showStatus("  " + Menus.nPlugins + " plugin commands installed");
        this.addKeyListener(this);
        this.addWindowListener(this);
        this.setResizable(true);
        Point loc = this.getPreferredLocation();
        Dimension tbSize = this.toolbar.getPreferredSize();
        ((Component)this).setBounds(loc.x, loc.y, tbSize.width + 10, 230);
        this.setCursor(Cursor.getDefaultCursor());
        this.setIcon();
        ((Component)this).setVisible(true);
        this.requestFocus();
    }

    void setIcon() {
        URL url = this.getClass().getResource("/microscope.gif");
        if (url == null) {
            return;
        }
        Image img = null;
        try {
            img = this.createImage((ImageProducer)url.getContent());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (img != null) {
            this.setIconImage(img);
        }
    }

    public Point getPreferredLocation() {
        int windowWidth;
        int screenWidth = Toolkit.getDefaultToolkit().getScreenSize().width;
        Dimension tbsize = this.toolbar.getPreferredSize();
        double percent = screenWidth > 832 ? 0.8 : 0.9;
        int windowX = (int)(percent * (double)(screenWidth - (windowWidth = tbsize.width + 10)));
        if (windowX < 10) {
            windowX = 10;
        }
        int windowY = 32;
        return new Point(windowX, windowY);
    }

    void showStatus(String s) {
        this.statusLine.setText(s);
    }

    public ProgressBar getProgressBar() {
        return this.progressBar;
    }

    void doCommand(String name) {
        new Executer(name, WindowManager.getCurrentImage());
    }

    void wrongType(int capabilities) {
        String s = "This command requires an image of type:\n \n";
        if ((capabilities & 1) != 0) {
            s = s + "    8-bit grayscale\n";
        }
        if ((capabilities & 2) != 0) {
            s = s + "    8-bit color\n";
        }
        if ((capabilities & 4) != 0) {
            s = s + "    16-bit grayscale\n";
        }
        if ((capabilities & 8) != 0) {
            s = s + "    32-bit (float) grayscale\n";
        }
        if ((capabilities & 0x10) != 0) {
            s = s + "    RGB color\n";
        }
        IJ.error(s);
    }

    public void runFilterPlugIn(Object theFilter, String cmd, String arg) {
        ImageWindow win;
        boolean doesStacks;
        ImagePlus imp = WindowManager.getCurrentImage();
        int capabilities = ((PlugInFilter)theFilter).setup(arg, imp);
        if ((capabilities & 0x1000) != 0) {
            return;
        }
        if ((capabilities & 0x200) != 0) {
            ((PlugInFilter)theFilter).run(null);
            return;
        }
        if (imp == null) {
            IJ.noImage();
            return;
        }
        if ((capabilities & 0x400) != 0 && imp.getRoi() == null) {
            IJ.error("Selection required");
            return;
        }
        if ((capabilities & 0x800) != 0 && imp.getStackSize() == 1) {
            IJ.error("Stack required");
            return;
        }
        int type = imp.getType();
        switch (type) {
            case 0: {
                if ((capabilities & 1) != 0) break;
                this.wrongType(capabilities);
                return;
            }
            case 3: {
                if ((capabilities & 2) != 0) break;
                this.wrongType(capabilities);
                return;
            }
            case 1: {
                if ((capabilities & 4) != 0) break;
                this.wrongType(capabilities);
                return;
            }
            case 2: {
                if ((capabilities & 8) != 0) break;
                this.wrongType(capabilities);
                return;
            }
            case 4: {
                if ((capabilities & 0x10) != 0) break;
                this.wrongType(capabilities);
                return;
            }
        }
        int slices = imp.getStackSize();
        boolean bl = doesStacks = (capabilities & 0x20) != 0;
        if (!imp.lock()) {
            return;
        }
        imp.startTiming();
        IJ.showStatus(cmd + "...");
        ImageStack stack = null;
        if (slices > 1) {
            stack = imp.getStack();
        }
        if (slices == 1 || !doesStacks || stack != null && (stack.isRGB() || stack.isHSB())) {
            ImageProcessor ip = imp.getProcessor();
            if ((capabilities & 0x100) != 0) {
                Undo.reset();
            } else {
                Undo.setup(1, imp);
                ip.snapshot();
            }
            ((PlugInFilter)theFilter).run(ip);
            if ((capabilities & 0x40) != 0) {
                ip.reset(imp.getMask());
            }
        } else {
            Undo.reset();
            int n = stack.getSize();
            int currentSlice = imp.getCurrentSlice();
            int i = 1;
            while (i <= n) {
                ImageProcessor ip = stack.getProcessor(i);
                ((PlugInFilter)theFilter).run(ip);
                IJ.showProgress((double)i / (double)n);
                System.gc();
                Thread.yield();
                ++i;
            }
            int current = imp.getCurrentSlice();
            imp.setProcessor(null, stack.getProcessor(current));
            IJ.showProgress(1.0);
        }
        IJ.showTime(imp, imp.getStartTime(), cmd + ": ");
        if ((capabilities & 0x80) == 0) {
            imp.changes = true;
            imp.updateAndDraw();
        }
        if ((win = imp.getWindow()) != null) {
            win.running = false;
        }
        imp.unlock();
    }

    public Object runUserPlugIn(String commandName, String className, String arg, boolean createNewLoader) {
        PluginClassLoader loader;
        if (this.applet != null) {
            return null;
        }
        if (this.notVerified) {
            IJ.runPlugIn("ij.plugin.Verifier", "");
            this.notVerified = false;
        }
        if (createNewLoader) {
            loader = new PluginClassLoader(Menus.getPlugInsPath());
        } else {
            if (classLoader == null) {
                classLoader = new PluginClassLoader(Menus.getPlugInsPath());
            }
            loader = classLoader;
        }
        Object thePlugIn = null;
        try {
            thePlugIn = loader.loadClass(className).newInstance();
            if (thePlugIn instanceof PlugIn) {
                ((PlugIn)thePlugIn).run(arg);
            } else if (thePlugIn instanceof PlugInFilter) {
                this.runFilterPlugIn(thePlugIn, commandName, arg);
            }
        }
        catch (ClassNotFoundException e) {
            IJ.write("PlugIn not found: " + className);
        }
        catch (InstantiationException e) {
            IJ.write("Unable to load plugin (ins)");
        }
        catch (IllegalAccessException e) {
            IJ.write("Unable to load plugin (acc)");
        }
        return thePlugIn;
    }

    public static String modifiers(int flags) {
        String s = " [ ";
        if (flags == 0) {
            return "";
        }
        if ((flags & 1) != 0) {
            s = s + "Shift ";
        }
        if ((flags & 2) != 0) {
            s = s + "Control ";
        }
        if ((flags & 4) != 0) {
            s = s + "Meta ";
        }
        if ((flags & 8) != 0) {
            s = s + "Alt ";
        }
        s = s + "] ";
        return s;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof MenuItem) {
            MenuItem item = (MenuItem)e.getSource();
            String cmd = e.getActionCommand();
            if (cmd != null) {
                this.doCommand(cmd);
            }
            if (IJ.debugMode) {
                IJ.write("actionPerformed: " + cmd);
            }
        }
    }

    public void itemStateChanged(ItemEvent e) {
        MenuItem item = (MenuItem)e.getSource();
        MenuComponent parent = (MenuComponent)((Object)item.getParent());
        String cmd = e.getItem().toString();
        if ((Menu)parent == Menus.window) {
            WindowManager.activateWindow(cmd, item);
        } else {
            this.doCommand(cmd);
        }
    }

    public void mousePressed(MouseEvent e) {
        Undo.reset();
        IJ.showStatus(IJ.freeMemory());
        if (IJ.debugMode) {
            IJ.write("Windows: " + WindowManager.getWindowCount());
        }
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        Roi roi;
        boolean isStack;
        int keyCode = e.getKeyCode();
        IJ.setKeyDown(keyCode);
        if (keyCode == 17 || keyCode == 16) {
            return;
        }
        char keyChar = e.getKeyChar();
        int flags = e.getModifiers();
        if (IJ.debugMode) {
            IJ.write("keyCode=" + keyCode + " (" + KeyEvent.getKeyText(keyCode) + ") keyChar=\"" + keyChar + "\" (" + keyChar + ") " + KeyEvent.getKeyModifiersText(flags));
        }
        boolean shift = (flags & 1) != 0;
        boolean control = (flags & 2) != 0;
        String c = "";
        ImagePlus imp = WindowManager.getCurrentImage();
        boolean bl = isStack = imp != null && imp.getStackSize() > 1;
        if (imp != null && !control && (keyChar >= ' ' && keyChar <= '\u007f' || keyChar == '\b' || keyChar == '\n') && (roi = imp.getRoi()) instanceof TextRoi) {
            ((TextRoi)roi).addChar(keyChar);
            return;
        }
        Hashtable shortcuts = Menus.getShortcuts();
        c = shift ? (String)shortcuts.get(new Integer(keyCode + 200)) : (String)shortcuts.get(new Integer(keyCode));
        if (c == null) {
            switch (keyCode) {
                case 9: {
                    WindowManager.putBehind();
                    return;
                }
                case 8: {
                    c = "Clear";
                    break;
                }
                case 61: 
                case 187: {
                    c = "Start Animation [=]";
                    break;
                }
                case 47: 
                case 191: {
                    c = "Reslice [/]...";
                    break;
                }
                case 44: 
                case 188: {
                    c = "Previous Slice [<]";
                    break;
                }
                case 46: 
                case 190: {
                    c = "Next Slice [>]";
                    break;
                }
                case 37: 
                case 38: 
                case 39: 
                case 40: {
                    Roi roi2 = null;
                    if (imp != null) {
                        roi2 = imp.getRoi();
                    }
                    if (roi2 == null) {
                        return;
                    }
                    if ((flags & 8) != 0) {
                        roi2.nudgeCorner(keyCode);
                    } else {
                        roi2.nudge(keyCode);
                    }
                    return;
                }
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: {
                    ImageWindow win;
                    Toolbar.getInstance().selectTool(keyCode);
                    if (imp == null || (win = imp.getWindow()) == null) break;
                    ImageCanvas ic = win.getCanvas();
                    Point loc = ic.getCursorLoc();
                    if (loc.x <= 0 || loc.y <= 0) break;
                    ic.setCursor(loc.x, loc.y);
                    break;
                }
                case 27: {
                    if (imp != null) {
                        imp.getWindow().running = false;
                    }
                    return;
                }
                case 10: {
                    this.toFront();
                    return;
                }
            }
        }
        if (c != null && !c.equals("")) {
            this.doCommand(c);
        }
    }

    public void keyReleased(KeyEvent e) {
        IJ.setKeyUp(e.getKeyCode());
    }

    public void keyTyped(KeyEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.doCommand("Quit");
    }

    public void windowActivated(WindowEvent e) {
        boolean bigWindow;
        if (IJ.isMacintosh()) {
            this.setMenuBar(Menus.getMenuBar());
        }
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension window = this.getSize();
        if (IJ.debugMode) {
            IJ.write("screen: " + screen);
        }
        if (IJ.debugMode) {
            IJ.write("Window: " + window);
        }
        boolean bl = bigWindow = window.width >= screen.width;
        if (bigWindow && !wasMaximized) {
            wasMaximized = true;
            IJ.beep();
            IJ.showMessage("Error", "The \"ImageJ\" window should not be maximized!\nInstead, make it as small as possible and position\nit so as to minimize overlap of image windows.");
        }
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public int copyText(boolean cut) {
        boolean isActiveWindow;
        boolean bl = isActiveWindow = this.getFocusOwner() != null;
        if (!isActiveWindow) {
            return 0;
        }
        int count = this.textPanel.copySelection();
        if (cut && count > 0) {
            this.textPanel.clearSelection();
        }
        this.textPanel.resetSelection();
        return count;
    }

    public boolean clearText() {
        boolean isActiveWindow;
        boolean bl = isActiveWindow = this.getFocusOwner() != null;
        if (!isActiveWindow) {
            return false;
        }
        this.textPanel.clearSelection();
        return true;
    }

    void showAboutBox() {
        MessageDialog messageDialog = new MessageDialog((Frame)this, "About ImageJ...", "         ImageJ 1.22d\n \nWayne Rasband (wayne@codon.nih.gov)\nNational Institutes of Health, USA\nhttp://rsb.info.nih.gov/ij/\n \nImageJ is in the public domain.");
    }

    public void register(Class c) {
        if (!this.classes.contains(c)) {
            this.classes.addElement(c);
        }
    }

    void quit() {
        if (this.applet == null) {
            Prefs.savePreferences();
        }
        if (!WindowManager.closeAllWindows()) {
            return;
        }
        ((Component)this).setVisible(false);
        this.dispose();
        if (this.applet == null) {
            System.exit(0);
        }
    }

    public static void main(String[] args) {
        new ImageJ(null);
    }
}

