/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.Executer;
import ij.ImageJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.gui.MessageDialog;
import ij.gui.ProgressBar;
import ij.gui.YesNoCancelDialog;
import ij.plugin.PlugIn;
import ij.text.TextPanel;
import java.applet.Applet;
import java.awt.Frame;
import java.awt.Toolkit;
import java.text.DecimalFormat;

public class IJ {
    public static boolean debugMode = false;
    private static ImageJ ij;
    private static Applet applet;
    private static ProgressBar progressBar;
    private static TextPanel textPanel;
    private static boolean isMac;
    private static boolean altDown;
    private static boolean spaceDown;
    public static final int CANCELED = Integer.MIN_VALUE;
    private static DecimalFormat df;
    private static int dfDigits;

    static void init(ImageJ imagej, Applet theApplet, TextPanel tp) {
        ij = imagej;
        applet = theApplet;
        progressBar = ij.getProgressBar();
        textPanel = tp;
    }

    public static ImageJ getInstance() {
        return ij;
    }

    public static Object runPlugIn(String className, String arg) {
        return IJ.runPlugIn("", className, arg);
    }

    static Object runPlugIn(String commandName, String className, String arg) {
        if (!className.startsWith("ij")) {
            boolean createNewClassLoader = IJ.altKeyDown();
            return ij.runUserPlugIn(commandName, className, arg, createNewClassLoader);
        }
        Object thePlugIn = null;
        try {
            Class<?> c = Class.forName(className);
            thePlugIn = c.newInstance();
            if (thePlugIn instanceof PlugIn) {
                ((PlugIn)thePlugIn).run(arg);
            } else {
                ij.runFilterPlugIn(thePlugIn, commandName, arg);
            }
        }
        catch (ClassNotFoundException e) {
            IJ.write("Plugin not found: " + className);
        }
        catch (InstantiationException e) {
            IJ.write("Unable to load plugin (ins)");
        }
        catch (IllegalAccessException e) {
            IJ.write("Unable to load plugin (acc)");
        }
        return thePlugIn;
    }

    public static void doCommand(String command) {
        if (ij != null) {
            ij.doCommand(command);
        }
    }

    public static void run(String command) {
        Executer e = new Executer(command);
        e.run();
    }

    public static Applet getApplet() {
        return applet;
    }

    public static void showStatus(String s) {
        if (ij != null) {
            ij.showStatus(s);
        }
    }

    public static void write(String s) {
        if (textPanel != null) {
            textPanel.append(s);
        } else {
            System.out.println(s);
        }
    }

    public static void setColumnHeadings(String headings) {
        if (textPanel != null) {
            textPanel.setColumnHeadings(headings);
        }
    }

    public static TextPanel getTextPanel() {
        return textPanel;
    }

    public static void noImage() {
        IJ.showMessage("No Image", "There are no images open.");
    }

    public static void outOfMemory(String name) {
        IJ.write("<<" + name + ": out of memory>>");
    }

    public static void showProgress(double progress) {
        if (progressBar != null) {
            progressBar.show(progress);
        }
    }

    public static void showMessage(String title, String msg) {
        if (ij != null) {
            new MessageDialog((Frame)ij, title, msg);
        } else {
            System.out.println(msg);
        }
    }

    public static void showMessage(String msg) {
        IJ.showMessage("Message", msg);
    }

    public static void error(String msg) {
        if (ij != null) {
            new MessageDialog((Frame)ij, "ImageJ", msg);
        } else {
            System.out.println(msg);
        }
    }

    public static boolean showMessageWithCancel(String title, String msg) {
        GenericDialog gd = new GenericDialog(title);
        gd.addMessage(msg);
        gd.showDialog();
        return !gd.wasCanceled();
    }

    public static double getNumber(String prompt, double defaultNumber) {
        Frame win = WindowManager.getCurrentWindow();
        if (win == null) {
            win = ij;
        }
        GenericDialog gd = new GenericDialog("Enter a Number", win);
        gd.addNumericField(prompt, defaultNumber, 0);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return -2.147483648E9;
        }
        return gd.getNextNumber();
    }

    public static String getString(String prompt, String defaultString) {
        Frame win = WindowManager.getCurrentWindow();
        if (win == null) {
            win = ij;
        }
        GenericDialog gd = new GenericDialog("Enter a String", win);
        gd.addStringField(prompt, defaultString, 20);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return "";
        }
        return gd.getNextString();
    }

    public static synchronized void wait(int msecs) {
        try {
            Thread.sleep(msecs);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    public static String freeMemory() {
        System.gc();
        long freeMem = Runtime.getRuntime().freeMemory();
        long totMem = Runtime.getRuntime().totalMemory();
        return "Memory: " + (totMem - freeMem) / 1024L + "K";
    }

    public static void showTime(ImagePlus imp, long start, String str) {
        long elapsedTime = System.currentTimeMillis() - start;
        double seconds = (double)elapsedTime / 1000.0;
        long pixels = imp.getWidth() * imp.getHeight();
        int rate = (int)((double)pixels / seconds);
        String str2 = rate > 1000000000 ? "" : (rate < 1000000 ? ", " + rate + " pixels/second" : ", " + IJ.d2s((double)rate / 1000000.0, 1) + " million pixels/second");
        IJ.showStatus(str + seconds + " seconds" + str2);
    }

    public static String d2s(double n) {
        return IJ.d2s(n, 2);
    }

    public static String d2s(double n, int precision) {
        boolean negative;
        if (n == 3.4028234663852886E38) {
            return "3.4e38";
        }
        boolean bl = negative = n < 0.0;
        if (negative) {
            n = -n;
        }
        double whole = Math.round(n * Math.pow(10.0, precision));
        double rounded = whole / Math.pow(10.0, precision);
        if (negative) {
            rounded = -rounded;
        }
        if (precision != dfDigits) {
            switch (precision) {
                case 0: {
                    df.applyPattern("0");
                    dfDigits = 0;
                    break;
                }
                case 1: {
                    df.applyPattern("0.0");
                    dfDigits = 1;
                    break;
                }
                case 2: {
                    df.applyPattern("0.00");
                    dfDigits = 2;
                    break;
                }
                case 3: {
                    df.applyPattern("0.000");
                    dfDigits = 3;
                    break;
                }
                case 4: {
                    df.applyPattern("0.0000");
                    dfDigits = 4;
                    break;
                }
                case 5: {
                    df.applyPattern("0.00000");
                    dfDigits = 5;
                    break;
                }
                case 6: {
                    df.applyPattern("0.000000");
                    dfDigits = 6;
                    break;
                }
                case 7: {
                    df.applyPattern("0.0000000");
                    dfDigits = 7;
                    break;
                }
                case 8: {
                    df.applyPattern("0.00000000");
                    dfDigits = 8;
                }
            }
        }
        String s = df.format(rounded);
        return s;
    }

    public static void register(Class c) {
        if (ij != null) {
            ij.register(c);
        }
    }

    public static boolean spaceBarDown() {
        return spaceDown;
    }

    public static boolean altKeyDown() {
        return altDown;
    }

    static void setKeyDown(int key) {
        switch (key) {
            case 18: {
                altDown = true;
                break;
            }
            case 32: {
                spaceDown = true;
                ImageWindow win = WindowManager.getCurrentWindow();
                if (win == null) break;
                win.getCanvas().setCursor(-1, -1);
                break;
            }
        }
    }

    static void setKeyUp(int key) {
        switch (key) {
            case 18: {
                altDown = false;
                break;
            }
            case 32: {
                spaceDown = false;
                ImageWindow win = WindowManager.getCurrentWindow();
                if (win == null) break;
                win.getCanvas().setCursor(-1, -1);
                break;
            }
        }
    }

    public static boolean isMacintosh() {
        return isMac && ij != null;
    }

    public static boolean versionLessThan(String version) {
        boolean lessThan;
        boolean bl = lessThan = "1.22d".compareTo(version) < 0;
        if (lessThan) {
            IJ.error("This plugin requires ImageJ " + version + " or later.");
        }
        return lessThan;
    }

    public static int setupDialog(ImagePlus imp, int flags) {
        if (imp == null) {
            return flags;
        }
        int stackSize = imp.getStackSize();
        if (stackSize > 1) {
            YesNoCancelDialog d = new YesNoCancelDialog((Frame)IJ.getInstance(), "Process Stack?", "Process all " + stackSize + " slices?  There is\n" + "no Undo if you select \"Yes\".");
            if (d.cancelPressed()) {
                return 4096;
            }
            if (d.yesPressed()) {
                return flags + 32;
            }
        }
        return flags;
    }

    static {
        isMac = System.getProperty("os.name").startsWith("Mac");
        df = new DecimalFormat("0.00");
        dfDigits = 2;
    }
}

