/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas.adde;

import edu.wisc.ssec.mcidas.AreaFile;
import edu.wisc.ssec.mcidas.AreaFileException;
import edu.wisc.ssec.mcidas.adde.GetAreaGUI;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.JFileChooser;

public class GetAreaFile
implements ActionListener {
    final String[] paramNames = new String[]{"host", "group", "descr", "user", "proj", "trace", "band", "mag", "linele", "place", "pos", "size", "unit", "spac", "doc", "latlon", "aux", "time", "day", "cal", "id"};
    String[] flags = new String[]{"h", "g", "d", "k", "j", "t", "b", "m", "l", "n", "p", "s", "u", "z", "o", "r", "a", "i", "y", "c", "e"};
    String[] paramValues;
    String[] serverNames;
    String paramFile = "params.properties";
    String outputFile;
    Properties pars;
    boolean verbose = false;
    boolean doGUI = false;
    GetAreaGUI gag = null;
    String gagRequest = null;
    public static final int AD_DATAOFFSET = 33;
    public static final int AD_NAVOFFSET = 34;
    public static final int AD_AUXOFFSET = 59;
    public static final int AD_CALOFFSET = 62;
    public static final int AD_DATAWIDTH = 10;

    public static void main(String[] args) {
        GetAreaFile getAreaFile = new GetAreaFile(args);
    }

    public GetAreaFile(String[] args) {
        if (args == null || args.length < 1) {
            System.out.println("Usage:  java edu.wisc.ssec.mcidas.GetAreaFile [options] output_file");
            System.out.println("   Command line [options] are:");
            int i = 0;
            while (i < this.paramNames.length) {
                System.out.println("    -" + this.flags[i] + " = " + this.paramNames[i]);
                ++i;
            }
            System.out.println("    -f = parameter save filename (def=params.properties)");
            System.out.println("    -v  (verbose text output)");
            System.out.println("    -gui = use GUI interface (no other options should be used with this)");
            System.out.println(" Note: for multi-argument options (like -s), you need to enclose the values in quotes. e.g., -s \"200 200\"");
            return;
        }
        this.paramValues = new String[this.paramNames.length];
        this.outputFile = this.doArguments(args);
        if (this.outputFile == null) {
            System.out.println("No output file specified...");
            return;
        }
        this.pars = this.fetchParams(this.paramFile);
        if (this.doGUI) {
            this.doGUI();
        } else {
            this.doRequest(this.pars);
        }
    }

    public void actionPerformed(ActionEvent e) {
        System.out.println("got action performed...");
        if (!e.getActionCommand().startsWith("adde://")) {
            return;
        }
        Object source = e.getSource();
        if (source.equals(this.gag)) {
            Properties p = new Properties();
            this.putProp(p, "host", this.gag.getServer());
            this.putProp(p, "group", this.gag.getGroup());
            this.putProp(p, "descr", this.gag.getDescr());
            this.putProp(p, "user", this.gag.getUserName());
            this.putProp(p, "proj", this.gag.getProjectNumber());
            this.putProp(p, "trace", null);
            this.putProp(p, "band", this.gag.getBand());
            this.putProp(p, "mag", this.gag.getMag());
            String ctype = this.gag.getCoordType();
            if (ctype.equals("E")) {
                this.putProp(p, "latlon", this.gag.getLocationString());
            } else if (ctype.equals("I")) {
                this.putProp(p, "linele", this.gag.getLocationString());
            } else if (ctype.equals("S")) {
                this.putProp(p, "id", this.gag.getLocationString());
            }
            this.putProp(p, "time", this.gag.getTime());
            this.putProp(p, "day", this.gag.getDay());
            this.putProp(p, "size", this.gag.getNumLinesEles());
            this.putProp(p, "unit", this.gag.getUnit());
            this.putProp(p, "doc", this.gag.getDoc());
            this.gagRequest = e.getActionCommand();
            JFileChooser getout = new JFileChooser();
            getout.setDialogTitle("Name of AREA file to write into");
            int status = getout.showSaveDialog(this.gag);
            if (status == 0) {
                File fn = getout.getSelectedFile();
                this.putProp(p, "outfile", fn.toString());
                this.doRequest(p);
            } else {
                this.gag.status("File not saved!!!");
            }
            return;
        }
    }

    void putProp(Properties p, String name, String value) {
        if (value == null) {
            return;
        }
        if (value.trim().length() < 1) {
            return;
        }
        ((Hashtable)p).put(name, value);
    }

    private void doGUI() {
        String tband;
        String tproj;
        this.gag = new GetAreaGUI("Select File", false);
        this.gag.addActionListener(this);
        this.gag.show();
        String tuser = this.pars.getProperty("user");
        if (tuser != null) {
            this.gag.setUserName(tuser);
        }
        if ((tproj = this.pars.getProperty("proj")) != null) {
            this.gag.setProjectNumber(tproj);
        }
        String tpos = this.pars.getProperty("pos");
        String tday = this.pars.getProperty("day");
        String ttime = this.pars.getProperty("time");
        String tlatlon = this.pars.getProperty("latlon");
        String tlinele = this.pars.getProperty("linele");
        String tid = this.pars.getProperty("id");
        if (tlatlon != null) {
            this.gag.setCoordType("E");
            this.gag.setLocationString(tlatlon);
        } else if (tlinele != null) {
            this.gag.setCoordType("I");
            this.gag.setLocationString(tlinele);
        } else if (tid != null) {
            this.gag.setCoordType("S");
            this.gag.setLocationString(tid);
        }
        String tsize = this.pars.getProperty("size");
        if (tsize != null) {
            this.gag.setNumLinesEles(tsize);
        } else {
            this.gag.setNumLinesEles("480 640");
        }
        String tmag = this.pars.getProperty("mag");
        if (tmag != null) {
            this.gag.setMag(tmag);
        }
        if ((tband = this.pars.getProperty("band")) != null) {
            this.gag.setBand(tband);
        }
        String tspac = this.pars.getProperty("spac");
        String tunit = this.pars.getProperty("unit");
        if (tunit != null) {
            this.gag.setUnit(tunit);
        }
        String tcal = this.pars.getProperty("cal");
        String tdoc = this.pars.getProperty("doc");
        if (tdoc != null) {
            this.gag.setDoc(tdoc);
        }
        String taux = this.pars.getProperty("aux");
    }

    public void doRequest(Properties params) {
        int[][] data;
        AreaFile af;
        String request = this.makeADDEString(params);
        if (this.gagRequest != null) {
            request = this.gagRequest;
        }
        if (this.gag != null) {
            this.outputFile = params.getProperty("outfile");
        }
        System.out.println("Request sent: " + request);
        if (this.gag != null) {
            this.gag.status("Request sent: " + request);
        }
        try {
            af = new AreaFile(request);
        }
        catch (AreaFileException e) {
            String es;
            System.out.println("While getting AreaFile:" + e);
            String es2 = es = e.toString();
            int ei = es.lastIndexOf("Exception:");
            if (ei > 0) {
                es = es2.substring(ei + 11);
            }
            if (this.gag != null) {
                this.gag.status("Error: " + es);
            }
            return;
        }
        int[] dir = af.getDir();
        if (dir == null) {
            System.out.println("No AREA file directory!");
            return;
        }
        if (this.verbose) {
            System.out.println("Length of directory = " + dir.length);
            int i = 0;
            while (i < dir.length) {
                System.out.println(" index " + i + " = " + dir[i]);
                ++i;
            }
        }
        int[] nav = null;
        nav = af.getNav();
        if (nav == null) {
            System.out.println("No navigation block!");
        } else if (this.verbose) {
            System.out.println("Length of nav block = " + nav.length);
        }
        int[] cal = null;
        cal = af.getCal();
        if (cal == null) {
            System.out.println("No calibration block!");
        } else if (this.verbose) {
            System.out.println("Length of cal block = " + cal.length);
        }
        int[] aux = null;
        aux = af.getAux();
        if (aux == null) {
            System.out.println("No aux block");
        } else if (this.verbose) {
            System.out.println("Length of aux block = " + aux.length);
        }
        int NL = dir[8];
        int NE = dir[9];
        if (this.verbose) {
            System.out.println("Start reading data, num points=" + NL * NE);
        }
        if (this.gag != null) {
            this.gag.status("Start reading data, num points=" + NL * NE);
        }
        try {
            data = af.getData(0, 0, NL, NE);
        }
        catch (AreaFileException e) {
            System.out.println(e);
            return;
        }
        if (this.verbose) {
            System.out.println("Finished reading data");
        }
        if (this.gag != null) {
            this.gag.status("Finished reading data");
        }
        try {
            int i;
            RandomAccessFile raf = new RandomAccessFile(this.outputFile, "rw");
            if (this.verbose) {
                System.out.println("Dir to word 0");
            }
            raf.seek(0L);
            dir[0] = 0;
            int i2 = 0;
            while (i2 < dir.length) {
                raf.writeInt(dir[i2]);
                ++i2;
            }
            if (this.verbose) {
                System.out.println("Nav to word " + dir[34]);
            }
            if (nav != null && dir[34] > 0) {
                raf.seek(dir[34]);
                i = 0;
                while (i < nav.length) {
                    raf.writeInt(nav[i]);
                    ++i;
                }
            }
            if (this.verbose) {
                System.out.println("Cal to word " + dir[62]);
            }
            if (cal != null && dir[34] > 0) {
                raf.seek(dir[62]);
                i = 0;
                while (i < cal.length) {
                    raf.writeInt(cal[i]);
                    ++i;
                }
            }
            if (this.verbose) {
                System.out.println("Aux to word " + dir[59]);
            }
            if (aux != null && dir[34] > 0) {
                raf.seek(dir[59]);
                i = 0;
                while (i < aux.length) {
                    raf.writeInt(aux[i]);
                    ++i;
                }
            }
            if (this.verbose) {
                System.out.println("Data to word " + dir[33]);
            }
            if (dir[34] > 0) {
                raf.seek(dir[33]);
                i = 0;
                while (i < data.length) {
                    int j = 0;
                    while (j < data[i].length) {
                        if (dir[10] == 1) {
                            raf.writeByte(data[i][j]);
                        } else if (dir[10] == 2) {
                            raf.writeShort(data[i][j]);
                        } else if (dir[10] == 4) {
                            raf.writeInt(data[i][j]);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            raf.close();
        }
        catch (Exception we) {
            System.out.println(we);
        }
        System.out.println("Completed. Data saved to: " + this.outputFile + "   Saving parameters to: " + this.paramFile);
        if (this.gag != null) {
            this.gag.status("Completed. Data saved to: " + this.outputFile + "   Saving parameters to: " + this.paramFile);
        }
        this.writeParams(this.paramFile, params);
    }

    public String makeADDEString(Properties params) {
        String host = params.getProperty("host");
        if (host == null) {
            return null;
        }
        String group = params.getProperty("group");
        if (group == null) {
            return null;
        }
        String descr = params.getProperty("descr");
        if (descr == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer("adde://" + host + "/image?");
        int i = 0;
        while (i < this.paramNames.length) {
            if (this.paramNames[i] != "host" && params.getProperty(this.paramNames[i]) != null) {
                sb.append(this.paramNames[i] + "=" + params.getProperty(this.paramNames[i]) + "&");
            }
            ++i;
        }
        sb.append("version=1");
        return sb.toString();
    }

    String doArguments(String[] arg) {
        String outfile = arg[arg.length - 1];
        if (outfile.equalsIgnoreCase("-gui")) {
            this.doGUI = true;
            outfile = " ";
            return outfile;
        }
        int k = 0;
        while (k < arg.length - 1) {
            String s = arg[k];
            if (s.length() > 1 && s.startsWith("-")) {
                if (s.equalsIgnoreCase("-gui")) {
                    this.doGUI = true;
                } else {
                    String r = s.substring(1, 2);
                    if (r.equals("f")) {
                        this.paramFile = s.length() == 2 ? arg[++k] : s.substring(2);
                    } else if (r.equals("v")) {
                        this.verbose = true;
                    } else {
                        int i = 0;
                        while (i < this.paramNames.length) {
                            if (r.equals(this.flags[i])) {
                                this.paramValues[i] = s.length() == 2 ? arg[++k] : s.substring(2);
                            }
                            ++i;
                        }
                    }
                }
            } else {
                System.out.println("Problem with parameter: " + s);
                return null;
            }
            ++k;
        }
        return outfile;
    }

    Properties fetchParams(String filename) {
        Properties p = new Properties();
        try {
            FileInputStream is = new FileInputStream(filename);
            p.load(is);
            ((InputStream)is).close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
        int i = 0;
        while (i < this.paramNames.length) {
            if (this.paramValues[i] != null) {
                ((Hashtable)p).put(this.paramNames[i], this.paramValues[i]);
            }
            ++i;
        }
        return p;
    }

    void writeParams(String filename, Properties p) {
        try {
            FileOutputStream os = new FileOutputStream(filename);
            p.save(os, "GetAreaFile properties");
            os.flush();
            ((OutputStream)os).close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

