/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas.adde;

import edu.wisc.ssec.mcidas.McIDASUtil;
import edu.wisc.ssec.mcidas.adde.AddeURLConnection;
import edu.wisc.ssec.mcidas.adde.AddeURLException;
import java.io.DataInputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;

public class AddeTextReader {
    private int status = 0;
    private String statusString = "OK";
    private boolean debug = false;
    private Vector linesOfText = null;
    private URLConnection urlc;
    private DataInputStream dis;
    private final int HEARTBEAT = 11223344;

    public AddeTextReader(String request) {
        try {
            URL url = new URL(request);
            boolean bl = this.debug = request.indexOf("debug=true") > 0;
            if (this.debug) {
                System.out.println("Request: " + request);
            }
            this.urlc = url.openConnection();
            InputStream is = this.urlc.getInputStream();
            this.dis = new DataInputStream(is);
        }
        catch (AddeURLException ae) {
            this.status = -1;
            this.statusString = "No data found";
            String aes = ae.toString();
            if (aes.indexOf(" Accounting ") != -1) {
                this.statusString = "No accounting data";
                this.status = -3;
            }
            if (this.debug) {
                System.out.println("AddeTextReader Exception:" + aes);
            }
        }
        catch (Exception e) {
            this.status = -2;
            if (this.debug) {
                System.out.println("AddeTextReader Exception:" + e);
            }
            this.statusString = "Error opening connection: " + e;
        }
        this.linesOfText = new Vector();
        if (this.status == 0) {
            this.readText(((AddeURLConnection)this.urlc).getRequestType());
        }
        if (this.linesOfText.size() < 1) {
            this.statusString = "No data read";
        }
        this.status = this.linesOfText.size();
    }

    private void readText(int reqType) {
        switch (reqType) {
            case 6: {
                this.readTextFile();
                break;
            }
            case 7: {
                this.readWxText();
                break;
            }
            case 8: {
                this.readObText();
            }
        }
    }

    private void readTextFile() {
        try {
            int numBytes = ((AddeURLConnection)this.urlc).getInitialRecordSize();
            if (this.debug) {
                System.out.println("ReadTextFile: initial numBytes = " + numBytes);
            }
            numBytes = this.dis.readInt();
            while ((numBytes = this.dis.readInt()) != 0) {
                if (this.debug) {
                    System.out.println("ReadTextFile: numBytes = " + numBytes);
                }
                byte[] data = new byte[numBytes];
                this.dis.readFully(data, 0, numBytes);
                String s = new String(data);
                if (this.debug) {
                    System.out.println(s);
                }
                this.linesOfText.addElement(s);
            }
        }
        catch (Exception iox) {
            this.statusString = " " + iox;
        }
    }

    private void readWxText() {
        try {
            int numBytes = ((AddeURLConnection)this.urlc).getInitialRecordSize();
            if (this.debug) {
                System.out.println("ReadWxText: initial numBytes = " + numBytes);
            }
            byte[] expandedRequest = new byte[numBytes];
            this.dis.readFully(expandedRequest, 0, numBytes);
            String s = new String(expandedRequest);
            if (this.debug) {
                System.out.println("Server interpreted request as:\n " + s);
            }
            while ((numBytes = this.dis.readInt()) == 4) {
                int check = this.dis.readInt();
                if (check == 11223344) continue;
                numBytes = check;
                break;
            }
            if (this.debug) {
                System.out.println("numBytes for text = " + numBytes);
            }
            block3: while (numBytes != 0) {
                byte[] header = new byte[64];
                this.dis.readFully(header, 0, 64);
                String head = new String(header);
                if (this.debug) {
                    System.out.println(this.decodeWxTextHeader(header));
                }
                byte[] text = new byte[numBytes - 64];
                this.dis.readFully(text, 0, numBytes - 64);
                int nLines = text.length / 80;
                if (this.debug) {
                    System.out.println("nLines = " + nLines);
                }
                int i = 0;
                while (i < nLines) {
                    String line = new String(text, i * 80, 80);
                    this.linesOfText.add(line);
                    ++i;
                }
                while ((numBytes = this.dis.readInt()) == 4) {
                    int check = this.dis.readInt();
                    if (check == 11223344) continue;
                    numBytes = check;
                    continue block3;
                }
            }
        }
        catch (Exception iox) {
            this.statusString = " " + iox;
        }
    }

    private void readObText() {
        try {
            int numBytes = ((AddeURLConnection)this.urlc).getInitialRecordSize();
            if (this.debug) {
                System.out.println("ReadObText: initial numBytes = " + numBytes);
            }
            while (numBytes != 0) {
                byte[] header = new byte[numBytes];
                this.dis.readFully(header, 0, numBytes);
                String s = new String(header);
                if (this.debug) {
                    System.out.println(this.decodeObsHeader(header));
                }
                numBytes = this.dis.readInt();
                if (this.debug) {
                    System.out.println("numBytes for text = " + numBytes);
                }
                byte[] text = new byte[numBytes];
                this.dis.readFully(text, 0, numBytes);
                int nLines = text.length / 80;
                if (this.debug) {
                    System.out.println("nLines = " + nLines);
                }
                int i = 0;
                while (i < nLines) {
                    String line = new String(text, i * 80, 80);
                    this.linesOfText.add(line);
                    ++i;
                }
                numBytes = this.dis.readInt();
            }
        }
        catch (Exception iox) {
            this.statusString = " " + iox;
        }
    }

    public String getStatus() {
        return this.statusString;
    }

    public int getStatusCode() {
        return this.status;
    }

    public int getNumLines() {
        return this.linesOfText.size();
    }

    public String getText() {
        StringBuffer buf = new StringBuffer();
        if (this.getStatusCode() <= 0) {
            buf.append(this.getStatus());
        } else {
            Iterator iter = ((AbstractList)this.linesOfText).iterator();
            while (iter.hasNext()) {
                buf.append((String)iter.next());
                buf.append("\n");
            }
        }
        return buf.toString();
    }

    public static void main(String[] args) throws Exception {
        String request = args.length == 0 ? "adde://adde.ucar.edu/text?file=PUBLIC.SRV" : args[0];
        AddeTextReader atr = new AddeTextReader(request);
        String status = atr.getStatus();
        System.out.println("\n" + atr.getText());
    }

    private String decodeObsHeader(byte[] header) {
        StringBuffer buf = new StringBuffer();
        int[] values = McIDASUtil.bytesToIntegerArray(header, 0, 13);
        buf.append("Ver = ");
        buf.append(values[0]);
        buf.append(" ObType = ");
        buf.append(values[1]);
        buf.append(" ActFlag = ");
        buf.append(values[2]);
        buf.append(" IDType = ");
        buf.append(values[9]);
        buf.append("\nStarting at ");
        buf.append(values[3]);
        buf.append(" ");
        buf.append(values[4]);
        buf.append(" ");
        buf.append(values[5]);
        buf.append("\nEnding   at ");
        buf.append(values[6]);
        buf.append(" ");
        buf.append(values[7]);
        buf.append(" ");
        buf.append(values[8]);
        return buf.toString();
    }

    private String decodeWxTextHeader(byte[] header) {
        StringBuffer buf = new StringBuffer();
        int[] values = McIDASUtil.bytesToIntegerArray(header, 0, 13);
        buf.append("SOU    nb  location   day    time  WMO     WSTN APRO ASTN\n");
        buf.append("---  ----  -------- ------- ------ ------- ---- ---- ----\n");
        buf.append(McIDASUtil.intBitsToString(values[0]));
        buf.append(values[1]);
        buf.append(" ");
        buf.append(values[2]);
        buf.append(" ");
        buf.append(values[10]);
        buf.append(" ");
        buf.append(values[3]);
        buf.append(" ");
        buf.append(McIDASUtil.intBitsToString(values[4]));
        buf.append(values[5]);
        buf.append("  ");
        buf.append(McIDASUtil.intBitsToString(values[6]));
        buf.append(" ");
        buf.append(McIDASUtil.intBitsToString(values[7]));
        buf.append(" ");
        buf.append(McIDASUtil.intBitsToString(values[8]));
        return buf.toString();
    }

    static {
        try {
            String handlers = System.getProperty("java.protocol.handler.pkgs");
            String newProperty = null;
            if (handlers == null) {
                newProperty = "edu.wisc.ssec.mcidas";
            } else if (handlers.indexOf("edu.wisc.ssec.mcidas") < 0) {
                newProperty = "edu.wisc.ssec.mcidas | " + handlers;
            }
            if (newProperty != null) {
                System.setProperty("java.protocol.handler.pkgs", newProperty);
            }
        }
        catch (Exception e) {
            System.out.println("Unable to set System Property: java.protocol.handler.pkgs");
        }
    }
}

