/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas.adde;

import edu.wisc.ssec.mcidas.AreaDirectory;
import edu.wisc.ssec.mcidas.AreaDirectoryList;
import edu.wisc.ssec.mcidas.McIDASException;
import edu.wisc.ssec.mcidas.adde.ReadTextFile;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;

public class AddeServerInfo {
    private String[] serverList;
    private String selectedServer = null;
    private boolean hasServers = false;
    private String dataType = null;
    private String[] bandNames;
    private boolean hasBandNames = false;
    private String[] groupsList;
    private String selectedGroup = null;
    private boolean hasGroup = false;
    private String[] datasetsList;
    private String selectedDataset = null;
    private boolean hasDataset = false;
    private AreaDirectory[][] dirs;
    private String[] dirsTimes;
    private Vector table;
    private Vector groups;
    private String status = "OK";
    private String userproj = null;
    private String DATEFORMAT = "yyyy-MM-dd / HH:mm:ss";
    private boolean debug = false;
    private boolean priv = false;

    public AddeServerInfo() {
        this(null);
    }

    public AddeServerInfo(String[] l) {
        String[] list = l;
        if (list == null) {
            list = new String[]{"adde.unidata.ucar.edu", "suomi.ssec.wisc.edu", "motherlode.ucar.edu", "uwamrc.ssec.wisc.edu"};
        }
        this.serverList = new String[list.length];
        int i = 0;
        while (i < list.length) {
            this.serverList[i] = list[i];
            ++i;
        }
        this.hasServers = true;
    }

    public String[] getServerList() {
        if (this.hasServers) {
            return this.serverList;
        }
        return null;
    }

    public String getSelectedServer() {
        return this.selectedServer;
    }

    public int setSelectedServer(String s, String type) {
        this.selectedServer = s.trim();
        int istatus = 0;
        this.dataType = type.trim();
        this.groups = new Vector();
        this.status = "Failed to get PUBLIC.SRV file from from server " + s + ".";
        this.priv = false;
        try {
            String req = "adde://" + this.selectedServer + "/text?file=PUBLIC.SRV";
            if (this.userproj != null) {
                String req2;
                req = req2 = req + "&" + this.userproj + "&version=1";
            }
            if (this.debug) {
                System.out.println("Req:" + req);
            }
            ReadTextFile rtf = new ReadTextFile(req);
            if (this.debug) {
                System.out.println("Status from RTF=" + rtf.getStatus());
            }
            if (rtf.getStatusCode() == -3) {
                return -1;
            }
            if (!rtf.getStatus().equals("OK")) {
                req = "adde://" + this.selectedServer + "/text?file=RESOLV.SRV";
                if (this.userproj != null) {
                    String req2;
                    req = req2 = req + "&" + this.userproj + "&version=1";
                }
                if (this.debug) {
                    System.out.println("2ndReq:" + req);
                }
                this.priv = true;
                rtf = new ReadTextFile(req);
                if (this.debug) {
                    System.out.println("Status from 2ndRTF=" + rtf.getStatus());
                }
            }
            Vector table = rtf.getText();
            this.status = "Failed to locate required information on server " + s + ".";
            int i = 0;
            while (i < table.size()) {
                String a = (String)table.elementAt(i);
                if (this.debug) {
                    System.out.println("table = " + a);
                }
                StringTokenizer st = new StringTokenizer(a, ",");
                int num = st.countTokens();
                String[] tok = new String[num];
                String[] val = new String[num];
                int indexType = -1;
                int indexN1 = -1;
                int indexN2 = -1;
                int indexC = -1;
                int j = 0;
                while (j < num) {
                    String p = st.nextToken();
                    int x = p.indexOf("=");
                    if (x >= 0) {
                        tok[j] = p.substring(0, x);
                        val[j] = p.substring(x + 1).trim();
                        if (tok[j].equalsIgnoreCase("type")) {
                            indexType = j;
                        }
                        if (tok[j].equalsIgnoreCase("N1")) {
                            indexN1 = j;
                        }
                        if (tok[j].equalsIgnoreCase("N2")) {
                            indexN2 = j;
                        }
                        if (tok[j].equalsIgnoreCase("C")) {
                            indexC = j;
                        }
                    }
                    ++j;
                }
                if (indexType >= 0 && val[indexType].equalsIgnoreCase(this.dataType) && indexN1 >= 0 && indexN2 >= 0 && indexC >= 0) {
                    boolean hit = false;
                    int j2 = 0;
                    while (j2 < this.groups.size()) {
                        Vector vg = (Vector)this.groups.elementAt(j2);
                        String g = (String)vg.elementAt(0);
                        if (g.equalsIgnoreCase(val[indexN1])) {
                            hit = true;
                            Vector v = (Vector)vg.elementAt(1);
                            v.addElement(val[indexN2]);
                            v = (Vector)vg.elementAt(2);
                            v.addElement(val[indexC]);
                        }
                        ++j2;
                    }
                    if (!hit) {
                        Vector<Object> v = new Vector<Object>();
                        v.addElement(val[indexN1]);
                        Vector<String> v2 = new Vector<String>();
                        v2.addElement(val[indexN2]);
                        Vector<String> v3 = new Vector<String>();
                        v3.addElement(val[indexC]);
                        v.addElement(v2);
                        v.addElement(v3);
                        this.groups.addElement(v);
                    }
                }
                ++i;
            }
            String reqBand = "adde://" + this.selectedServer + "/text?file=SATBAND";
            if (this.userproj != null) {
                String reqBand2;
                reqBand = reqBand2 = reqBand + "&" + this.userproj + "&version=1";
            }
            if (this.debug) {
                System.out.println("ReqBand:" + reqBand);
            }
            ReadTextFile rtfBand = new ReadTextFile(reqBand);
            if (this.debug) {
                System.out.println("Status from RTFBand=" + rtfBand.getStatus());
            }
            Vector vBand = null;
            if (rtfBand.getStatus().equals("OK")) {
                vBand = rtfBand.getText();
                int num = vBand.size();
                this.bandNames = new String[num];
                int i2 = 0;
                while (i2 < num) {
                    this.bandNames[i2] = (String)vBand.elementAt(i2);
                    if (this.debug) {
                        System.out.println("band = " + this.bandNames[i2]);
                    }
                    ++i2;
                }
                this.hasBandNames = true;
            }
            this.status = "ADDE group & dataset information retrieved from server " + s + ".";
            istatus = 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -2;
        }
        return istatus;
    }

    public String[] getGroupList() {
        if (this.priv) {
            return null;
        }
        int num = this.groups.size();
        String[] sg = new String[num];
        int i = 0;
        while (i < num) {
            Vector v = (Vector)this.groups.elementAt(i);
            sg[i] = (String)v.elementAt(0);
            ++i;
        }
        this.status = "List of groups on server " + this.selectedServer + " obtained.";
        return sg;
    }

    public String[] getDatasetList() {
        int num = this.groups.size();
        int i = 0;
        while (i < num) {
            Vector v = (Vector)this.groups.elementAt(i);
            String g = (String)v.elementAt(0);
            if (g.equalsIgnoreCase(this.selectedGroup)) {
                Vector ds = (Vector)v.elementAt(1);
                int numds = ds.size();
                String[] sdl = new String[numds];
                int j = 0;
                while (j < numds) {
                    sdl[j] = (String)ds.elementAt(j);
                    ++j;
                }
                this.status = "Dataset list for server " + this.selectedServer + " and group " + this.selectedGroup + " obtained.";
                return sdl;
            }
            ++i;
        }
        this.status = "Dataset list for server " + this.selectedServer + " and group " + this.selectedGroup + " not found.";
        return null;
    }

    public String[] getDatasetListDescriptions() {
        int num = this.groups.size();
        int i = 0;
        while (i < num) {
            Vector v = (Vector)this.groups.elementAt(i);
            String g = (String)v.elementAt(0);
            if (g.equalsIgnoreCase(this.selectedGroup)) {
                Vector dsd = (Vector)v.elementAt(2);
                int numdsd = dsd.size();
                String[] sdld = new String[numdsd];
                int j = 0;
                while (j < numdsd) {
                    sdld[j] = (String)dsd.elementAt(j);
                    ++j;
                }
                this.status = "Dataset list for server " + this.selectedServer + " and group " + this.selectedGroup + " obtained.";
                return sdld;
            }
            ++i;
        }
        this.status = "Dataset list for server " + this.selectedServer + " and group " + this.selectedGroup + " not found.";
        return null;
    }

    public String[] getDateTimeList() {
        this.status = "Trying to get date-times for " + this.selectedGroup + " from server " + this.selectedServer;
        if (!this.hasGroup || !this.hasDataset) {
            return null;
        }
        StringBuffer addeCmdBuff = new StringBuffer("adde://" + this.selectedServer + "/imagedir?group=" + this.selectedGroup);
        addeCmdBuff.append("&descr=");
        addeCmdBuff.append(this.selectedDataset);
        if (this.userproj != null) {
            addeCmdBuff.append("&" + this.userproj);
        }
        addeCmdBuff.append("&pos=all&version=1");
        if (this.debug) {
            System.out.println("cmd:" + addeCmdBuff.toString());
        }
        String[] times = new String[]{"No data available"};
        try {
            AreaDirectoryList adir = new AreaDirectoryList(addeCmdBuff.toString());
            this.dirs = adir.getSortedDirs();
            int numTimes = this.dirs.length;
            times = new String[numTimes];
            SimpleDateFormat sdf = new SimpleDateFormat();
            sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
            sdf.applyPattern(this.DATEFORMAT);
            int i = 0;
            while (i < numTimes) {
                times[i] = sdf.format(this.dirs[i][0].getNominalTime(), new StringBuffer(), new FieldPosition(0)).toString();
                ++i;
            }
            this.dirsTimes = times;
        }
        catch (McIDASException e) {
            this.status = "Error getting times";
        }
        return times;
    }

    public AreaDirectory[][] getAreaDirectories() {
        return this.dirs;
    }

    public void setSelectedGroup(String g) {
        this.selectedGroup = g;
        this.hasGroup = true;
    }

    public void setSelectedDataset(String d) {
        this.selectedDataset = d;
        this.hasDataset = true;
    }

    public String[] getBandNames() {
        if (this.hasBandNames) {
            return this.bandNames;
        }
        return null;
    }

    public String getRequestString(int reqestType) {
        return null;
    }

    public void setUserIDandProjString(String up) {
        this.userproj = up;
    }

    public String getStatus() {
        return this.status;
    }

    public static void main(String[] args) {
        AddeServerInfo asi = new AddeServerInfo();
        int sstat = asi.setSelectedServer("suomi.ssec.wisc.edu", "image");
        System.out.println("Status = " + asi.getStatus() + "  code=" + sstat);
        String[] a = asi.getGroupList();
        System.out.println("Status = " + asi.getStatus());
        int i = 0;
        while (i < a.length) {
            System.out.println("group = " + a[i]);
            asi.setSelectedGroup(a[i]);
            String[] b = asi.getDatasetList();
            String[] c = asi.getDatasetListDescriptions();
            int k = 0;
            while (k < b.length) {
                System.out.println("    " + b[k] + " == " + c[k]);
                if (i == 0 && k == 0) {
                    asi.setSelectedDataset(b[k]);
                    String[] dt = asi.getDateTimeList();
                    int m = 0;
                    while (m < dt.length) {
                        System.out.println("DateTime = " + dt[m]);
                        ++m;
                    }
                }
                ++k;
            }
            ++i;
        }
        System.out.println("Status = " + asi.getStatus());
    }
}

