/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas;

import edu.wisc.ssec.mcidas.AREAnav;
import edu.wisc.ssec.mcidas.AreaDirectory;
import edu.wisc.ssec.mcidas.AreaFileException;
import edu.wisc.ssec.mcidas.McIDASException;
import edu.wisc.ssec.mcidas.McIDASUtil;
import edu.wisc.ssec.mcidas.adde.GetAreaGUI;
import java.applet.Applet;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public class AreaFile {
    public static final int AD_STATUS = 0;
    public static final int AD_VERSION = 1;
    public static final int AD_SENSORID = 2;
    public static final int AD_IMGDATE = 3;
    public static final int AD_IMGTIME = 4;
    public static final int AD_STLINE = 5;
    public static final int AD_STELEM = 6;
    public static final int AD_NUMLINES = 8;
    public static final int AD_NUMELEMS = 9;
    public static final int AD_DATAWIDTH = 10;
    public static final int AD_LINERES = 11;
    public static final int AD_ELEMRES = 12;
    public static final int AD_NUMBANDS = 13;
    public static final int AD_PFXSIZE = 14;
    public static final int AD_PROJNUM = 15;
    public static final int AD_CRDATE = 16;
    public static final int AD_CRTIME = 17;
    public static final int AD_BANDMAP = 18;
    public static final int AD_DATAOFFSET = 33;
    public static final int AD_NAVOFFSET = 34;
    public static final int AD_VALCODE = 35;
    public static final int AD_STARTDATE = 45;
    public static final int AD_STARTTIME = 46;
    public static final int AD_STARTSCAN = 47;
    public static final int AD_DOCLENGTH = 48;
    public static final int AD_CALLENGTH = 49;
    public static final int AD_LEVLENGTH = 50;
    public static final int AD_SRCTYPE = 51;
    public static final int AD_CALTYPE = 52;
    public static final int AD_AVGSMPFLAG = 53;
    public static final int AD_SRCTYPEORIG = 56;
    public static final int AD_AUXOFFSET = 59;
    public static final int AD_CALOFFSET = 62;
    public static final int AD_DIRSIZE = 64;
    public static final int VERSION_NUMBER = 4;
    private static boolean handlerLoaded = false;
    private boolean flipwords;
    private boolean fileok;
    private boolean hasReadData = false;
    private DataInputStream af;
    private int status = 0;
    private int navLoc;
    private int calLoc;
    private int auxLoc;
    private int datLoc;
    private int navbytes;
    private int calbytes;
    private int auxbytes;
    private int linePrefixLength;
    private int lineDataLength;
    private int lineLength;
    private int numberLines;
    private long position;
    private int skipByteCount;
    private long newPosition;
    private int numBands;
    int[] dir;
    int[] nav = null;
    int[] cal = null;
    int[] aux = null;
    int[][][] data;
    private AreaDirectory areaDirectory;
    private String imageSource = null;
    private AREAnav areaNav;

    public static boolean isURLHandlerLoaded() {
        return handlerLoaded;
    }

    public AreaFile(String source) throws AreaFileException {
        this.imageSource = source;
        if (this.imageSource.startsWith("adde://") && (this.imageSource.endsWith("image?") || this.imageSource.endsWith("imagedata?"))) {
            GetAreaGUI gag = new GetAreaGUI((Frame)null, true, "Get data", false, true);
            gag.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AreaFile.this.imageSource = e.getActionCommand();
                }
            });
            gag.show();
        }
        try {
            this.af = new DataInputStream(new BufferedInputStream(new FileInputStream(this.imageSource), 2048));
        }
        catch (IOException eIO) {
            try {
                URL url = new URL(this.imageSource);
                URLConnection urlc = url.openConnection();
                InputStream is = urlc.getInputStream();
                this.af = new DataInputStream(new BufferedInputStream(is));
            }
            catch (Exception e) {
                this.fileok = false;
                throw new AreaFileException("Error opening AreaFile: " + e);
            }
        }
        this.fileok = true;
        this.position = 0L;
        this.readMetaData();
    }

    public AreaFile(String filename, Applet parent) throws AreaFileException {
        URL url;
        this.imageSource = filename;
        try {
            url = new URL(parent.getDocumentBase(), filename);
        }
        catch (MalformedURLException e) {
            this.fileok = false;
            throw new AreaFileException("Error opening URL for AreaFile:" + e);
        }
        try {
            this.af = new DataInputStream(new BufferedInputStream(url.openStream()));
        }
        catch (IOException e) {
            this.fileok = false;
            throw new AreaFileException("Error opening AreaFile:" + e);
        }
        this.fileok = true;
        this.position = 0L;
        this.readMetaData();
    }

    public AreaFile(URL url) throws AreaFileException {
        this.imageSource = url.toString();
        try {
            this.af = new DataInputStream(new BufferedInputStream(url.openStream()));
        }
        catch (IOException e) {
            this.fileok = false;
            throw new AreaFileException("Error opening URL for AreaFile:" + e);
        }
        this.fileok = true;
        this.position = 0L;
        this.readMetaData();
    }

    private void readMetaData() throws AreaFileException {
        if (!this.fileok) {
            throw new AreaFileException("Error reading AreaFile directory");
        }
        this.dir = new int[64];
        int i = 0;
        while (i < 64) {
            try {
                this.dir[i] = this.af.readInt();
            }
            catch (IOException e) {
                this.status = -1;
                throw new AreaFileException("Error reading AreaFile directory:" + e);
            }
            ++i;
        }
        this.position += 256L;
        if (this.dir[1] != 4) {
            McIDASUtil.flip(this.dir, 0, 19);
            if (this.dir[1] != 4) {
                throw new AreaFileException("Invalid version number - probably not an AREA file");
            }
            if ((this.dir[20] & 0xFFFF) == 0) {
                McIDASUtil.flip(this.dir, 20, 20);
            }
            McIDASUtil.flip(this.dir, 21, 23);
            McIDASUtil.flip(this.dir, 32, 50);
            McIDASUtil.flip(this.dir, 53, 55);
            McIDASUtil.flip(this.dir, 57, 63);
            this.flipwords = true;
        }
        this.areaDirectory = new AreaDirectory(this.dir);
        this.navLoc = this.dir[34];
        this.calLoc = this.dir[62];
        this.auxLoc = this.dir[59];
        this.datLoc = this.dir[33];
        this.numBands = this.dir[13];
        this.linePrefixLength = this.dir[48] + this.dir[49] + this.dir[50];
        if (this.dir[35] != 0) {
            this.linePrefixLength += 4;
        }
        if (this.linePrefixLength != this.dir[14]) {
            throw new AreaFileException("Invalid line prefix length in AREA file.");
        }
        this.lineDataLength = this.numBands * this.dir[9] * this.dir[10];
        this.lineLength = this.linePrefixLength + this.lineDataLength;
        this.numberLines = this.dir[8];
        if (this.datLoc > 0 && this.datLoc != -2139062144) {
            this.navbytes = this.datLoc - this.navLoc;
            this.calbytes = this.datLoc - this.calLoc;
            this.auxbytes = this.datLoc - this.auxLoc;
        }
        if (this.auxLoc > 0 && this.auxLoc != -2139062144) {
            this.navbytes = this.auxLoc - this.navLoc;
            this.calbytes = this.auxLoc - this.calLoc;
        }
        if (this.calLoc > 0 && this.calLoc != -2139062144) {
            this.navbytes = this.calLoc - this.navLoc;
        }
        if (this.navLoc > 0 && this.navbytes > 0) {
            this.nav = new int[this.navbytes / 4];
            this.newPosition = this.navLoc;
            this.skipByteCount = (int)(this.newPosition - this.position);
            try {
                this.af.skipBytes(this.skipByteCount);
            }
            catch (IOException e) {
                this.status = -1;
                throw new AreaFileException("Error skipping AreaFile bytes: " + e);
            }
            i = 0;
            while (i < this.navbytes / 4) {
                try {
                    this.nav[i] = this.af.readInt();
                }
                catch (IOException e) {
                    this.status = -1;
                    throw new AreaFileException("Error reading AreaFile navigation:" + e);
                }
                ++i;
            }
            if (this.flipwords) {
                this.flipnav(this.nav);
            }
            this.position = this.navLoc + this.navbytes;
        }
        if (this.calLoc > 0 && this.calbytes > 0) {
            this.cal = new int[this.calbytes / 4];
            this.newPosition = this.calLoc;
            this.skipByteCount = (int)(this.newPosition - this.position);
            try {
                this.af.skipBytes(this.skipByteCount);
            }
            catch (IOException e) {
                this.status = -1;
                throw new AreaFileException("Error skipping AreaFile bytes: " + e);
            }
            i = 0;
            while (i < this.calbytes / 4) {
                try {
                    this.cal[i] = this.af.readInt();
                }
                catch (IOException e) {
                    this.status = -1;
                    throw new AreaFileException("Error reading AreaFile calibration:" + e);
                }
                ++i;
            }
            this.position = this.calLoc + this.calbytes;
        }
        if (this.auxLoc > 0 && this.auxbytes > 0) {
            this.aux = new int[this.auxbytes / 4];
            this.newPosition = this.auxLoc;
            this.skipByteCount = (int)(this.newPosition - this.position);
            try {
                this.af.skipBytes(this.skipByteCount);
            }
            catch (IOException e) {
                this.status = -1;
                throw new AreaFileException("Error skipping AreaFile bytes: " + e);
            }
            i = 0;
            while (i < this.auxbytes / 4) {
                try {
                    this.aux[i] = this.af.readInt();
                }
                catch (IOException e) {
                    this.status = -1;
                    throw new AreaFileException("Error reading AreaFile aux block:" + e);
                }
                ++i;
            }
            this.position = this.auxLoc + this.auxbytes;
        }
        this.status = 1;
    }

    public String getImageSource() {
        return this.imageSource;
    }

    public int[] getDir() {
        return this.dir;
    }

    public AreaDirectory getAreaDirectory() {
        return this.areaDirectory;
    }

    public int[] getNav() {
        if (this.navLoc <= 0 || this.navLoc == -2139062144) {
            this.nav = null;
        }
        return this.nav;
    }

    public AREAnav getNavigation() throws AreaFileException {
        if (this.areaNav == null) {
            try {
                this.areaNav = AREAnav.makeAreaNav(this.getNav(), this.getAux());
            }
            catch (McIDASException excp) {
                this.areaNav = null;
            }
        }
        return this.areaNav;
    }

    public int[] getCal() {
        if (this.calLoc <= 0 || this.calLoc == -2139062144) {
            this.cal = null;
        }
        return this.cal;
    }

    public int[] getAux() {
        if (this.auxLoc <= 0 || this.auxLoc == -2139062144) {
            this.aux = null;
        }
        return this.aux;
    }

    public int[][][] getData() throws AreaFileException {
        if (!this.hasReadData) {
            this.readData();
        }
        return this.data;
    }

    public int[][] getData(int lineNumber, int eleNumber, int numLines, int numEles) throws AreaFileException {
        return this.getData(lineNumber, eleNumber, numLines, numEles, 1);
    }

    public int[][] getData(int lineNumber, int eleNumber, int numLines, int numEles, int bandNumber) throws AreaFileException {
        if (!this.hasReadData) {
            this.readData();
        }
        int[][] subset = new int[numLines][numEles];
        int i = 0;
        while (i < numLines) {
            int ii = i + lineNumber;
            int j = 0;
            while (j < numEles) {
                int jj = j + eleNumber;
                subset[i][j] = ii < 0 || ii > this.dir[8] - 1 || jj < 0 || jj > this.dir[9] - 1 ? 0 : this.data[bandNumber - 1][ii][jj];
                ++j;
            }
            ++i;
        }
        return subset;
    }

    /*
     * Unable to fully structure code
     */
    private void readData() throws AreaFileException {
        numLines = this.dir[8];
        numEles = this.dir[9];
        if (!this.fileok) {
            throw new AreaFileException("Error reading AreaFile data");
        }
        this.data = new int[this.numBands][numLines][numEles];
        i = 0;
        block4: while (i < numLines) {
            block16: {
                try {
                    this.newPosition = this.datLoc + this.linePrefixLength + i * this.lineLength;
                    this.skipByteCount = (int)(this.newPosition - this.position);
                    this.af.skipBytes(this.skipByteCount);
                    this.position = this.newPosition;
                    break block16;
                }
                catch (IOException e) {
                    j = 0;
                    ** while (j < numEles)
                }
lbl-1000:
                // 1 sources

                {
                    k = 0;
                    while (k < this.numBands) {
                        this.data[k][i][j] = 0;
                        ++k;
                    }
                    ++j;
                    continue;
lbl25:
                    // 1 sources

                    break block4;
                }
            }
            j = 0;
            while (j < numEles) {
                k = 0;
                while (k < this.numBands) {
                    if (j > this.lineDataLength) {
                        this.data[k][i][j] = 0;
                    } else {
                        try {
                            if (this.dir[10] == 1) {
                                this.data[k][i][j] = this.af.readByte();
                                if (this.data[k][i][j] < 0) {
                                    v0 = this.data[k][i];
                                    v1 = j;
                                    v0[v1] = v0[v1] + 256;
                                }
                                ++this.position;
                            }
                            if (this.dir[10] == 2) {
                                shdata = this.af.readShort();
                                this.data[k][i][j] = this.flipwords != false ? shdata >> 8 & 255 | shdata << 8 & 65280 : (int)shdata;
                                this.position += 2L;
                            }
                            if (this.dir[10] == 4) {
                                intdata = this.af.readInt();
                                this.data[k][i][j] = this.flipwords != false ? intdata >>> 24 & 255 | intdata >>> 8 & 65280 | (intdata & 255) << 24 | (intdata & 65280) << 8 : intdata;
                                this.position += 4L;
                            }
                        }
                        catch (IOException e) {
                            this.data[k][i][j] = 0;
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    private void flipnav(int[] nav) {
        if (nav[0] == 1196835154) {
            McIDASUtil.flip(nav, 2, 126);
            McIDASUtil.flip(nav, 129, 254);
            McIDASUtil.flip(nav, 257, 382);
            McIDASUtil.flip(nav, 385, 510);
            McIDASUtil.flip(nav, 513, 638);
        } else if (nav[0] == 1145918032) {
            McIDASUtil.flip(nav, 1, 43);
            McIDASUtil.flip(nav, 45, 51);
        } else if (nav[0] == 1414091343) {
            McIDASUtil.flip(nav, 1, 119);
        } else {
            McIDASUtil.flip(nav, 1, nav.length - 1);
        }
    }

    static {
        try {
            String handlers = System.getProperty("java.protocol.handler.pkgs");
            String newProperty = null;
            if (handlers == null) {
                newProperty = "edu.wisc.ssec.mcidas";
            } else if (handlers.indexOf("edu.wisc.ssec.mcidas") < 0) {
                newProperty = "edu.wisc.ssec.mcidas | " + handlers;
            }
            if (newProperty != null) {
                System.setProperty("java.protocol.handler.pkgs", newProperty);
            }
            handlerLoaded = true;
        }
        catch (Exception e) {
            System.out.println("Unable to set System Property: java.protocol.handler.pkgs");
        }
        handlerLoaded = true;
    }
}

