/*
 * Decompiled with CFR 0.152.
 */
package dods.dap;

import dods.dap.BaseType;
import dods.dap.DataReadException;
import dods.dap.PrimitiveVector;
import dods.dap.ServerVersion;
import dods.dap.StatusUI;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;

public class BytePrimitiveVector
extends PrimitiveVector
implements Cloneable {
    private byte[] vals;

    public BytePrimitiveVector(BaseType var) {
        super(var);
    }

    public Object clone() {
        BytePrimitiveVector v = (BytePrimitiveVector)super.clone();
        if (this.vals != null) {
            v.vals = new byte[this.vals.length];
            System.arraycopy(this.vals, 0, v.vals, 0, this.vals.length);
        }
        return v;
    }

    public int getLength() {
        return this.vals.length;
    }

    public void setLength(int len) {
        this.vals = new byte[len];
    }

    public final byte getValue(int i) {
        return this.vals[i];
    }

    public final void setValue(int i, byte newVal) {
        this.vals[i] = newVal;
    }

    public void printVal(PrintWriter os, String space) {
        int len = this.vals.length;
        int i = 0;
        while (i < len - 1) {
            os.print(this.vals[i] & 0xFF);
            os.print(", ");
            ++i;
        }
        if (len > 0) {
            os.print(this.vals[len - 1] & 0xFF);
        }
    }

    public void printSingleVal(PrintWriter os, int index) {
        os.print(this.vals[index] & 0xFF);
    }

    public synchronized void deserialize(DataInputStream source, ServerVersion sv, StatusUI statusUI) throws IOException, EOFException, DataReadException {
        int modFour = this.vals.length % 4;
        int pad = modFour != 0 ? 4 - modFour : 0;
        int i = 0;
        while (i < this.vals.length) {
            this.vals[i] = source.readByte();
            if (statusUI != null) {
                statusUI.incrementByteCount(1);
                if (statusUI.userCancelled()) {
                    throw new DataReadException("User cancelled");
                }
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < pad) {
            byte unused = source.readByte();
            ++i2;
        }
        if (statusUI != null) {
            statusUI.incrementByteCount(pad);
        }
    }

    public void externalize(DataOutputStream sink) throws IOException {
        int modFour = this.vals.length % 4;
        int pad = modFour != 0 ? 4 - modFour : 0;
        int i = 0;
        while (i < this.vals.length) {
            sink.writeByte(this.vals[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < pad) {
            sink.writeByte(0);
            ++i2;
        }
    }

    public void externalize(DataOutputStream sink, int start, int stop, int stride) throws IOException {
        int count = 0;
        int i = start;
        while (i <= stop) {
            sink.writeByte(this.vals[i]);
            ++count;
            i += stride;
        }
        int modFour = count % 4;
        int pad = modFour != 0 ? 4 - modFour : 0;
        int i2 = 0;
        while (i2 < pad) {
            sink.writeByte(0);
            ++i2;
        }
    }

    public PrimitiveVector subset(int start, int stop, int stride) {
        BytePrimitiveVector n = new BytePrimitiveVector(this.getTemplate());
        stride = Math.max(stride, 1);
        stop = Math.max(start, stop);
        int length = 1 + (stop - start) / stride;
        n.setLength(length);
        int count = 0;
        int i = start;
        while (i <= stop) {
            n.setValue(count, this.vals[i]);
            ++count;
            i += stride;
        }
        return n;
    }

    public Object getInternalStorage() {
        return this.vals;
    }

    public void setInternalStorage(Object o) {
        this.vals = (byte[])o;
    }
}

