/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.rmi.RemoteException;
import javax.swing.JFrame;
import visad.DataImpl;
import visad.DataReferenceImpl;
import visad.Display;
import visad.Gridded3DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.ScalarMap;
import visad.UnionSet;
import visad.VisADException;
import visad.java3d.DisplayImplJ3D;

public class VisuTraj {
    int nbTrajectories = 60;
    float[][][] vectTrajectories;
    DataReferenceImpl referenceTrajectories;
    RealType latitude;
    RealType longitude;
    RealType profondeur;
    RealType trajectories;
    RealTupleType domain3D;

    DataImpl makeTrajectories() throws VisADException, RemoteException {
        SampledSet[] setTrajectories = new SampledSet[this.nbTrajectories];
        int t = 0;
        while (t < this.nbTrajectories) {
            float[][] traject = new float[3][5];
            int i = 0;
            while (i < 3) {
                int p = 0;
                while (p < 5) {
                    traject[i][p] = this.vectTrajectories[i][p][t];
                    ++p;
                }
                ++i;
            }
            setTrajectories[t] = new Gridded3DSet((MathType)this.domain3D, traject, 5, null, null, null);
            ++t;
        }
        return new UnionSet((MathType)this.domain3D, setTrajectories);
    }

    public void initVisad() {
        try {
            this.latitude = RealType.getRealType("latitude");
            this.longitude = RealType.getRealType("longitude");
            this.profondeur = RealType.getRealType("profondeur");
            this.trajectories = RealType.getRealType("trajectories");
            this.domain3D = new RealTupleType(this.latitude, this.longitude, this.profondeur);
            this.referenceTrajectories = new DataReferenceImpl("trajectories");
            DataImpl theTrajectories = this.makeTrajectories();
            this.referenceTrajectories.setData(theTrajectories);
            ScalarMap latMap = new ScalarMap(this.latitude, Display.YAxis);
            ScalarMap lonMap = new ScalarMap(this.longitude, Display.XAxis);
            ScalarMap altMap = new ScalarMap(this.profondeur, Display.ZAxis);
            ScalarMap colMap = new ScalarMap(this.profondeur, Display.RGBA);
            DisplayImplJ3D display = new DisplayImplJ3D("display");
            display.addMap(latMap);
            display.addMap(lonMap);
            display.addMap(altMap);
            display.addReference(this.referenceTrajectories);
            JFrame jframe = new JFrame("VisAD Tutorial");
            jframe.getContentPane().add(display.getComponent());
            ((Component)jframe).setSize(600, 600);
            ((Component)jframe).setLocation(300, 300);
            ((Component)jframe).setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
    }

    public void step(int t) {
        boolean n = false;
        try {
            Thread.sleep(100L);
            this.setData();
            DataImpl theTrajectories = this.makeTrajectories();
            this.referenceTrajectories.setData(theTrajectories);
            System.out.println(" iteration " + t);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
    }

    public void initData() {
        this.vectTrajectories = new float[3][5][this.nbTrajectories];
        int p = 0;
        while (p < this.nbTrajectories) {
            int i = 0;
            while (i < 3) {
                this.vectTrajectories[i][0][p] = (float)Math.random() * 50.1f;
                int t = 1;
                while (t < 5) {
                    this.vectTrajectories[i][t][p] = this.vectTrajectories[i][t - 1][p] + ((float)Math.random() - 0.5f) * 4.0f;
                    ++t;
                }
                ++i;
            }
            ++p;
        }
    }

    public void setData() {
        int p = 0;
        while (p < this.nbTrajectories) {
            int i = 0;
            while (i < 3) {
                int t = 0;
                while (t < 4) {
                    this.vectTrajectories[i][t][p] = this.vectTrajectories[i][t + 1][p];
                    ++t;
                }
                float[] fArray = this.vectTrajectories[i][4];
                int n = p;
                fArray[n] = fArray[n] + ((float)Math.random() - 0.5f) * 4.0f;
                ++i;
            }
            ++p;
        }
    }

    public static void main(String[] args) throws RemoteException, VisADException {
        VisuTraj vb = new VisuTraj();
        vb.initData();
        vb.initVisad();
        int it = 0;
        while (it < 500) {
            vb.step(it);
            ++it;
        }
    }
}

