/*
 * Decompiled with CFR 0.152.
 */
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.rmi.RemoteException;
import javax.media.j3d.GraphicsConfigTemplate3D;
import visad.ConstantMap;
import visad.DataReferenceImpl;
import visad.Display;
import visad.DisplayImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.LocalDisplay;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.VisADException;
import visad.java3d.DisplayImplJ3D;

public class TestStereo
extends TestSkeleton {
    public TestStereo() {
    }

    public TestStereo(String[] args) throws RemoteException, VisADException {
        super(args);
    }

    DisplayImpl[] setupServerDisplays() throws RemoteException, VisADException {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfigTemplate3D gct3d = new GraphicsConfigTemplate3D();
        gct3d.setStereo(1);
        GraphicsConfiguration config = gct3d.getBestConfiguration(gd.getConfigurations());
        if (config == null) {
            System.err.println("Unable to find a Stereo visual");
            System.exit(1);
        }
        DisplayImpl[] dpys = new DisplayImpl[]{new DisplayImplJ3D("display1", 3, config)};
        return dpys;
    }

    void setupServerData(LocalDisplay[] dpys) throws RemoteException, VisADException {
        RealType vis_radiance = RealType.getRealType("vis_radiance");
        RealType ir_radiance = RealType.getRealType("ir_radiance");
        RealType count = RealType.getRealType("count");
        RealType[] scatter_list = new RealType[]{vis_radiance, ir_radiance, count, RealType.Latitude, RealType.Longitude, RealType.Radius};
        RealTupleType scatter = new RealTupleType(scatter_list);
        RealType[] time = new RealType[]{RealType.Time};
        RealTupleType time_type = new RealTupleType(time);
        FunctionType scatter_function = new FunctionType(time_type, scatter);
        int size = 64;
        FlatField imaget1 = FlatField.makeField(scatter_function, size, false);
        dpys[0].addMap(new ScalarMap(RealType.Latitude, Display.YAxis));
        dpys[0].addMap(new ScalarMap(RealType.Longitude, Display.Green));
        dpys[0].addMap(new ScalarMap(vis_radiance, Display.ZAxis));
        dpys[0].addMap(new ScalarMap(ir_radiance, Display.XAxis));
        dpys[0].addMap(new ConstantMap(0.5, Display.Blue));
        dpys[0].addMap(new ConstantMap(0.5, Display.Red));
        dpys[0].addMap(new ScalarMap(vis_radiance, Display.Alpha));
        GraphicsModeControl mode = dpys[0].getGraphicsModeControl();
        mode.setPointSize(5.0f);
        DataReferenceImpl ref_imaget1 = new DataReferenceImpl("ref_imaget1");
        ref_imaget1.setData(imaget1);
        dpys[0].addReference(ref_imaget1, null);
    }

    public String toString() {
        return ": stereo scatter diagram";
    }

    public static void main(String[] args) throws RemoteException, VisADException {
        new TestStereo(args);
    }
}

