/*
 * Decompiled with CFR 0.152.
 */
import java.rmi.RemoteException;
import visad.ActivityHandler;
import visad.DataReferenceImpl;
import visad.Display;
import visad.DisplayImpl;
import visad.DisplayRealType;
import visad.FlatField;
import visad.FunctionType;
import visad.LocalDisplay;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.VisADException;
import visad.data.DefaultFamily;
import visad.java3d.DisplayImplJ3D;

public class Test71
extends UISkeleton {
    private String file1;
    private String file2;

    public Test71() {
    }

    public Test71(String[] args) throws RemoteException, VisADException {
        super(args);
    }

    public void initializeArgs() {
        this.file2 = null;
        this.file1 = null;
    }

    public int checkKeyword(String testName, int argc, String[] args) {
        if (this.file1 == null) {
            this.file1 = args[argc];
        } else if (this.file2 == null) {
            this.file2 = args[argc];
        } else {
            System.err.println(testName + ": Ignoring extra filename \"" + args[argc] + "\"");
        }
        return 1;
    }

    public String keywordUsage() {
        return super.keywordUsage() + " file1 file2";
    }

    public boolean finalizeArgs(String progName) {
        if (this.file1 == null) {
            System.err.println(progName + ": Please specify two files");
            return false;
        }
        if (this.file2 == null) {
            System.err.println(progName + ": Please specify both files");
            return false;
        }
        return true;
    }

    private DataReferenceImpl loadFile(DefaultFamily df, String fileName, String refName) throws RemoteException, VisADException {
        if (fileName == null) {
            return null;
        }
        FlatField data = (FlatField)df.open(fileName);
        DataReferenceImpl ref = new DataReferenceImpl(refName);
        ref.setData(data);
        return ref;
    }

    DisplayImpl[] setupServerDisplays() throws RemoteException, VisADException {
        DisplayImpl[] dpys = new DisplayImpl[]{new DisplayImplJ3D("display")};
        return dpys;
    }

    void setupServerData(LocalDisplay[] dpys) throws RemoteException, VisADException {
        DefaultFamily df = new DefaultFamily("loader");
        DataReferenceImpl ref1 = this.loadFile(df, this.file1, "img1");
        if (ref1 == null) {
            System.err.println("\"" + this.file1 + "\" is not a valid file");
            System.exit(1);
            return;
        }
        DataReferenceImpl ref2 = this.loadFile(df, this.file2, "img2");
        if (ref2 == null) {
            System.err.println("\"" + this.file2 + "\" is not a valid file");
            System.exit(1);
            return;
        }
        FlatField img1 = (FlatField)ref1.getData();
        FlatField img2 = (FlatField)ref2.getData();
        FunctionType ftype = (FunctionType)img1.getType();
        RealTupleType dtype = ftype.getDomain();
        RealTupleType rtype = (RealTupleType)ftype.getRange();
        int dLen = dtype.getDimension();
        int i = 0;
        while (i < dLen) {
            DisplayRealType dpyRT;
            switch (i) {
                case 0: {
                    dpyRT = Display.XAxis;
                    break;
                }
                case 1: {
                    dpyRT = Display.YAxis;
                    break;
                }
                case 2: {
                    dpyRT = Display.ZAxis;
                    break;
                }
                default: {
                    dpyRT = null;
                }
            }
            if (dpyRT != null) {
                dpys[0].addMap(new ScalarMap((RealType)dtype.getComponent(i), dpyRT));
            }
            ++i;
        }
        int rLen = rtype.getDimension();
        int i2 = 0;
        while (i2 < rLen) {
            DisplayRealType dpyRT;
            switch (i2) {
                case 0: {
                    dpyRT = Display.Red;
                    break;
                }
                case 1: {
                    dpyRT = Display.Green;
                    break;
                }
                case 2: {
                    dpyRT = Display.Blue;
                    break;
                }
                default: {
                    dpyRT = null;
                }
            }
            if (dpyRT != null) {
                dpys[0].addMap(new ScalarMap((RealType)rtype.getComponent(i2), dpyRT));
            }
            ++i2;
        }
        dpys[0].addReference(ref1, null);
        dpys[0].addReference(ref2, null);
        dpys[0].addActivityHandler((ActivityHandler)new SwitchGIFs(this, dpys[0]));
    }

    String getFrameTitle() {
        return "Idle/Busy test";
    }

    public String toString() {
        return " gif_file gif_file: Idle/Busy test";
    }

    public static void main(String[] args) throws RemoteException, VisADException {
        new Test71(args);
    }
}

