/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Container;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.rmi.RemoteException;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.ConstantMap;
import visad.DataReferenceImpl;
import visad.Display;
import visad.DisplayImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.LocalDisplay;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.SocketSlaveDisplay;
import visad.VisADException;
import visad.java2d.DisplayImplJ2D;
import visad.java3d.DisplayImplJ3D;

public class Test68
extends UISkeleton {
    private boolean twoD;
    private int port;
    GraphicsModeControl gmc;

    boolean hasClientServerMode() {
        return false;
    }

    public Test68() {
    }

    public Test68(String[] args) throws RemoteException, VisADException {
        super(args);
    }

    public void initializeArgs() {
        this.twoD = false;
        this.port = 0;
    }

    public int checkOption(String progName, char ch, String arg) {
        if (ch == '2') {
            this.twoD = true;
            return 1;
        }
        return 0;
    }

    public int checkKeyword(String testName, int argc, String[] args) {
        String arg = args[argc];
        int d = 0;
        try {
            d = Integer.parseInt(arg);
        }
        catch (NumberFormatException exc) {
            // empty catch block
        }
        if (d < 1 || d > 9999) {
            System.err.println(testName + ": Bad parameter \"" + arg + "\": port must be between 1 and 9999");
            return -1;
        }
        this.port = d;
        return 1;
    }

    DisplayImpl[] setupServerDisplays() throws RemoteException, VisADException {
        DisplayImpl[] dpys = new DisplayImpl[]{this.twoD ? new DisplayImplJ2D("display") : new DisplayImplJ3D("display")};
        return dpys;
    }

    void setupServerData(LocalDisplay[] dpys) throws RemoteException, VisADException {
        RealType ir_radiance = RealType.getRealType("ir_radiance");
        int size = 64;
        DisplayImpl display1 = (DisplayImpl)dpys[0];
        if (this.twoD) {
            RealType count = RealType.getRealType("count");
            FunctionType ir_histogram = new FunctionType(ir_radiance, count);
            FlatField histogram1 = FlatField.makeField(ir_histogram, size, false);
            System.out.print("Creating Java2D display...");
            display1.addMap(new ScalarMap(count, Display.YAxis));
            display1.addMap(new ScalarMap(ir_radiance, Display.XAxis));
            display1.addMap(new ConstantMap(0.0, Display.Red));
            display1.addMap(new ConstantMap(1.0, Display.Green));
            display1.addMap(new ConstantMap(0.0, Display.Blue));
            this.gmc = display1.getGraphicsModeControl();
            DataReferenceImpl ref_histogram1 = new DataReferenceImpl("ref_histogram1");
            ref_histogram1.setData(histogram1);
            display1.addReference(ref_histogram1, null);
        } else {
            RealType vis_radiance = RealType.getRealType("vis_radiance");
            RealType[] types = new RealType[]{RealType.Latitude, RealType.Longitude};
            RealType[] types2 = new RealType[]{vis_radiance, ir_radiance};
            RealTupleType earth_location = new RealTupleType(types);
            RealTupleType radiance = new RealTupleType(types2);
            FunctionType image_tuple = new FunctionType(earth_location, radiance);
            FlatField imaget1 = FlatField.makeField(image_tuple, size, false);
            System.out.print("Creating Java3D display...");
            display1.addMap(new ScalarMap(RealType.Latitude, Display.YAxis));
            display1.addMap(new ScalarMap(RealType.Longitude, Display.XAxis));
            display1.addMap(new ScalarMap(vis_radiance, Display.ZAxis));
            display1.addMap(new ScalarMap(vis_radiance, Display.Green));
            display1.addMap(new ScalarMap(vis_radiance, Display.IsoContour));
            display1.addMap(new ConstantMap(0.5, Display.Blue));
            display1.addMap(new ConstantMap(0.5, Display.Red));
            this.gmc = display1.getGraphicsModeControl();
            this.gmc.setPointSize(2.0f);
            this.gmc.setPointMode(false);
            this.gmc.setMissingTransparent(true);
            DataReferenceImpl ref_imaget1 = new DataReferenceImpl("ref_imaget1");
            ref_imaget1.setData(imaget1);
            display1.addReference(ref_imaget1, null);
        }
        SocketSlaveDisplay serv = null;
        try {
            serv = this.port > 0 ? new SocketSlaveDisplay(display1, this.port) : new SocketSlaveDisplay(display1);
        }
        catch (IOException exc) {
            System.err.println("Unable to create the SocketSlaveDisplay:");
            exc.printStackTrace();
        }
        if (serv != null) {
            System.out.println("SocketSlaveDisplay created.\nTo connect a client from within a web browser,\nuse the VisADApplet applet found in visad/browser.\nNote that an applet cannot communicate with a server\nvia the network unless both applet and server\noriginate from the same machine.  In the future,\nVisAD's SocketSlaveDisplay will support communication\nthrough a proxy server.");
        }
        JFrame widgetFrame = new JFrame("Controls");
        widgetFrame.addWindowListener((WindowListener)new /* Unavailable Anonymous Inner Class!! */);
        JPanel pane = new JPanel();
        Container widgets = display1.getWidgetPanel();
        widgetFrame.setContentPane(widgets);
        widgetFrame.pack();
        widgetFrame.show();
    }

    String getFrameTitle() {
        return "SocketSlaveDisplay server";
    }

    public String toString() {
        return " [-2d] port: SocketSlaveDisplay";
    }

    public static void main(String[] args) throws RemoteException, VisADException {
        new Test68(args);
    }
}

