/*
 * Decompiled with CFR 0.152.
 */
import java.rmi.RemoteException;
import visad.ConstantMap;
import visad.DataReferenceImpl;
import visad.Display;
import visad.DisplayImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded1DDoubleSet;
import visad.Gridded1DSet;
import visad.Gridded2DDoubleSet;
import visad.Gridded2DSet;
import visad.Gridded3DDoubleSet;
import visad.Gridded3DSet;
import visad.GriddedSet;
import visad.LocalDisplay;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.VisADException;
import visad.java3d.DisplayImplJ3D;

public class Test67
extends UISkeleton {
    private int dim;

    public Test67() {
    }

    public Test67(String[] args) throws RemoteException, VisADException {
        super(args);
    }

    public void initializeArgs() {
        this.dim = 1;
    }

    public int checkKeyword(String testName, int argc, String[] args) {
        int d = 0;
        try {
            d = Integer.parseInt(args[argc]);
        }
        catch (NumberFormatException exc) {
            // empty catch block
        }
        if (d < 1 || d > 3) {
            System.err.println(testName + ": Bad parameter \"" + args[argc] + "\": dimension must be 1, 2 or 3");
            return -1;
        }
        this.dim = d;
        return 1;
    }

    DisplayImpl[] setupServerDisplays() throws RemoteException, VisADException {
        DisplayImpl[] dpys = new DisplayImpl[]{new DisplayImplJ3D("double"), new DisplayImplJ3D("float")};
        return dpys;
    }

    void setupServerData(LocalDisplay[] dpys) throws RemoteException, VisADException {
        GriddedSet f_set;
        GriddedSet set;
        FunctionType function;
        DataReferenceImpl ref = new DataReferenceImpl("ref");
        DataReferenceImpl f_ref = new DataReferenceImpl("ref");
        RealType x = RealType.getRealType("x");
        RealType y = RealType.getRealType("y");
        RealType z = RealType.getRealType("z");
        RealType v = RealType.getRealType("v");
        int size = 20;
        int nrs = (int)Math.pow(size, this.dim);
        double eps = 1.0 / (double)size;
        double[][] samples = new double[this.dim][nrs];
        float[][] f_samples = new float[this.dim][nrs];
        int j = 0;
        while (j < this.dim) {
            int i = 0;
            while (i < nrs) {
                int element = i;
                int k = 0;
                while (k < j) {
                    element /= size;
                    ++k;
                }
                double frac = (double)(element %= size) / (double)size;
                samples[j][i] = frac * 2.0 * Math.PI + eps * (Math.random() - 0.5);
                f_samples[j][i] = (float)samples[j][i];
                ++i;
            }
            ++j;
        }
        double[][] values = new double[1][nrs];
        float[][] f_values = new float[1][nrs];
        int i = 0;
        while (i < nrs) {
            double sum = 0.0;
            int j2 = 0;
            while (j2 < this.dim) {
                sum += samples[j2][i];
                ++j2;
            }
            values[0][i] = Math.sin(sum);
            f_values[0][i] = (float)values[0][i];
            ++i;
        }
        if (this.dim == 1) {
            function = new FunctionType(x, y);
            set = new Gridded1DDoubleSet((MathType)x, samples, size);
            f_set = new Gridded1DSet((MathType)x, f_samples, size);
        } else if (this.dim == 2) {
            RealTupleType xy = new RealTupleType(x, y);
            function = new FunctionType(xy, z);
            set = new Gridded2DDoubleSet((MathType)xy, samples, size, size);
            f_set = new Gridded2DSet((MathType)xy, f_samples, size, size);
        } else {
            RealTupleType xyz = new RealTupleType(x, y, z);
            function = new FunctionType(xyz, v);
            set = new Gridded3DDoubleSet((MathType)xyz, samples, size, size, size);
            f_set = new Gridded3DSet((MathType)xyz, f_samples, size, size, size);
        }
        FlatField field = new FlatField(function, set);
        field.setSamples(values);
        ref.setData(field);
        FlatField f_field = new FlatField(function, f_set);
        f_field.setSamples(f_values);
        f_ref.setData(f_field);
        int i2 = 0;
        while (i2 < 2) {
            dpys[i2].addMap(new ScalarMap(x, Display.XAxis));
            dpys[i2].addMap(new ScalarMap(y, Display.YAxis));
            if (this.dim > 1) {
                dpys[i2].addMap(new ScalarMap(z, Display.ZAxis));
            }
            if (this.dim > 2) {
                dpys[i2].addMap(new ScalarMap(v, Display.RGB));
            }
            ++i2;
        }
        if (this.dim < 3) {
            dpys[0].addMap(new ConstantMap(0.0, Display.Red));
            dpys[0].addMap(new ConstantMap(0.0, Display.Green));
            dpys[0].addMap(new ConstantMap(1.0, Display.Blue));
            dpys[1].addMap(new ConstantMap(1.0, Display.Red));
            dpys[1].addMap(new ConstantMap(0.0, Display.Green));
            dpys[1].addMap(new ConstantMap(0.0, Display.Blue));
        } else {
            dpys[0].getGraphicsModeControl().setPointSize(2.0f);
            dpys[1].getGraphicsModeControl().setPointSize(2.0f);
        }
        dpys[0].addReference(ref);
        dpys[1].addReference(f_ref);
    }

    String getFrameTitle() {
        return "Gridded" + this.dim + "DDoubleSet";
    }

    public String toString() {
        return " dim: GriddedDoubleSets";
    }

    public static void main(String[] args) throws RemoteException, VisADException {
        new Test67(args);
    }
}

