/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.event.WindowListener;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import visad.ConstantMap;
import visad.DataReferenceImpl;
import visad.Display;
import visad.DisplayImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.LocalDisplay;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.VisADException;
import visad.java3d.DisplayImplJ3D;
import visad.util.ContourWidget;
import visad.util.GMCWidget;
import visad.util.LabeledColorWidget;
import visad.util.ProjWidget;
import visad.util.RangeWidget;
import visad.util.SelectRangeWidget;

public class Test66
extends TestSkeleton {
    public Test66() {
    }

    public Test66(String[] args) throws RemoteException, VisADException {
        super(args);
    }

    DisplayImpl[] setupServerDisplays() throws RemoteException, VisADException {
        DisplayImpl[] dpys = new DisplayImpl[]{new DisplayImplJ3D("D0"), new DisplayImplJ3D("D1")};
        return dpys;
    }

    private void setupDisplayZero(LocalDisplay dpy, RealType visRadiance, RealType irRadiance) throws RemoteException, VisADException {
        dpy.addMap(new ScalarMap(RealType.Longitude, Display.XAxis));
        dpy.addMap(new ScalarMap(RealType.Latitude, Display.YAxis));
        ScalarMap vz = new ScalarMap(visRadiance, Display.ZAxis);
        dpy.addMap(vz);
        vz.setUnderscoreToBlank(true);
        dpy.addMap(new ConstantMap(0.5, Display.Red));
        dpy.addMap(new ScalarMap(visRadiance, Display.Green));
        dpy.addMap(new ConstantMap(0.5, Display.Blue));
        ScalarMap isr = new ScalarMap(irRadiance, Display.SelectRange);
        dpy.addMap(isr);
        isr.setUnderscoreToBlank(true);
        ScalarMap irgb = new ScalarMap(irRadiance, Display.RGBA);
        dpy.addMap(irgb);
        irgb.setUnderscoreToBlank(true);
        dpy.getGraphicsModeControl().setScaleEnable(true);
    }

    private void setupDisplayOne(LocalDisplay dpy, RealType visRadiance, RealType irRadiance) throws RemoteException, VisADException {
        dpy.addMap(new ScalarMap(RealType.Longitude, Display.XAxis));
        dpy.addMap(new ScalarMap(RealType.Latitude, Display.YAxis));
        dpy.addMap(new ConstantMap(0.5, Display.Red));
        dpy.addMap(new ScalarMap(irRadiance, Display.Green));
        dpy.addMap(new ConstantMap(0.5, Display.Blue));
        ScalarMap vic = new ScalarMap(visRadiance, Display.IsoContour);
        dpy.addMap(vic);
        vic.setUnderscoreToBlank(true);
        ScalarMap irgb = new ScalarMap(irRadiance, Display.RGB);
        dpy.addMap(irgb);
        irgb.setUnderscoreToBlank(true);
        dpy.getGraphicsModeControl().setScaleEnable(true);
    }

    private void addData(LocalDisplay[] dpys, RealType visRadiance, RealType irRadiance) throws RemoteException, VisADException {
        RealType[] llTypes = new RealType[]{RealType.Latitude, RealType.Longitude};
        RealTupleType earthLoc = new RealTupleType(llTypes);
        RealType[] radTypes = new RealType[]{visRadiance, irRadiance};
        RealTupleType radTuple = new RealTupleType(radTypes);
        FunctionType imageFunc = new FunctionType(earthLoc, radTuple);
        FlatField data = FlatField.makeField(imageFunc, 64, false);
        DataReferenceImpl dataRef = new DataReferenceImpl("data");
        dataRef.setData(data);
        int i = 0;
        while (i < dpys.length) {
            dpys[i].addReference(dataRef);
            ++i;
        }
    }

    void setupServerData(LocalDisplay[] dpys) throws RemoteException, VisADException {
        RealType visRadiance = RealType.getRealType("vis_radiance");
        RealType irRadiance = RealType.getRealType("ir_radiance");
        this.setupDisplayZero(dpys[0], visRadiance, irRadiance);
        this.setupDisplayOne(dpys[1], visRadiance, irRadiance);
        this.addData(dpys, visRadiance, irRadiance);
    }

    private void addWidget(Container cont, Component comp) {
        cont.add(new JLabel(comp.getClass().getName()));
        cont.add(comp);
    }

    private Component displayZeroUI(LocalDisplay dpy) throws RemoteException, VisADException {
        Vector v = dpy.getMapVector();
        int vSize = v.size();
        ScalarMap rgbaMap = (ScalarMap)v.elementAt(vSize - 1);
        ScalarMap selectMap = (ScalarMap)v.elementAt(vSize - 2);
        JPanel widgets = new JPanel();
        widgets.setLayout(new BoxLayout(widgets, 1));
        this.addWidget((Container)widgets, (Component)new LabeledColorWidget(rgbaMap));
        this.addWidget((Container)widgets, (Component)new SelectRangeWidget(selectMap));
        this.addWidget((Container)widgets, (Component)new GMCWidget(dpy.getGraphicsModeControl()));
        this.addWidget((Container)widgets, (Component)new ProjWidget(dpy.getProjectionControl()));
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(widgets);
        panel.add(dpy.getComponent());
        return panel;
    }

    private Component displayOneUI(LocalDisplay dpy) throws RemoteException, VisADException {
        Vector v = dpy.getMapVector();
        int vSize = v.size();
        ScalarMap rgbMap = (ScalarMap)v.elementAt(vSize - 1);
        ScalarMap contourMap = (ScalarMap)v.elementAt(vSize - 2);
        JPanel widgets = new JPanel();
        widgets.setLayout(new BoxLayout(widgets, 1));
        this.addWidget((Container)widgets, (Component)new RangeWidget(rgbMap));
        this.addWidget((Container)widgets, (Component)new LabeledColorWidget(rgbMap));
        this.addWidget((Container)widgets, (Component)new ContourWidget(contourMap));
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(widgets);
        panel.add(dpy.getComponent());
        return panel;
    }

    private Container buildContent(LocalDisplay[] dpys) throws RemoteException, VisADException {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(this.displayZeroUI(dpys[0]));
        panel.add(this.displayOneUI(dpys[1]));
        return panel;
    }

    String getFrameTitle() {
        return "Test all widgets";
    }

    void setupUI(LocalDisplay[] dpys) throws RemoteException, VisADException {
        JFrame jframe = new JFrame(this.getFrameTitle() + this.getClientServerTitle());
        jframe.addWindowListener((WindowListener)new /* Unavailable Anonymous Inner Class!! */);
        jframe.setContentPane(this.buildContent(dpys));
        jframe.pack();
        ((Component)jframe).setVisible(true);
    }

    public String toString() {
        return ": Test all widgets";
    }

    public static void main(String[] args) throws RemoteException, VisADException {
        new Test66(args);
    }
}

