/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.event.WindowListener;
import java.rmi.RemoteException;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.ConstantMap;
import visad.DataReferenceImpl;
import visad.Display;
import visad.DisplayEvent;
import visad.DisplayImpl;
import visad.DisplayListener;
import visad.FlatField;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.LocalDisplay;
import visad.ProjectionControl;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.VisADException;
import visad.java3d.DisplayImplJ3D;

public class Test57
extends UISkeleton
implements DisplayListener {
    ProjectionControl control;

    public Test57() {
    }

    public Test57(String[] args) throws RemoteException, VisADException {
        super(args);
    }

    DisplayImpl[] setupServerDisplays() throws RemoteException, VisADException {
        DisplayImpl[] dpys = new DisplayImpl[]{new DisplayImplJ3D("display")};
        return dpys;
    }

    void setupServerData(LocalDisplay[] dpys) throws RemoteException, VisADException {
        RealType[] types = new RealType[]{RealType.Latitude, RealType.Longitude};
        RealTupleType earth_location = new RealTupleType(types);
        RealType vis_radiance = RealType.getRealType("vis_radiance");
        RealType ir_radiance = RealType.getRealType("ir_radiance");
        RealType[] types2 = new RealType[]{vis_radiance, ir_radiance};
        RealTupleType radiance = new RealTupleType(types2);
        FunctionType image_tuple = new FunctionType(earth_location, radiance);
        int size = 32;
        FlatField imaget1 = FlatField.makeField(image_tuple, size, false);
        dpys[0].addMap(new ScalarMap(RealType.Latitude, Display.YAxis));
        dpys[0].addMap(new ScalarMap(RealType.Longitude, Display.XAxis));
        dpys[0].addMap(new ScalarMap(vis_radiance, Display.ZAxis));
        dpys[0].addMap(new ScalarMap(ir_radiance, Display.Green));
        dpys[0].addMap(new ConstantMap(0.5, Display.Blue));
        dpys[0].addMap(new ConstantMap(0.5, Display.Red));
        GraphicsModeControl mode = dpys[0].getGraphicsModeControl();
        mode.setScaleEnable(true);
        DataReferenceImpl ref_imaget1 = new DataReferenceImpl("ref_imaget1");
        ref_imaget1.setData(imaget1);
        dpys[0].addReference(ref_imaget1, null);
    }

    String getFrameTitle() {
        return "fly-through in Java3D";
    }

    void setupUI(LocalDisplay[] dpys) throws RemoteException, VisADException {
        JFrame jframe = new JFrame(this.getFrameTitle() + this.getClientServerTitle());
        jframe.addWindowListener((WindowListener)new /* Unavailable Anonymous Inner Class!! */);
        jframe.setContentPane((JPanel)dpys[0].getComponent());
        jframe.pack();
        ((Component)jframe).setVisible(true);
        if (!this.isClient()) {
            this.control = dpys[0].getProjectionControl();
            this.control.setAspectCartesian(new double[]{2.0, 1.0, 0.5});
            this.control.setAspect(new double[]{0.5, 0.5, 0.5});
            dpys[0].addDisplayListener((DisplayListener)this);
            this.rotate(dpys[0]);
        }
    }

    public void displayChanged(DisplayEvent e) throws RemoteException, VisADException {
        if (e.getId() == 3) {
            this.rotate((LocalDisplay)e.getDisplay());
        }
    }

    public void rotate(LocalDisplay display) throws RemoteException, VisADException {
        double[] matrix = this.control.getMatrix();
        double[] mult = display.make_matrix(0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0);
        this.control.setMatrix(display.multiply_matrix(mult, matrix));
    }

    public String toString() {
        return ": scripted fly-through & aspect ratio in Java3D";
    }

    public static void main(String[] args) throws RemoteException, VisADException {
        new Test57(args);
    }
}

