/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowListener;
import java.rmi.RemoteException;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.ContourControl;
import visad.DataReferenceImpl;
import visad.Display;
import visad.DisplayImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.Gridded3DSet;
import visad.LocalDisplay;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.VisADException;
import visad.java3d.DisplayImplJ3D;
import visad.util.ContourWidget;

public class Test37
extends TestSkeleton {
    private boolean reverse;

    public Test37() {
    }

    public Test37(String[] args) throws RemoteException, VisADException {
        super(args);
    }

    public void initializeArgs() {
        this.reverse = false;
    }

    public int checkKeyword(String testName, int argc, String[] args) {
        this.reverse = true;
        return 1;
    }

    DisplayImpl[] setupServerDisplays() throws RemoteException, VisADException {
        DisplayImpl[] dpys = new DisplayImpl[]{new DisplayImplJ3D("display")};
        return dpys;
    }

    void setupServerData(LocalDisplay[] dpys) throws RemoteException, VisADException {
        FlatField imaget1;
        Gridded3DSet d_set;
        RealType[] types = new RealType[]{RealType.Latitude, RealType.Longitude, RealType.Altitude};
        RealTupleType earth_location = new RealTupleType(types);
        RealType vis_radiance = RealType.getRealType("vis_radiance", null, null);
        RealType ir_radiance = RealType.getRealType("ir_radiance", null, null);
        RealType[] types2 = new RealType[]{vis_radiance, ir_radiance};
        RealTupleType radiance = new RealTupleType(types2);
        FunctionType image_tuple = new FunctionType(earth_location, radiance);
        RealType[] typesxx = new RealType[]{RealType.Longitude, RealType.Latitude, RealType.Altitude};
        RealTupleType earth_locationxx = new RealTupleType(typesxx);
        FunctionType image_tuplexx = new FunctionType(earth_locationxx, radiance);
        int size = 64;
        double first = 0.0;
        double last = (double)size - 1.0;
        double step = 1.0;
        double half = 0.5 * last;
        int nr = size;
        int nc = size;
        double ang = Math.PI * 2 / (double)nr;
        float[][] locs = new float[3][nr * nc];
        int jj = 0;
        while (jj < nc) {
            int ii = 0;
            while (ii < nr) {
                int idx = jj * nr + ii;
                locs[0][idx] = ii;
                locs[1][idx] = jj;
                locs[2][idx] = 2.0f * (float)Math.sin(2.0 * ang * (double)ii) + 2.0f * (float)Math.sin(2.0 * ang * (double)jj);
                ++ii;
            }
            ++jj;
        }
        if (!this.reverse) {
            d_set = new Gridded3DSet((MathType)earth_location, locs, nr, nc);
            imaget1 = new FlatField(image_tuple, d_set);
            FlatField.fillField(imaget1, step, half);
        } else {
            d_set = new Gridded3DSet((MathType)earth_locationxx, locs, nr, nc);
            imaget1 = new FlatField(image_tuplexx, d_set);
            FlatField.fillField(imaget1, step, half);
        }
        dpys[0].addMap(new ScalarMap(RealType.Longitude, Display.XAxis));
        dpys[0].addMap(new ScalarMap(RealType.Latitude, Display.YAxis));
        ScalarMap zmap = new ScalarMap(RealType.Altitude, Display.ZAxis);
        dpys[0].addMap(zmap);
        dpys[0].addMap(new ScalarMap(vis_radiance, Display.RGB));
        zmap.setRange(-20.0, 20.0);
        ScalarMap map1contour = new ScalarMap(vis_radiance, Display.IsoContour);
        dpys[0].addMap(map1contour);
        ContourControl ctr_cntrl = (ContourControl)map1contour.getControl();
        GraphicsModeControl mode = dpys[0].getGraphicsModeControl();
        mode.setScaleEnable(true);
        DataReferenceImpl ref_imaget1 = new DataReferenceImpl("ref_imaget1");
        ref_imaget1.setData(imaget1);
        dpys[0].addReference(ref_imaget1, null);
    }

    private String getFrameTitle0() {
        return "regular contours in Java2D";
    }

    private String getFrameTitle1() {
        return "VisAD contour controls";
    }

    void setupUI(LocalDisplay[] dpys) throws RemoteException, VisADException {
        JFrame jframe = new JFrame(this.getFrameTitle0() + this.getClientServerTitle());
        jframe.addWindowListener((WindowListener)new /* Unavailable Anonymous Inner Class!! */);
        jframe.setContentPane((JPanel)dpys[0].getComponent());
        jframe.pack();
        ((Component)jframe).setVisible(true);
        ScalarMap map1contour = (ScalarMap)dpys[0].getMapVector().lastElement();
        ContourWidget cw = new ContourWidget(map1contour);
        JPanel big_panel = new JPanel();
        big_panel.setLayout(new BorderLayout());
        big_panel.add("Center", cw);
        JFrame jframe2 = new JFrame(this.getFrameTitle1());
        jframe2.addWindowListener((WindowListener)new /* Unavailable Anonymous Inner Class!! */);
        jframe2.setContentPane(big_panel);
        jframe2.pack();
        ((Component)jframe2).setVisible(true);
    }

    public String toString() {
        return " swap: colored contours from regular grids and ContourWidget in Java2D";
    }

    public static void main(String[] args) throws RemoteException, VisADException {
        new Test37(args);
    }
}

