/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.rmi.RemoteException;
import visad.CommonUnit;
import visad.ConstantMap;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.Display;
import visad.DisplayImpl;
import visad.FieldImpl;
import visad.FunctionType;
import visad.LocalDisplay;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.Unit;
import visad.VisADException;
import visad.data.netcdf.Plain;
import visad.java3d.DisplayImplJ3D;

public class Test10
extends TestSkeleton {
    private String fileName;

    public Test10() {
    }

    public Test10(String[] args) throws RemoteException, VisADException {
        super(args);
    }

    public void initializeArgs() {
        this.fileName = null;
    }

    public int checkKeyword(String testName, int argc, String[] args) {
        if (this.fileName == null) {
            this.fileName = args[argc];
        } else {
            System.err.println(testName + ": Ignoring extra filename \"" + args[argc] + "\"");
        }
        return 1;
    }

    public String keywordUsage() {
        return super.keywordUsage() + " file";
    }

    public boolean finalizeArgs(String mainName) {
        if (this.fileName == null) {
            System.err.println(mainName + ": No filename specified!");
            return false;
        }
        return true;
    }

    private DataReferenceImpl loadFile() throws RemoteException, VisADException {
        FieldImpl data;
        try {
            data = (FieldImpl)new Plain().open(this.fileName);
        }
        catch (IOException e) {
            System.err.println("Couldn't open \"" + this.fileName + "\": " + e.getMessage());
            System.exit(1);
            return null;
        }
        DataReferenceImpl ref = new DataReferenceImpl("netcdf");
        ref.setData(data);
        return ref;
    }

    DataReference[] getClientDataReferences() throws RemoteException, VisADException {
        DataReferenceImpl ref = this.loadFile();
        if (ref == null) {
            return null;
        }
        return new DataReference[]{ref};
    }

    DisplayImpl[] setupServerDisplays() throws RemoteException, VisADException {
        DisplayImpl[] dpys = new DisplayImpl[]{new DisplayImplJ3D("display", 3)};
        return dpys;
    }

    void setupServerData(LocalDisplay[] dpys) throws RemoteException, VisADException {
        Unit super_degree = CommonUnit.degree.scale(2.5);
        RealType lon = RealType.getRealType("lon", super_degree);
        DataReferenceImpl ref = this.loadFile();
        if (ref == null) {
            System.err.println("must specify netCDF file name");
            System.exit(1);
            return;
        }
        FieldImpl netcdf_data = (FieldImpl)ref.getData();
        FunctionType ftype = (FunctionType)netcdf_data.getType();
        RealTupleType dtype = ftype.getDomain();
        MathType rntype = ftype.getRange();
        int n = dtype.getDimension();
        dpys[0].addMap(new ScalarMap((RealType)dtype.getComponent(0), Display.XAxis));
        if (n > 1) {
            dpys[0].addMap(new ScalarMap((RealType)dtype.getComponent(1), Display.YAxis));
        }
        if (n > 2) {
            dpys[0].addMap(new ScalarMap((RealType)dtype.getComponent(2), Display.ZAxis));
        }
        if (rntype instanceof RealType) {
            dpys[0].addMap(new ScalarMap((RealType)rntype, Display.Green));
            if (n <= 2) {
                dpys[0].addMap(new ScalarMap((RealType)rntype, Display.ZAxis));
            }
        } else if (rntype instanceof RealTupleType) {
            int m = ((RealTupleType)rntype).getDimension();
            RealType rr = (RealType)((RealTupleType)rntype).getComponent(0);
            dpys[0].addMap(new ScalarMap(rr, Display.Green));
            if (n <= 2) {
                if (m > 1) {
                    rr = (RealType)((RealTupleType)rntype).getComponent(1);
                }
                dpys[0].addMap(new ScalarMap(rr, Display.ZAxis));
            }
        }
        dpys[0].addMap(new ConstantMap(0.5, Display.Red));
        dpys[0].addMap(new ConstantMap(0.0, Display.Blue));
        dpys[0].addReference(ref, null);
        System.out.println("now saving data as 'save.nc' and re-reading");
        Plain plain = new Plain();
        try {
            plain.save("save.nc", netcdf_data, true);
            netcdf_data = (FieldImpl)plain.open("save.nc");
        }
        catch (IOException e) {
            System.err.println("Couldn't open \"save.nc\": " + e.getMessage());
            System.exit(1);
            return;
        }
    }

    public String toString() {
        return " file_name: netCDF adapter";
    }

    public static void main(String[] args) throws RemoteException, VisADException {
        new Test10(args);
    }
}

