/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.event.WindowListener;
import java.rmi.RemoteException;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.ConstantMap;
import visad.DataReferenceImpl;
import visad.Display;
import visad.FlatField;
import visad.FlowControl;
import visad.FunctionType;
import visad.Gridded2DSet;
import visad.Integer2DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.ScalarMap;
import visad.Stream2D;
import visad.UnionSet;
import visad.VisADException;
import visad.java3d.DisplayImplJ3D;

public class Stream2DTest {
    public static void main(String[] args) throws VisADException, RemoteException {
        int nr = 50;
        int nc = 50;
        DisplayImplJ3D dpy = new DisplayImplJ3D("display");
        RealType u_wind = RealType.getRealType("u_wind");
        RealType v_wind = RealType.getRealType("v_wind");
        RealTupleType uv = new RealTupleType(u_wind, v_wind);
        FunctionType f_type = new FunctionType(RealTupleType.SpatialCartesian2DTuple, uv);
        Integer2DSet d_set = new Integer2DSet((MathType)RealTupleType.SpatialCartesian2DTuple, nr, nc);
        FlatField uv_field = new FlatField(f_type, d_set);
        float[][] uv_values = new float[2][nr * nc];
        double ang = Math.PI * 2 / (double)nr;
        int jj = 0;
        while (jj < nc) {
            int ii = 0;
            while (ii < nr) {
                int idx = jj * nr + ii;
                uv_values[0][idx] = 5.0f + -20.0f * (float)Math.cos(0.5 * ang * (double)ii);
                uv_values[1][idx] = -10.0f * (float)Math.cos(0.5 * ang * (double)ii);
                ++ii;
            }
            ++jj;
        }
        uv_field.setSamples(uv_values, false);
        int[] numl = new int[1];
        int maxv = 1000;
        int max_lines = 100;
        int[][] n_verts = new int[1][];
        float[][][] vr = new float[1][max_lines][maxv];
        float[][][] vc = new float[1][max_lines][maxv];
        Stream2D.stream(uv_values[0], uv_values[1], nr, nc, 1.0f, 1.0f, 1.0f, vr, vc, n_verts, numl, null);
        ScalarMap xmap = new ScalarMap(RealType.XAxis, Display.XAxis);
        ScalarMap ymap = new ScalarMap(RealType.YAxis, Display.YAxis);
        dpy.addMap(xmap);
        dpy.addMap(ymap);
        ScalarMap flowx = new ScalarMap(u_wind, Display.Flow1X);
        ScalarMap flowy = new ScalarMap(v_wind, Display.Flow1Y);
        dpy.addMap(flowx);
        dpy.addMap(flowy);
        FlowControl flow_cntrl = (FlowControl)flowx.getControl();
        flow_cntrl.setFlowScale(0.04f);
        flow_cntrl = (FlowControl)flowy.getControl();
        flow_cntrl.setFlowScale(0.04f);
        DataReferenceImpl ref = new DataReferenceImpl("wind");
        ref.setData(uv_field);
        dpy.addReference(ref);
        SampledSet[] gsets = new Gridded2DSet[numl[0]];
        int s_idx = 0;
        while (s_idx < numl[0]) {
            float[][] strm_values = new float[2][n_verts[0][s_idx]];
            System.arraycopy(vc[0][s_idx], 0, strm_values[0], 0, n_verts[0][s_idx]);
            System.arraycopy(vr[0][s_idx], 0, strm_values[1], 0, n_verts[0][s_idx]);
            gsets[s_idx] = new Gridded2DSet((MathType)RealTupleType.SpatialCartesian2DTuple, strm_values, n_verts[0][s_idx]);
            ++s_idx;
        }
        UnionSet uset = new UnionSet(gsets);
        DataReferenceImpl strm_ref = new DataReferenceImpl("stream");
        strm_ref.setData(uset);
        ConstantMap[] strm_cm = new ConstantMap[]{new ConstantMap(0.1, Display.Red), new ConstantMap(0.8, Display.Green), new ConstantMap(0.1, Display.Blue), new ConstantMap(1.5, Display.LineWidth)};
        dpy.addReference(strm_ref, strm_cm);
        JFrame jframe = new JFrame();
        jframe.addWindowListener((WindowListener)new /* Unavailable Anonymous Inner Class!! */);
        jframe.setContentPane((JPanel)dpy.getComponent());
        ((Component)jframe).setVisible(true);
    }
}

