/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.rmi.RemoteException;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import visad.ConstantMap;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.Display;
import visad.FlatField;
import visad.FunctionType;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.UnionSet;
import visad.VisADException;
import visad.bom.ImageRendererJ3D;
import visad.data.mcidas.AreaAdapter;
import visad.data.mcidas.BaseMapAdapter;
import visad.java3d.DisplayImplJ3D;
import visad.util.ColorMapWidget;
import visad.util.LabeledColorWidget;

public class SimpleMcIDAS {
    public static void main(String[] args) throws VisADException, RemoteException, IOException {
        DisplayImplJ3D display = new DisplayImplJ3D("display");
        AreaAdapter areaAdapter = new AreaAdapter(args[0]);
        FlatField image = areaAdapter.getData();
        FunctionType imageFunctionType = (FunctionType)image.getType();
        RealType radianceType = (RealType)((RealTupleType)imageFunctionType.getRange()).getComponent(0);
        display.addMap(new ScalarMap(RealType.Latitude, Display.Latitude));
        display.addMap(new ScalarMap(RealType.Longitude, Display.Longitude));
        ScalarMap rgbMap = new ScalarMap(radianceType, Display.RGB);
        display.addMap(rgbMap);
        BaseMapAdapter baseMapAdapter = new BaseMapAdapter(args[1]);
        UnionSet map = baseMapAdapter.getData();
        DataReferenceImpl maplinesRef = new DataReferenceImpl("MapLines");
        maplinesRef.setData(map);
        ConstantMap[] maplinesConstantMap = new ConstantMap[]{new ConstantMap(1.002, Display.Radius), new ConstantMap(0.0, Display.Blue)};
        display.addReference(maplinesRef, maplinesConstantMap);
        DataReferenceImpl imageRef = new DataReferenceImpl("ImageRef");
        imageRef.setData(image);
        display.addReferences((DataRenderer)new ImageRendererJ3D(), imageRef);
        JFrame frame = new JFrame("Satellite Display");
        frame.addWindowListener((WindowListener)new /* Unavailable Anonymous Inner Class!! */);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(display.getComponent());
        LabeledColorWidget lcw = new LabeledColorWidget(new ColorMapWidget(rgbMap, false));
        JPanel sub_panel = new JPanel();
        sub_panel.setMaximumSize(new Dimension(500, 150));
        sub_panel.setBorder(new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5)));
        sub_panel.add(lcw);
        panel.add(sub_panel);
        frame.getContentPane().add(panel);
        ((Component)frame).setSize(500, 700);
        ((Component)frame).setVisible(true);
    }
}

