/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.WindowListener;
import java.rmi.RemoteException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Hashtable;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.AxisScale;
import visad.DataReferenceImpl;
import visad.Display;
import visad.DisplayImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.Gridded1DSet;
import visad.MathType;
import visad.ProjectionControl;
import visad.RealType;
import visad.SI;
import visad.ScalarMap;
import visad.Tuple;
import visad.Unit;
import visad.VisADException;
import visad.data.units.Parser;
import visad.java2d.DisplayImplJ2D;
import visad.java3d.DisplayImplJ3D;
import visad.util.PrintActionListener;

public class ScaleTest
extends JFrame {
    DisplayImpl display;
    ScalarMap tMap;
    ScalarMap tdMap;
    ScalarMap timeMap;
    RealType temp;
    RealType dewpoint;

    public ScaleTest(boolean do3D) throws VisADException, RemoteException {
        double[] dArray;
        this.addWindowListener((WindowListener)new /* Unavailable Anonymous Inner Class!! */);
        this.display = do3D ? new DisplayImplJ3D("Display") : new DisplayImplJ2D("Display");
        GraphicsModeControl gmc = this.display.getGraphicsModeControl();
        gmc.setScaleEnable(true);
        ProjectionControl pc = this.display.getProjectionControl();
        if (do3D) {
            double[] dArray2 = new double[3];
            dArray2[0] = 0.8;
            dArray2[1] = 1.0;
            dArray = dArray2;
            dArray2[2] = 1.0;
        } else {
            double[] dArray3 = new double[2];
            dArray3[0] = 0.8;
            dArray = dArray3;
            dArray3[1] = 1.0;
        }
        pc.setAspectCartesian(dArray);
        Unit cel = null;
        try {
            cel = Parser.parse("degC");
            this.temp = RealType.getRealType("Temperature", SI.kelvin);
            this.dewpoint = RealType.getRealType("DewPoint", cel);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.tMap = new ScalarMap(this.temp, Display.YAxis);
        this.tMap.setOverrideUnit(cel);
        this.tdMap = new ScalarMap(this.dewpoint, do3D ? Display.ZAxis : Display.YAxis);
        this.timeMap = new ScalarMap(RealType.Time, Display.XAxis);
        Hashtable<Double, String> timeLabels = new Hashtable<Double, String>();
        timeLabels.put(new Double(0.0), "First");
        timeLabels.put(new Double(10.0), "Last");
        this.timeMap.getAxisScale().setLabelTable(timeLabels);
        Hashtable<Double, String> tdLabels = new Hashtable<Double, String>();
        tdLabels.put(new Double(-20.0), "Low");
        tdLabels.put(new Double(5.0), "High");
        this.tdMap.getAxisScale().setLabelTable(tdLabels);
        this.tdMap.getAxisScale().setSide(1);
        this.tdMap.getAxisScale().setMinorTickSpacing(2.5);
        AxisScale tScale = this.tMap.getAxisScale();
        DecimalFormat formatter = (DecimalFormat)NumberFormat.getInstance();
        formatter.applyPattern("0.0E0");
        tScale.setNumberFormat(formatter);
        tScale.createStandardLabels(50.0, 10.0, 50.0, 40.0);
        tScale.setTitle(tScale.getTitle() + " (" + cel + ")");
        this.display.addMap(this.tMap);
        this.display.addMap(this.tdMap);
        this.display.addMap(this.timeMap);
        DataReferenceImpl ref = new DataReferenceImpl("data");
        float[][] timeVals = new float[][]{{0.0f, 2.0f, 4.0f, 6.0f, 8.0f, 10.0f}};
        Gridded1DSet timeSet = new Gridded1DSet((MathType)RealType.Time, (float[][])timeVals, 6);
        float[][] tVals = new float[][]{{294.15f, 326.15f, 310.15f, 278.15f, 278.15f, 293.15f}};
        float[][] tdVals = new float[][]{{1.0f, 3.0f, 7.0f, -15.0f, -22.0f, 4.0f}};
        FunctionType fieldType1 = new FunctionType(RealType.Time, this.temp);
        FlatField field1 = new FlatField(fieldType1, timeSet);
        field1.setSamples(tVals);
        FunctionType fieldType2 = new FunctionType(RealType.Time, this.dewpoint);
        FlatField field2 = new FlatField(fieldType2, timeSet);
        field2.setSamples(tdVals);
        ref.setData(new Tuple(new FlatField[]{field1, field2}));
        this.display.addReference(ref);
        JPanel left = new JPanel();
        left.setLayout(new BoxLayout(left, 1));
        left.add((Component)new ScaleControlPanel(this, this.tMap));
        left.add((Component)new ScaleControlPanel(this, this.tdMap));
        left.add((Component)new ScaleControlPanel(this, this.timeMap));
        JButton print = new JButton("Print Me");
        print.addActionListener(new PrintActionListener(this.display));
        left.add(print);
        Container mainPanel = this.getContentPane();
        mainPanel.setLayout(new GridLayout(1, 2));
        mainPanel.add(left);
        mainPanel.add(this.display.getComponent());
        this.pack();
    }

    public static void main(String[] args) throws Exception {
        ScaleTest frame = new ScaleTest(args.length > 0);
        frame.show();
    }
}

