/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.rmi.RemoteException;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.DataReferenceImpl;
import visad.DelaunayCustom;
import visad.Display;
import visad.Irregular2DSet;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.VisADException;
import visad.java2d.DisplayImplJ2D;

public class Region {
    public static void main(String[] args) throws VisADException, RemoteException, IOException {
        RealTupleType earth = new RealTupleType(RealType.Latitude, RealType.Longitude);
        int np = 14;
        float[][] samples = new float[2][np];
        float radius = 7.0f;
        int i = 0;
        while (i < np) {
            double b = Math.PI * 2 * (double)i / (double)np;
            samples[0][i] = radius * (float)Math.cos(b);
            samples[1][i] = radius * (float)Math.sin(b);
            radius = 10.0f - radius;
            ++i;
        }
        int[][] tris = DelaunayCustom.fill(samples);
        DelaunayCustom delaunay = new DelaunayCustom(samples, tris);
        Irregular2DSet region = new Irregular2DSet(earth, samples, null, null, null, delaunay);
        DataReferenceImpl region_ref = new DataReferenceImpl("region");
        region_ref.setData(region);
        DisplayImplJ2D display = new DisplayImplJ2D("image display");
        display.addMap(new ScalarMap(RealType.Longitude, Display.XAxis));
        display.addMap(new ScalarMap(RealType.Latitude, Display.YAxis));
        display.addReference(region_ref);
        JFrame frame = new JFrame("Region VisAD Application");
        frame.addWindowListener((WindowListener)new /* Unavailable Anonymous Inner Class!! */);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setAlignmentY(0.0f);
        panel.setAlignmentX(0.0f);
        frame.getContentPane().add(panel);
        panel.add(display.getComponent());
        ((Component)frame).setSize(500, 500);
        ((Component)frame).setVisible(true);
    }
}

