/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.rmi.RemoteException;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.ConstantMap;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayEvent;
import visad.DisplayListener;
import visad.FlatField;
import visad.FunctionType;
import visad.LocalDisplay;
import visad.ProjectionControl;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.UnionSet;
import visad.VisADException;
import visad.bom.ImageRendererJ3D;
import visad.data.mcidas.AreaAdapter;
import visad.data.mcidas.BaseMapAdapter;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.ImmersaDeskDisplayRendererJ3D;

public class IDeskMcIDAS
implements DisplayListener {
    public static void main(String[] args) throws VisADException, RemoteException, IOException {
        IDeskMcIDAS iDeskMcIDAS = new IDeskMcIDAS(args);
    }

    public IDeskMcIDAS(String[] args) throws VisADException, RemoteException, IOException {
        int tracker_shmkey = 4148;
        int controller_shmkey = 4147;
        if (args.length >= 3) {
            tracker_shmkey = Integer.parseInt(args[3]);
        }
        if (args.length >= 4) {
            controller_shmkey = Integer.parseInt(args[4]);
        }
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfigTemplate3D gct3d = new GraphicsConfigTemplate3D();
        gct3d.setStereo(1);
        GraphicsConfiguration config = gct3d.getBestConfiguration(gd.getConfigurations());
        if (config == null) {
            System.err.println("Unable to find a Stereo visual");
            System.exit(1);
        }
        ImmersaDeskDisplayRendererJ3D display_renderer = new ImmersaDeskDisplayRendererJ3D(tracker_shmkey, controller_shmkey);
        DisplayImplJ3D display = new DisplayImplJ3D("display1", (DisplayRendererJ3D)display_renderer, config);
        AreaAdapter areaAdapter = new AreaAdapter(args[0]);
        FlatField image = areaAdapter.getData();
        FunctionType imageFunctionType = (FunctionType)image.getType();
        RealType radianceType = (RealType)((RealTupleType)imageFunctionType.getRange()).getComponent(0);
        display.addMap(new ScalarMap(RealType.Latitude, Display.Latitude));
        display.addMap(new ScalarMap(RealType.Longitude, Display.Longitude));
        ScalarMap rgbMap = new ScalarMap(radianceType, Display.RGB);
        display.addMap(rgbMap);
        BaseMapAdapter baseMapAdapter = new BaseMapAdapter(args[1]);
        UnionSet map = baseMapAdapter.getData();
        DataReferenceImpl maplinesRef = new DataReferenceImpl("MapLines");
        maplinesRef.setData(map);
        ConstantMap[] maplinesConstantMap = new ConstantMap[]{new ConstantMap(1.002, Display.Radius), new ConstantMap(0.0, Display.Blue)};
        display.addReference(maplinesRef, maplinesConstantMap);
        DataReferenceImpl imageRef = new DataReferenceImpl("ImageRef");
        imageRef.setData(image);
        display.addReferences((DataRenderer)new ImageRendererJ3D(), imageRef);
        display.addDisplayListener((DisplayListener)this);
        this.rotate_x((LocalDisplay)display);
        JFrame frame = new JFrame("Satellite Display");
        frame.addWindowListener((WindowListener)new /* Unavailable Anonymous Inner Class!! */);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(display.getComponent());
        frame.getContentPane().add(panel);
        int WIDTH = 1280;
        int HEIGHT = 1024;
        ((Component)frame).setSize(WIDTH, HEIGHT);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)frame).setLocation(screenSize.width / 2 - WIDTH / 2, screenSize.height / 2 - HEIGHT / 2);
        ((Component)frame).setVisible(true);
    }

    public void displayChanged(DisplayEvent e) throws RemoteException, VisADException {
        if (e.getId() == 3) {
            this.rotate((LocalDisplay)e.getDisplay());
        }
    }

    public void rotate(LocalDisplay display) throws RemoteException, VisADException {
        ProjectionControl control = display.getProjectionControl();
        double[] matrix = control.getMatrix();
        double[] mult = display.make_matrix(0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0);
        control.setMatrix(display.multiply_matrix(mult, matrix));
    }

    public void rotate_x(LocalDisplay display) throws RemoteException, VisADException {
        ProjectionControl control = display.getProjectionControl();
        double[] matrix = control.getMatrix();
        double[] mult = display.make_matrix(90.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0);
        control.setMatrix(display.multiply_matrix(mult, matrix));
    }
}

