/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.WindowListener;
import java.rmi.RemoteException;
import visad.DataReferenceImpl;
import visad.Display;
import visad.FlatField;
import visad.FunctionType;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.VisADException;
import visad.data.netcdf.Plain;
import visad.util.LabeledColorWidget;

/*
 * Exception performing whole class analysis ignored.
 */
class Earth {
    Earth() {
    }

    private static double[] setAltitudeScaling(ScalarMap radiusMap) throws InterruptedException, VisADException, RemoteException {
        double[] coeffs = new double[2];
        double[] altitudeRange = new double[2];
        double[] radiusRange = new double[2];
        radiusMap.getScale(coeffs, altitudeRange, radiusRange);
        while (Double.isNaN(altitudeRange[0])) {
            Thread.sleep(1000L);
            radiusMap.getScale(coeffs, altitudeRange, radiusRange);
        }
        double[] newRadiusRange = new double[]{0.925, 1.075};
        double newSlope = (newRadiusRange[1] - newRadiusRange[0]) / (altitudeRange[1] - altitudeRange[0]);
        double newIntercept = newRadiusRange[0] - newSlope * altitudeRange[0];
        double newMinAltitude = (radiusRange[0] - newIntercept) / newSlope;
        double newMaxAltitude = (radiusRange[1] - newIntercept) / newSlope;
        radiusMap.setRange(newMinAltitude, newMaxAltitude);
        return altitudeRange;
    }

    private static void setColorMap(ScalarMap colorMap, double min, double max) throws VisADException, RemoteException {
        LabeledColorWidget lw = new LabeledColorWidget(colorMap);
        Frame frame = new Frame("VisAD Color Widget");
        frame.addWindowListener((WindowListener)new /* Unavailable Anonymous Inner Class!! */);
        frame.add(lw);
        ((Component)frame).setSize(lw.getPreferredSize());
        ((Component)frame).setVisible(true);
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.out.println("Usage: \"java Earth file.nc\", where file.nc is a netCDF file.");
            System.out.println("This program is designed to work with the lowresTerrain.nc file available at:");
            System.out.println("  ftp://www.ssec.wisc.edu/pub/visad-2.0/lowresTerrain.nc");
            System.exit(0);
        }
        GeoDisplay display = new GeoDisplay();
        FlatField earth = (FlatField)new Plain().open(args[0]);
        FunctionType earthType = (FunctionType)earth.getType();
        RealType altitudeType = (RealType)earthType.getRange();
        RealTupleType domain = earthType.getDomain();
        RealType lon = (RealType)domain.getComponent(0);
        RealType lat = (RealType)domain.getComponent(1);
        display.addMap(new ScalarMap(lon, Display.Longitude));
        display.addMap(new ScalarMap(lat, Display.Latitude));
        ScalarMap radiusMap = new ScalarMap(altitudeType, Display.Radius);
        ScalarMap colorMap = new ScalarMap(altitudeType, Display.RGB);
        DataReferenceImpl earthRef = new DataReferenceImpl("earthRef");
        display.addMap(radiusMap);
        display.addMap(colorMap);
        earthRef.setData(earth);
        display.addReference(earthRef);
        double[] altitudeRange = Earth.setAltitudeScaling((ScalarMap)radiusMap);
        Earth.setColorMap((ScalarMap)colorMap, (double)altitudeRange[0], (double)altitudeRange[1]);
    }
}

