/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowListener;
import java.rmi.RemoteException;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.ConstantMap;
import visad.Data;
import visad.DataReferenceImpl;
import visad.Delaunay;
import visad.DelaunayClarkson;
import visad.DelaunayFast;
import visad.DelaunayWatson;
import visad.Display;
import visad.FieldImpl;
import visad.FunctionType;
import visad.Gridded3DSet;
import visad.Linear1DSet;
import visad.MathType;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.ScalarMap;
import visad.Text;
import visad.TextType;
import visad.Tuple;
import visad.TupleType;
import visad.UnimplementedException;
import visad.UnionSet;
import visad.VisADException;
import visad.java3d.DisplayImplJ3D;

public class DelaunayTest {
    public static void main(String[] argv) throws VisADException, RemoteException {
        boolean problem = false;
        int numpass = 0;
        int dim = 0;
        int points = 0;
        int type = 0;
        int l = 1;
        if (argv.length < 3) {
            problem = true;
        } else {
            try {
                dim = Integer.parseInt(argv[0]);
                points = Integer.parseInt(argv[1]);
                type = Integer.parseInt(argv[2]);
                if (argv.length > 3) {
                    l = Integer.parseInt(argv[3]);
                }
                if (dim < 2 || dim > 3 || points < 1 || type < 1 || l < 1 || l > 4) {
                    problem = true;
                }
                if (dim == 3 && type > 2) {
                    System.out.println("Only Clarkson and Watson support 3-D triangulation.\n");
                    System.exit(2);
                }
            }
            catch (NumberFormatException exc) {
                problem = true;
            }
        }
        if (problem) {
            System.out.println("Usage:\n   java visad.Delaunay dim points type [label]\ndim    = The dimension of the triangulation\n         2 = 2-D\n         3 = 3-D\npoints = The number of points to triangulate.\ntype   = The triangulation method to use:\n         1 = Clarkson\n         2 = Watson\n         3 = Fast\n     X + 3 = Fast with X improvement passes\nlabel  = How to label the diagram:\n         1 = No labels (default)\n         2 = Vertex boxes\n         3 = Triangle numbers\n         4 = Vertex numbers\n");
            System.exit(1);
        }
        if (type > 3) {
            numpass = type - 3;
            type = 3;
        }
        float[][] samples = null;
        samples = dim == 2 ? new float[2][points] : new float[3][points];
        float[] samp0 = samples[0];
        float[] samp1 = samples[1];
        float[] samp2 = null;
        if (dim == 3) {
            samp2 = samples[2];
        }
        Delaunay delaun = null;
        int i = 0;
        while (i < points) {
            samp0[i] = (float)(500.0 * Math.random());
            samp1[i] = (float)(500.0 * Math.random());
            ++i;
        }
        if (dim == 3) {
            int i2 = 0;
            while (i2 < points) {
                samp2[i2] = (float)(500.0 * Math.random());
                ++i2;
            }
        }
        System.out.print("Triangulating " + points + " points " + "in " + dim + "-D with ");
        long start = 0L;
        long end = 0L;
        if (type == 1) {
            System.out.println("the Clarkson algorithm.");
            start = System.currentTimeMillis();
            delaun = new DelaunayClarkson(samples);
            end = System.currentTimeMillis();
        } else if (type == 2) {
            System.out.println("the Watson algorithm.");
            start = System.currentTimeMillis();
            delaun = new DelaunayWatson(samples);
            end = System.currentTimeMillis();
        } else if (type == 3) {
            System.out.println("the Fast algorithm.");
            start = System.currentTimeMillis();
            delaun = new DelaunayFast(samples);
            end = System.currentTimeMillis();
        }
        float time = (float)(end - start) / 1000.0f;
        System.out.println("Triangulation took " + time + " seconds.");
        if (numpass > 0) {
            System.out.println("Improving samples: " + numpass + " pass" + (numpass > 1 ? "es..." : "..."));
            start = System.currentTimeMillis();
            delaun.improve(samples, numpass);
            end = System.currentTimeMillis();
            time = (float)(end - start) / 1000.0f;
            System.out.println("Improvement took " + time + " seconds.");
        }
        int label = l;
        int[][] tri = delaun.Tri;
        int[][] edges = delaun.Edges;
        int numedges = delaun.NumEdges;
        JFrame frame = new JFrame();
        frame.addWindowListener((WindowListener)new /* Unavailable Anonymous Inner Class!! */);
        if (dim == 2) {
            float[] s0 = samp0;
            float[] s1 = samp1;
            2 jc = new /* Unavailable Anonymous Inner Class!! */;
            frame.getContentPane().add((Component)jc);
        } else {
            RealTupleType rtt;
            RealType t;
            TextType text;
            float[][] samps = samples;
            float[] s0 = samp0;
            float[] s1 = samp1;
            float[] s2 = samp2;
            RealType x = RealType.getRealType("x");
            RealType y = RealType.getRealType("y");
            RealType z = RealType.getRealType("z");
            RealTupleType xyz = new RealTupleType(x, y, z);
            int[] e0 = new int[]{0, 0, 0, 1, 1, 2};
            int[] e1 = new int[]{1, 2, 3, 2, 3, 3};
            SampledSet[] gsp = new Gridded3DSet[numedges];
            int i3 = 0;
            while (i3 < numedges) {
                gsp[i3] = null;
                ++i3;
            }
            int i4 = 0;
            while (i4 < edges.length) {
                int[] trii = tri[i4];
                int[] edgesi = edges[i4];
                int j = 0;
                while (j < 6) {
                    if (gsp[edgesi[j]] == null) {
                        float[][] pts = new float[3][2];
                        float[] p0 = pts[0];
                        float[] p1 = pts[1];
                        float[] p2 = pts[2];
                        int tp0 = trii[e0[j]];
                        int tp1 = trii[e1[j]];
                        p0[0] = samp0[tp0];
                        p1[0] = samp1[tp0];
                        p2[0] = samp2[tp0];
                        p0[1] = samp0[tp1];
                        p1[1] = samp1[tp1];
                        p2[1] = samp2[tp1];
                        gsp[edgesi[j]] = new Gridded3DSet((MathType)xyz, pts, 2);
                    }
                    ++j;
                }
                ++i4;
            }
            UnionSet tet = new UnionSet((MathType)xyz, gsp);
            DataReferenceImpl tetref = new DataReferenceImpl("tet");
            tetref.setData(tet);
            DisplayImplJ3D display = new DisplayImplJ3D("image display");
            display.addMap(new ScalarMap(x, Display.XAxis));
            display.addMap(new ScalarMap(y, Display.YAxis));
            display.addMap(new ScalarMap(z, Display.ZAxis));
            display.addMap(new ConstantMap(1.0, Display.Red));
            display.addMap(new ConstantMap(1.0, Display.Green));
            display.addMap(new ConstantMap(0.0, Display.Blue));
            if (label == 2) {
                throw new UnimplementedException("Delaunay.main: vertex boxes");
            }
            if (label == 3) {
                int len = tri.length;
                text = new TextType("text");
                t = RealType.getRealType("t");
                rtt = new RealTupleType(new RealType[]{t});
                Linear1DSet time_set = new Linear1DSet((MathType)rtt, 0.0, len - 1, len);
                TupleType text_tuple = new TupleType(new MathType[]{x, y, z, text});
                FunctionType text_function = new FunctionType(t, text_tuple);
                FieldImpl text_field = new FieldImpl(text_function, time_set);
                int i5 = 0;
                while (i5 < len) {
                    int t0 = tri[i5][0];
                    int t1 = tri[i5][1];
                    int t2 = tri[i5][2];
                    int t3 = tri[i5][3];
                    int avgX = (int)((s0[t0] + s0[t1] + s0[t2] + s0[t3]) / 4.0f);
                    int avgY = (int)((s1[t0] + s1[t1] + s1[t2] + s1[t3]) / 4.0f);
                    int avgZ = (int)((s2[t0] + s2[t1] + s2[t2] + s2[t3]) / 4.0f);
                    Data[] td = new Data[]{new Real(x, (double)avgX), new Real(y, (double)avgY), new Real(z, (double)avgZ), new Text(text, "" + i5)};
                    Tuple tt = new Tuple(text_tuple, td);
                    text_field.setSample(i5, (Data)tt);
                    ++i5;
                }
                display.addMap(new ScalarMap(text, Display.Text));
                DataReferenceImpl rtf = new DataReferenceImpl("rtf");
                rtf.setData(text_field);
                display.addReference(rtf, null);
            } else if (label == 4) {
                int len = s0.length;
                text = new TextType("text");
                t = RealType.getRealType("t");
                rtt = new RealTupleType(new RealType[]{t});
                Linear1DSet time_set = new Linear1DSet((MathType)rtt, 0.0, len - 1, len);
                TupleType text_tuple = new TupleType(new MathType[]{x, y, z, text});
                FunctionType text_function = new FunctionType(t, text_tuple);
                FieldImpl text_field = new FieldImpl(text_function, time_set);
                int i6 = 0;
                while (i6 < len) {
                    Data[] td = new Data[]{new Real(x, (double)s0[i6]), new Real(y, (double)s1[i6]), new Real(z, (double)s2[i6]), new Text(text, "" + i6)};
                    Tuple tt = new Tuple(text_tuple, td);
                    text_field.setSample(i6, (Data)tt);
                    ++i6;
                }
                display.addMap(new ScalarMap(text, Display.Text));
                DataReferenceImpl rtf = new DataReferenceImpl("rtf");
                rtf.setData(text_field);
                display.addReference(rtf, null);
            }
            display.addReference(tetref);
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 0));
            panel.add(display.getComponent());
            frame.getContentPane().add(panel);
        }
        ((Component)frame).setSize(new Dimension(510, 530));
        frame.setTitle("Triangulation results");
        ((Component)frame).setVisible(true);
    }
}

