/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.net.MalformedURLException;
import java.rmi.ConnectException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.DataImpl;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.DisplayImpl;
import visad.ReferenceActionLink;
import visad.RemoteDisplay;
import visad.RemoteDisplayImpl;
import visad.RemoteServer;
import visad.RemoteServerImpl;
import visad.ScalarMap;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.DefaultFamily;
import visad.java3d.DisplayImplJ3D;
import visad.ss.MappingDialog;

public class CollabMapTest
extends JFrame
implements ActionListener {
    private boolean server;
    private DataReference ref;
    private DisplayImpl disp;
    private static final String usage = "Usage: java CollabMapTest [-s filename] [-c address]";

    private void constructGUI(String arg, boolean enableButtons) {
        JPanel pane = new JPanel();
        this.setContentPane(pane);
        pane.setLayout(new BoxLayout(pane, 1));
        pane.add(this.disp.getComponent());
        JPanel buttons = new JPanel();
        buttons.setLayout(new BoxLayout(buttons, 0));
        JButton detect = new JButton("Detect maps");
        JButton edit = new JButton("Edit maps");
        JButton clear = new JButton("Clear maps");
        detect.addActionListener((ActionListener)this);
        detect.setActionCommand("detect");
        detect.setEnabled(enableButtons);
        edit.addActionListener((ActionListener)this);
        edit.setActionCommand("edit");
        edit.setEnabled(enableButtons);
        clear.addActionListener((ActionListener)this);
        clear.setActionCommand("clear");
        clear.setEnabled(enableButtons);
        buttons.add(detect);
        buttons.add(edit);
        buttons.add(clear);
        pane.add(buttons);
        this.addWindowListener((WindowListener)new /* Unavailable Anonymous Inner Class!! */);
        this.setTitle("CollabMapTest " + (this.server ? "server" : "client") + ": " + arg);
        this.pack();
        this.setVisible(true);
    }

    public static void main(String[] argv) throws VisADException, RemoteException {
        if (argv.length < 2) {
            System.err.println("Not enough arguments.");
            System.err.println(usage);
            System.exit(1);
        }
        String sc = argv[0];
        String arg = argv[1];
        boolean serv = false;
        if (sc.equalsIgnoreCase("-s")) {
            serv = true;
        } else if (!sc.equalsIgnoreCase("-c")) {
            System.err.println("Please specify either -s or -c");
            System.err.println(usage);
            System.exit(2);
        }
        CollabMapTest test = new CollabMapTest(serv, arg);
    }

    public CollabMapTest(boolean serv, String arg) throws VisADException, RemoteException {
        this.server = serv;
        if (this.server) {
            DefaultFamily loader = new DefaultFamily("loader");
            DataImpl data = null;
            try {
                data = loader.open(arg);
            }
            catch (BadFormException exc) {
                System.err.println("The specified data file could not be loaded. The file is missing, corrupt, or of the wrong type.");
                exc.printStackTrace();
                throw new VisADException(exc.getMessage());
            }
            this.ref = new DataReferenceImpl("ref");
            this.ref.setData(data);
            this.disp = new DisplayImplJ3D("disp");
            this.disp.addReference(this.ref);
            RemoteServerImpl rs = new RemoteServerImpl();
            try {
                Naming.rebind("///CollabMapTest", rs);
            }
            catch (ConnectException exc) {
                System.err.println("Please run rmiregistry first.");
                throw new VisADException(exc.getMessage());
            }
            catch (MalformedURLException exc) {
                exc.printStackTrace();
                throw new VisADException(exc.getMessage());
            }
            RemoteDisplayImpl remote = new RemoteDisplayImpl(this.disp);
            rs.addDisplay(remote);
            this.constructGUI(arg, true);
        } else {
            RemoteServer rs;
            try {
                rs = (RemoteServer)Naming.lookup("//" + arg + "/CollabMapTest");
            }
            catch (NotBoundException exc) {
                System.err.println("The specified address is not running a CollabMapTest server!");
                throw new VisADException(exc.getMessage());
            }
            catch (MalformedURLException exc) {
                System.err.println("The specified address is not valid!");
                throw new VisADException(exc.getMessage());
            }
            RemoteDisplay remote = rs.getDisplay(0);
            this.disp = new DisplayImplJ3D(remote);
            Vector links = this.disp.getLinks();
            ReferenceActionLink link = (ReferenceActionLink)links.elementAt(0);
            DataReference ref = (DataReference)link.getThingReference();
            this.constructGUI(arg, false);
        }
    }

    private void setMaps(ScalarMap[] maps) throws VisADException, RemoteException {
        this.disp.removeReference(this.ref);
        this.disp.clearMaps();
        int i = 0;
        while (i < maps.length) {
            this.disp.addMap(maps[i]);
            ++i;
        }
        this.disp.addReference(this.ref);
    }

    public synchronized void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("detect")) {
            try {
                this.setMaps(this.ref.getData().getType().guessMaps(true));
            }
            catch (VisADException exc) {
                exc.printStackTrace();
            }
            catch (RemoteException exc) {
                exc.printStackTrace();
            }
        } else if (cmd.equals("edit")) {
            try {
                Vector mapVector = this.disp.getMapVector();
                int len = mapVector.size();
                ScalarMap[] maps = len > 0 ? new ScalarMap[len] : null;
                int i = 0;
                while (i < len) {
                    maps[i] = (ScalarMap)mapVector.elementAt(i);
                    ++i;
                }
                MappingDialog dialog = new MappingDialog((Frame)this, this.ref.getData(), maps, true, true);
                dialog.display();
                if (!dialog.okPressed()) {
                    return;
                }
                this.setMaps(dialog.getMaps());
            }
            catch (VisADException exc) {
                exc.printStackTrace();
            }
            catch (RemoteException exc) {
                exc.printStackTrace();
            }
        } else if (cmd.equals("clear")) {
            try {
                this.disp.removeReference(this.ref);
                this.disp.clearMaps();
                this.disp.addReference(this.ref);
            }
            catch (VisADException exc) {
                exc.printStackTrace();
            }
            catch (RemoteException exc) {
                exc.printStackTrace();
            }
        }
    }
}

