/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.event.WindowListener;
import java.rmi.RemoteException;
import javax.swing.JFrame;
import visad.DataReferenceImpl;
import visad.Display;
import visad.FlatField;
import visad.FunctionType;
import visad.ProjectionControl;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.VisADException;
import visad.java2d.DisplayImplJ2D;

public class AspectRatio
extends JFrame {
    private ProjectionControl pc;

    public static void main(String[] argv) throws VisADException, RemoteException {
        AspectRatio ar = new AspectRatio();
        ar.addWindowListener((WindowListener)new /* Unavailable Anonymous Inner Class!! */);
        ar.pack();
        ar.setVisible(true);
    }

    public AspectRatio() throws VisADException, RemoteException {
        RealType[] types = new RealType[]{RealType.Latitude, RealType.Longitude};
        RealTupleType earth_location = new RealTupleType(types);
        RealType vis_radiance = RealType.getRealType("vis_radiance");
        RealType ir_radiance = RealType.getRealType("ir_radiance");
        RealType[] types2 = new RealType[]{vis_radiance, ir_radiance};
        RealTupleType radiance = new RealTupleType(types2);
        FunctionType image_tuple = new FunctionType(earth_location, radiance);
        int size = 32;
        FlatField imaget1 = FlatField.makeField(image_tuple, size, false);
        DisplayImplJ2D disp = new DisplayImplJ2D("disp");
        disp.addMap(new ScalarMap(RealType.Latitude, Display.YAxis));
        disp.addMap(new ScalarMap(RealType.Longitude, Display.XAxis));
        disp.addMap(new ScalarMap(vis_radiance, Display.RGB));
        DataReferenceImpl ref_imaget1 = new DataReferenceImpl("ref_imaget1");
        ref_imaget1.setData(imaget1);
        disp.addReference(ref_imaget1, null);
        this.pc = disp.getProjectionControl();
        this.getContentPane().add(disp.getComponent());
        this.setTitle("Aspect ratio linked to frame size");
    }

    public void doLayout() {
        super.doLayout();
        Dimension size = this.getSize();
        try {
            this.pc.setAspect(new double[]{1.0, (double)size.height / (double)size.width});
        }
        catch (VisADException exc) {
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }
}

