/*
 * Decompiled with CFR 0.152.
 */
package spyconsole;

import java.util.Properties;
import org.python.core.Options;

class CommandLineOptions {
    public String filename = null;
    public boolean jar = false;
    public boolean interactive = true;
    public boolean notice = true;
    private boolean fixInteractive = false;
    public boolean help = false;
    public boolean version = false;
    public boolean debug = true;
    public String[] argv;
    public Properties properties = new Properties();
    public String command;

    public void setProperty(String string, String string2) {
        this.properties.put(string, string2);
        try {
            System.setProperty(string, string2);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public boolean parse(String[] stringArray) {
        int n;
        for (n = 0; n < stringArray.length && stringArray[n].startsWith("-"); ++n) {
            String string;
            String string2 = stringArray[n];
            if (this.debug) {
                System.out.println("\n\n  SPyConsole processing arg: " + string2);
            }
            if (string2.equals("--help")) {
                this.help = true;
                return false;
            }
            if (string2.equals("--version")) {
                this.version = true;
                return false;
            }
            if (string2.equals("-")) {
                if (!this.fixInteractive) {
                    this.interactive = false;
                }
                this.filename = "-";
                continue;
            }
            if (string2.equals("-i")) {
                this.fixInteractive = true;
                this.interactive = true;
                continue;
            }
            if (string2.equals("-jar")) {
                this.jar = true;
                if (this.fixInteractive) continue;
                this.interactive = false;
                continue;
            }
            if (string2.equals("-S")) {
                Options.importSite = false;
                continue;
            }
            if (string2.equals("-c")) {
                this.command = stringArray[++n];
                if (this.fixInteractive) break;
                this.interactive = false;
                break;
            }
            if (string2.startsWith("-D")) {
                string = null;
                String string3 = null;
                int n2 = string2.indexOf("=");
                if (n2 == -1) {
                    String string4 = stringArray[++n];
                    string = string2.substring(2, string2.length());
                    string3 = string4;
                } else {
                    string = string2.substring(2, n2);
                    string3 = string2.substring(n2 + 1, string2.length());
                }
                this.setProperty(string, string3);
                continue;
            }
            string = stringArray[n];
            if (string.startsWith("--")) {
                string = string.substring(2);
            } else if (string.startsWith("-")) {
                string = string.substring(1);
            }
            System.err.println("jython: illegal option -- " + string);
            return false;
        }
        this.notice = this.interactive;
        if (this.filename == null && n < stringArray.length && this.command == null) {
            this.filename = stringArray[n++];
            if (!this.fixInteractive) {
                this.interactive = false;
            }
            this.notice = false;
        }
        if (this.command != null) {
            this.notice = false;
        }
        int n3 = stringArray.length - n + 1;
        this.argv = new String[n3];
        this.argv[0] = this.filename != null ? this.filename : "";
        int n4 = 1;
        while (n4 < n3) {
            this.argv[n4] = stringArray[n];
            ++n4;
            ++n;
        }
        return true;
    }
}

