/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JRclient;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.rosuda.JRclient.REXP;
import org.rosuda.JRclient.RFileInputStream;
import org.rosuda.JRclient.RFileOutputStream;
import org.rosuda.JRclient.RSrvException;
import org.rosuda.JRclient.Rpacket;
import org.rosuda.JRclient.Rtalk;
import org.rosuda.JRclient.jcrypt;

public class Rconnection {
    String lastError = null;
    Socket s;
    boolean connected = false;
    InputStream is;
    OutputStream os;
    boolean authReq = false;
    int authType = 0;
    String Key = null;
    Rtalk rt = null;
    public static String transferCharset = "UTF-8";
    public static final int AT_plain = 0;
    public static final int AT_crypt = 1;
    protected int rsrvVersion;

    public Rconnection() throws RSrvException {
        this("127.0.0.1", 6311);
    }

    public Rconnection(String string) throws RSrvException {
        this(string, 6311);
    }

    public Rconnection(String string, int n) throws RSrvException {
        try {
            if (this.connected) {
                this.s.close();
            }
            this.s = null;
        }
        catch (Exception exception) {
            throw new RSrvException(this, "Cannot connect: " + exception.getMessage());
        }
        this.connected = false;
        try {
            this.s = new Socket(string, n);
            this.s.setTcpNoDelay(true);
        }
        catch (Exception exception) {
            throw new RSrvException(this, "Cannot connect: " + exception.getMessage());
        }
        try {
            this.is = this.s.getInputStream();
            this.os = this.s.getOutputStream();
        }
        catch (Exception exception) {
            throw new RSrvException(this, "Cannot get io stream: " + exception.getMessage());
        }
        this.rt = new Rtalk(this.is, this.os);
        byte[] byArray = new byte[32];
        int n2 = -1;
        try {
            n2 = this.is.read(byArray);
        }
        catch (Exception exception) {
            throw new RSrvException(this, "Error while receiving data: " + exception.getMessage());
        }
        try {
            if (n2 != 32) {
                this.lastError = "Handshake failed: expected 32 bytes header, got " + n2;
                throw new RSrvException(this, this.lastError);
            }
            String string2 = new String(byArray);
            if (string2.substring(0, 4).compareTo("Rsrv") != 0) {
                this.lastError = "Handshake failed: Rsrv signature expected, but received \"" + string2 + "\" instead.";
                throw new RSrvException(this, this.lastError);
            }
            try {
                this.rsrvVersion = Integer.parseInt(string2.substring(4, 8));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.rsrvVersion > 102) {
                this.lastError = "Handshake failed: The server uses more recent protocol than this client.";
                throw new RSrvException(this, this.lastError);
            }
            if (string2.substring(8, 12).compareTo("QAP1") != 0) {
                this.lastError = "Handshake failed: unupported transfer protocol (" + string2.substring(8, 12) + "), I talk only QAP1.";
                throw new RSrvException(this, this.lastError);
            }
            for (int i = 12; i < 32; i += 4) {
                String string3 = string2.substring(i, i + 4);
                if (string3.compareTo("ARpt") == 0 && !this.authReq) {
                    this.authReq = true;
                    this.authType = 0;
                }
                if (string3.compareTo("ARuc") == 0) {
                    this.authReq = true;
                    this.authType = 1;
                }
                if (string3.charAt(0) != 'K') continue;
                this.Key = string3.substring(1, 3);
            }
            this.connected = true;
            this.lastError = "OK";
        }
        catch (RSrvException rSrvException) {
            try {
                this.s.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.is = null;
            this.os = null;
            this.s = null;
            throw rSrvException;
        }
    }

    public void finalize() {
        this.close();
        this.is = null;
        this.is = null;
    }

    public int getServerVersion() {
        return this.rsrvVersion;
    }

    public void close() {
        try {
            if (this.s != null) {
                this.s.close();
            }
            this.connected = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void voidEval(String string) throws RSrvException {
        if (!this.connected || this.rt == null) {
            this.lastError = "Error: not connected!";
            throw new RSrvException(this, this.lastError);
        }
        Rpacket rpacket = this.rt.request(2, string + "\n");
        if (rpacket != null && rpacket.isOk()) {
            return;
        }
        this.lastError = rpacket != null ? "Request return code: " + rpacket.getStat() : "Communication error (Rtalk returned null)";
        throw new RSrvException(this, this.lastError, rpacket.getStat());
    }

    public REXP eval(String string) throws RSrvException {
        if (!this.connected || this.rt == null) {
            this.lastError = "Error: not connected!";
            throw new RSrvException(this, this.lastError);
        }
        Rpacket rpacket = this.rt.request(3, string + "\n");
        if (rpacket != null && rpacket.isOk()) {
            int n = 0;
            byte[] byArray = rpacket.getCont();
            if (this.rsrvVersion > 100) {
                n = 4;
                if (byArray[0] != 10 && byArray[0] != 74) {
                    this.lastError = "Error while processing eval output: SEXP (type 10) expected but found result type " + byArray[0] + ".";
                    throw new RSrvException(this, this.lastError);
                }
                if (byArray[0] == 74) {
                    n = 8;
                }
            }
            REXP rEXP = null;
            if (byArray.length > n) {
                rEXP = new REXP();
                REXP.parseREXP(rEXP, byArray, n);
            }
            return rEXP;
        }
        this.lastError = rpacket != null ? "Request return code: " + rpacket.getStat() : "Communication error (Rtalk returned null)";
        throw new RSrvException(this, this.lastError, rpacket != null ? rpacket.getStat() : -1);
    }

    public void assign(String string, String string2) throws RSrvException {
        int n;
        if (!this.connected || this.rt == null) {
            this.lastError = "Error: not connected!";
            throw new RSrvException(this, this.lastError);
        }
        byte[] byArray = string.getBytes();
        byte[] byArray2 = string2.getBytes();
        int n2 = byArray.length + 1;
        int n3 = byArray2.length + 1;
        if ((n2 & 3) > 0) {
            n2 = (n2 & 0xFFFFFC) + 4;
        }
        if ((n3 & 3) > 0) {
            n3 = (n3 & 0xFFFFFC) + 4;
        }
        byte[] byArray3 = new byte[n2 + 4 + n3 + 4];
        for (n = 0; n < byArray.length; ++n) {
            byArray3[n + 4] = byArray[n];
        }
        while (n < n2) {
            byArray3[n + 4] = 0;
            ++n;
        }
        for (n = 0; n < byArray2.length; ++n) {
            byArray3[n + n2 + 8] = byArray2[n];
        }
        while (n < n3) {
            byArray3[n + n2 + 8] = 0;
            ++n;
        }
        Rtalk.setHdr(4, n2, byArray3, 0);
        Rtalk.setHdr(4, n3, byArray3, n2 + 4);
        Rpacket rpacket = this.rt.request(32, byArray3);
        if (rpacket != null && rpacket.isOk()) {
            return;
        }
        this.lastError = rpacket != null ? "Request return code: " + rpacket.getStat() : "Communication error (Rtalk returned null)";
        throw new RSrvException(this, this.lastError, rpacket != null ? rpacket.getStat() : -1);
    }

    public void assign(String string, REXP rEXP) throws RSrvException {
        int n;
        if (!this.connected || this.rt == null) {
            this.lastError = "Error: not connected!";
            throw new RSrvException(this, this.lastError);
        }
        int n2 = rEXP.getBinaryLength();
        byte[] byArray = string.getBytes();
        int n3 = byArray.length + 1;
        if ((n3 & 3) > 0) {
            n3 = (n3 & 0xFFFFFC) + 4;
        }
        byte[] byArray2 = new byte[n3 + n2 + (n2 > 0xFFFFF0 ? 12 : 8)];
        for (n = 0; n < byArray.length; ++n) {
            byArray2[n + 4] = byArray[n];
        }
        while (n < n3) {
            byArray2[n + 4] = 0;
            ++n;
        }
        Rtalk.setHdr(4, n3, byArray2, 0);
        Rtalk.setHdr(10, n2, byArray2, n3 + 4);
        rEXP.getBinaryRepresentation(byArray2, n3 + (n2 > 0xFFFFF0 ? 12 : 8));
        Rpacket rpacket = this.rt.request(32, byArray2);
        if (rpacket != null && rpacket.isOk()) {
            return;
        }
        this.lastError = rpacket != null ? "Request return code: " + rpacket.getStat() : "Communication error (Rtalk returned null)";
        throw new RSrvException(this, this.lastError, rpacket != null ? rpacket.getStat() : -1);
    }

    public void assign(String string, double[] dArray) throws RSrvException {
        this.assign(string, new REXP(dArray));
    }

    public void assign(String string, int[] nArray) throws RSrvException {
        this.assign(string, new REXP(nArray));
    }

    public RFileInputStream openFile(String string) throws IOException {
        return new RFileInputStream(this.rt, string);
    }

    public RFileOutputStream createFile(String string) throws IOException {
        return new RFileOutputStream(this.rt, string);
    }

    public void removeFile(String string) throws RSrvException {
        if (!this.connected || this.rt == null) {
            this.lastError = "Error: not connected";
            throw new RSrvException(this, this.lastError);
        }
        Rpacket rpacket = this.rt.request(21, string);
        if (rpacket != null && rpacket.isOk()) {
            return;
        }
        this.lastError = rpacket != null ? "Request return code: " + rpacket.getStat() : "Communication error (Rtalk returned null)";
        throw new RSrvException(this, this.lastError, rpacket != null ? rpacket.getStat() : -1);
    }

    public void shutdown() throws RSrvException {
        if (!this.connected || this.rt == null) {
            this.lastError = "Error: not connected";
            throw new RSrvException(this, this.lastError);
        }
        Rpacket rpacket = this.rt.request(4);
        if (rpacket != null && rpacket.isOk()) {
            return;
        }
        this.lastError = rpacket != null ? "Request return code: " + rpacket.getStat() : "Communication error (Rtalk returned null)";
        throw new RSrvException(this, this.lastError, rpacket != null ? rpacket.getStat() : -1);
    }

    public void setSendBufferSize(long l) throws RSrvException {
        if (!this.connected || this.rt == null) {
            this.lastError = "Error: not connected";
            throw new RSrvException(this, this.lastError);
        }
        Rpacket rpacket = this.rt.request(129, (int)l);
        if (rpacket != null && rpacket.isOk()) {
            return;
        }
        this.lastError = rpacket != null ? "Request return code: " + rpacket.getStat() : "Communication error (Rtalk returned null)";
        throw new RSrvException(this, this.lastError, rpacket != null ? rpacket.getStat() : -1);
    }

    public void login(String string, String string2) throws RSrvException {
        if (!this.authReq) {
            return;
        }
        if (this.authType == 1) {
            Rpacket rpacket;
            if (this.Key == null) {
                this.Key = "rs";
            }
            if ((rpacket = this.rt.request(1, string + "\n" + jcrypt.crypt(this.Key, string2))) != null && rpacket.isOk()) {
                return;
            }
            this.lastError = rpacket != null ? "Request return code: " + rpacket.getStat() : "Communication error (Rtalk returned null)";
            try {
                this.s.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.is = null;
            this.os = null;
            this.s = null;
            this.connected = false;
            throw new RSrvException(this, this.lastError);
        }
        Rpacket rpacket = this.rt.request(1, string + "\n" + string2);
        if (rpacket != null && rpacket.isOk()) {
            return;
        }
        this.lastError = rpacket != null ? "Request return code: " + rpacket.getStat() : "Communication error (Rtalk returned null)";
        try {
            this.s.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.is = null;
        this.os = null;
        this.s = null;
        this.connected = false;
        throw new RSrvException(this, this.lastError, rpacket != null ? rpacket.getStat() : -1);
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean needLogin() {
        return this.authReq;
    }

    public String getLastError() {
        return this.lastError;
    }
}

