/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JRclient;

import java.io.IOException;
import java.io.InputStream;
import org.rosuda.JRclient.Rpacket;
import org.rosuda.JRclient.Rtalk;

public class RFileInputStream
extends InputStream {
    Rtalk rt;
    boolean closed;
    boolean eof;

    RFileInputStream(Rtalk rtalk, String string) throws IOException {
        this.rt = rtalk;
        Rpacket rpacket = this.rt.request(16, string);
        if (rpacket == null || !rpacket.isOk()) {
            throw new IOException(rpacket == null ? "Connection to Rserve failed" : "Request return code: " + rpacket.getStat());
        }
        this.closed = false;
        this.eof = false;
    }

    public int read() throws IOException {
        byte[] byArray = new byte[1];
        if (this.read(byArray, 0, 1) < 1) {
            return -1;
        }
        return byArray[0];
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            throw new IOException("File is not open");
        }
        if (this.eof) {
            return -1;
        }
        Rpacket rpacket = this.rt.request(19, n2);
        if (rpacket == null || !rpacket.isOk()) {
            throw new IOException(rpacket == null ? "Connection to Rserve failed" : "Request return code: " + rpacket.getStat());
        }
        byte[] byArray2 = rpacket.getCont();
        if (byArray2 == null) {
            this.eof = true;
            return -1;
        }
        for (int i = 0; i < byArray2.length; ++i) {
            byArray[n + i] = byArray2[i];
        }
        return byArray2.length;
    }

    public void close() throws IOException {
        Rpacket rpacket = this.rt.request(18, (byte[])null);
        if (rpacket == null || !rpacket.isOk()) {
            throw new IOException(rpacket == null ? "Connection to Rserve failed" : "Request return code: " + rpacket.getStat());
        }
        this.closed = true;
    }
}

