/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JRclient;

import java.io.UnsupportedEncodingException;
import java.util.Vector;
import org.rosuda.JRclient.RBool;
import org.rosuda.JRclient.RFactor;
import org.rosuda.JRclient.RList;
import org.rosuda.JRclient.Rconnection;
import org.rosuda.JRclient.Rtalk;

public class REXP {
    public static final int XT_NULL = 0;
    public static final int XT_INT = 1;
    public static final int XT_DOUBLE = 2;
    public static final int XT_STR = 3;
    public static final int XT_LANG = 4;
    public static final int XT_SYM = 5;
    public static final int XT_BOOL = 6;
    public static final int XT_VECTOR = 16;
    public static final int XT_LIST = 17;
    public static final int XT_CLOS = 18;
    public static final int XT_ARRAY_INT = 32;
    public static final int XT_ARRAY_DOUBLE = 33;
    public static final int XT_ARRAY_STR = 34;
    public static final int XT_ARRAY_BOOL_UA = 35;
    public static final int XT_ARRAY_BOOL = 36;
    public static final int XT_UNKNOWN = 48;
    public static final int XT_FACTOR = 127;
    int Xt;
    REXP attr;
    Object cont;
    long cachedBinaryLength = -1L;

    public REXP() {
        this.Xt = 0;
        this.attr = null;
        this.cont = null;
    }

    public REXP(int n, Object object) {
        this.Xt = n;
        this.cont = object;
        this.attr = null;
    }

    public REXP(int n, Object object, REXP rEXP) {
        this.Xt = n;
        this.cont = object;
        this.attr = rEXP;
    }

    public REXP(double[] dArray) {
        this(33, dArray);
    }

    public REXP(int[] nArray) {
        this(32, nArray);
    }

    public REXP(String[] stringArray) {
        this(34, stringArray);
    }

    public REXP getAttribute() {
        return this.attr;
    }

    public Object getContent() {
        return this.cont;
    }

    public int getType() {
        return this.Xt;
    }

    public static int parseREXP(REXP rEXP, byte[] byArray, int n) {
        int n2 = Rtalk.getLen(byArray, n);
        boolean bl = (byArray[n] & 0x80) != 0;
        boolean bl2 = (byArray[n] & 0x40) != 0;
        int n3 = byArray[n] & 0x3F;
        if (bl2) {
            n += 4;
        }
        int n4 = (n += 4) + n2;
        rEXP.Xt = n3;
        rEXP.attr = null;
        if (bl) {
            rEXP.attr = new REXP();
            n = REXP.parseREXP(rEXP.attr, byArray, n);
        }
        if (n3 == 0) {
            rEXP.cont = null;
            return n;
        }
        if (n3 == 2) {
            long l = Rtalk.getLong(byArray, n);
            rEXP.cont = new Double(Double.longBitsToDouble(l));
            if ((n += 8) != n4) {
                System.out.println("Warning: double SEXP size mismatch\n");
                n = n4;
            }
            return n;
        }
        if (n3 == 33) {
            int n5 = (n4 - n) / 8;
            int n6 = 0;
            double[] dArray = new double[n5];
            while (n < n4) {
                dArray[n6] = Double.longBitsToDouble(Rtalk.getLong(byArray, n));
                n += 8;
                ++n6;
            }
            if (n != n4) {
                System.out.println("Warning: double array SEXP size mismatch\n");
                n = n4;
            }
            rEXP.cont = dArray;
            return n;
        }
        if (n3 == 6) {
            rEXP.cont = new RBool(byArray[n]);
            if (++n != n4) {
                if (n4 != n + 3) {
                    System.out.println("Warning: bool SEXP size mismatch\n");
                }
                n = n4;
            }
            return n;
        }
        if (n3 == 35) {
            int n7 = n4 - n;
            int n8 = 0;
            rEXP.Xt = 36;
            RBool[] rBoolArray = new RBool[n7];
            while (n < n4) {
                rBoolArray[n8] = new RBool(byArray[n]);
                ++n8;
                ++n;
            }
            rEXP.cont = rBoolArray;
            return n;
        }
        if (n3 == 36) {
            int n9;
            int n10 = Rtalk.getInt(byArray, n);
            n += 4;
            RBool[] rBoolArray = new RBool[n10];
            for (n9 = 0; n < n4 && n9 < n10; ++n9, ++n) {
                rBoolArray[n9] = new RBool(byArray[n]);
            }
            while ((n9 & 3) != 0) {
                ++n9;
                ++n;
            }
            rEXP.cont = rBoolArray;
            return n;
        }
        if (n3 == 1) {
            rEXP.cont = new Integer(Rtalk.getInt(byArray, n));
            if ((n += 4) != n4) {
                System.out.println("Warning: int SEXP size mismatch\n");
                n = n4;
            }
            return n;
        }
        if (n3 == 32) {
            int n11 = (n4 - n) / 4;
            int n12 = 0;
            int[] nArray = new int[n11];
            while (n < n4) {
                nArray[n12] = Rtalk.getInt(byArray, n);
                n += 4;
                ++n12;
            }
            if (n != n4) {
                System.out.println("Warning: int array SEXP size mismatch\n");
                n = n4;
            }
            rEXP.cont = nArray;
            if (rEXP.attr != null && rEXP.attr.Xt == 17 && rEXP.attr.cont != null && ((RList)rEXP.attr.cont).head != null && ((RList)rEXP.attr.cont).body != null && ((RList)rEXP.attr.cont).head.cont != null && ((RList)rEXP.attr.cont).body.cont != null && ((RList)rEXP.attr.cont).head.Xt == 16 && ((RList)rEXP.attr.cont).body.Xt == 17 && ((RList)((RList)rEXP.attr.cont).body.cont).head != null && ((RList)((RList)rEXP.attr.cont).body.cont).head.Xt == 3 && ((String)((RList)((RList)rEXP.attr.cont).body.cont).head.cont).compareTo("factor") == 0) {
                RFactor rFactor = new RFactor(nArray, (Vector)((RList)rEXP.attr.cont).head.cont);
                rEXP.cont = rFactor;
                rEXP.Xt = 127;
                rEXP.attr = null;
            }
            return n;
        }
        if (n3 == 16) {
            Object object;
            Vector<REXP> vector = new Vector<REXP>();
            while (n < n4) {
                object = new REXP();
                n = REXP.parseREXP((REXP)object, byArray, n);
                vector.addElement((REXP)object);
            }
            if (n != n4) {
                System.out.println("Warning: int vector SEXP size mismatch\n");
                n = n4;
            }
            rEXP.cont = vector;
            if (rEXP.attr != null && rEXP.attr.Xt == 17 && rEXP.attr.cont != null) {
                object = new RList();
                ((RList)object).head = ((RList)rEXP.attr.cont).head;
                ((RList)object).body = new REXP(16, vector);
                rEXP.cont = object;
                rEXP.Xt = 17;
                rEXP.attr = rEXP.attr.attr;
                if (((RList)object).head.Xt == 3) {
                    Vector<REXP> vector2 = new Vector<REXP>();
                    vector2.addElement(((RList)object).head);
                    ((RList)object).head = new REXP(16, vector2, ((RList)object).head.attr);
                    ((RList)object).head.attr = null;
                }
            }
            return n;
        }
        if (n3 == 3) {
            int n13;
            for (n13 = n; byArray[n13] != 0 && n13 < n4; ++n13) {
            }
            try {
                rEXP.cont = new String(byArray, n, n13 - n, Rconnection.transferCharset);
            }
            catch (Exception exception) {
                System.out.println("unable to convert string\n");
                rEXP.cont = null;
            }
            n = n4;
            return n;
        }
        if (n3 == 17 || n3 == 4) {
            RList rList = new RList();
            rList.head = new REXP();
            rList.body = new REXP();
            rList.tag = null;
            n = REXP.parseREXP(rList.head, byArray, n);
            if ((n = REXP.parseREXP(rList.body, byArray, n)) != n4) {
                rList.tag = new REXP();
                if ((n = REXP.parseREXP(rList.tag, byArray, n)) != n4) {
                    System.out.println("Warning: list SEXP size mismatch\n");
                    n = n4;
                }
            }
            rEXP.cont = rList;
            return n;
        }
        if (n3 == 5) {
            REXP rEXP2 = new REXP();
            n = REXP.parseREXP(rEXP2, byArray, n);
            String string = null;
            string = rEXP2.Xt == 3 ? (String)rEXP2.cont : rEXP2.toString();
            rEXP.cont = string;
            n = n4;
            return n;
        }
        if (n3 == 18) {
            REXP rEXP3 = new REXP();
            REXP rEXP4 = new REXP();
            n = REXP.parseREXP(rEXP3, byArray, n);
            if ((n = REXP.parseREXP(rEXP4, byArray, n)) != n4) {
                System.out.println("Warning: closure SEXP size mismatch\n");
                n = n4;
            }
            rEXP.cont = rEXP4;
            return n;
        }
        if (n3 == 48) {
            rEXP.cont = new Integer(Rtalk.getInt(byArray, n));
            n = n4;
            return n;
        }
        rEXP.cont = null;
        n = n4;
        System.out.println("unhandled type: " + n3);
        return n;
    }

    public int getBinaryLength() {
        int n = 0;
        switch (this.Xt) {
            case 1: {
                n = 4;
                break;
            }
            case 2: {
                n = 8;
                break;
            }
            case 3: {
                n = this.cont == null ? 1 : ((String)this.cont).length() + 1;
                break;
            }
            case 32: {
                n = this.cont == null ? 0 : ((int[])this.cont).length * 4;
                break;
            }
            case 33: {
                n = this.cont == null ? 0 : ((double[])this.cont).length * 8;
                break;
            }
            case 34: {
                if (this.cachedBinaryLength < 0L) {
                    if (this.cont == null) {
                        this.cachedBinaryLength = 4L;
                    } else {
                        String[] stringArray = (String[])this.cont;
                        int n2 = 0;
                        for (int i = 0; i < stringArray.length; ++i) {
                            if (stringArray[i] != null) {
                                try {
                                    byte[] byArray = stringArray[i].getBytes(Rconnection.transferCharset);
                                    n2 += byArray.length;
                                    byArray = null;
                                }
                                catch (UnsupportedEncodingException unsupportedEncodingException) {
                                    // empty catch block
                                }
                            }
                            ++n2;
                        }
                        while ((n2 & 3) != 0) {
                            ++n2;
                        }
                        this.cachedBinaryLength = n2 + 4;
                        if (this.cachedBinaryLength > 0xFFFFF0L) {
                            this.cachedBinaryLength += 4L;
                        }
                    }
                }
                return (int)this.cachedBinaryLength;
            }
        }
        if (n > 0xFFFFF0) {
            n += 4;
        }
        return n + 4;
    }

    public int getBinaryRepresentation(byte[] byArray, int n) {
        int n2 = this.getBinaryLength();
        boolean bl = n2 > 0xFFFFF0;
        Rtalk.setHdr(this.Xt, n2 - (bl ? 8 : 4), byArray, n);
        n += bl ? 8 : 4;
        switch (this.Xt) {
            case 1: {
                Rtalk.setInt(this.asInt(), byArray, n);
                break;
            }
            case 2: {
                Rtalk.setLong(Double.doubleToLongBits(this.asDouble()), byArray, n);
                break;
            }
            case 32: {
                if (this.cont == null) break;
                int[] nArray = (int[])this.cont;
                int n3 = 0;
                int n4 = n;
                while (n3 < nArray.length) {
                    Rtalk.setInt(nArray[n3++], byArray, n4);
                    n4 += 4;
                }
                break;
            }
            case 33: {
                if (this.cont == null) break;
                double[] dArray = (double[])this.cont;
                int n5 = 0;
                int n6 = n;
                while (n5 < dArray.length) {
                    Rtalk.setLong(Double.doubleToLongBits(dArray[n5++]), byArray, n6);
                    n6 += 8;
                }
                break;
            }
            case 34: {
                int n7;
                if (this.cont == null) break;
                String[] stringArray = (String[])this.cont;
                int n8 = n;
                for (n7 = 0; n7 < stringArray.length; ++n7) {
                    if (stringArray[n7] != null) {
                        try {
                            byte[] byArray2 = stringArray[n7].getBytes(Rconnection.transferCharset);
                            System.arraycopy(byArray2, 0, byArray, n8, byArray2.length);
                            n8 += byArray2.length;
                            byArray2 = null;
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            // empty catch block
                        }
                    }
                    byArray[n8++] = 0;
                }
                n7 = n8 - n;
                while ((n7 & 3) != 0) {
                    byArray[n8++] = 1;
                    ++n7;
                }
                break;
            }
        }
        return n + n2;
    }

    public static String xtName(int n) {
        if (n == 0) {
            return "NULL";
        }
        if (n == 1) {
            return "INT";
        }
        if (n == 3) {
            return "STRING";
        }
        if (n == 2) {
            return "REAL";
        }
        if (n == 6) {
            return "BOOL";
        }
        if (n == 32) {
            return "INT*";
        }
        if (n == 34) {
            return "STRING*";
        }
        if (n == 33) {
            return "REAL*";
        }
        if (n == 36) {
            return "BOOL*";
        }
        if (n == 5) {
            return "SYMBOL";
        }
        if (n == 4) {
            return "LANG";
        }
        if (n == 17) {
            return "LIST";
        }
        if (n == 18) {
            return "CLOS";
        }
        if (n == 16) {
            return "VECTOR";
        }
        if (n == 127) {
            return "FACTOR";
        }
        if (n == 48) {
            return "UNKNOWN";
        }
        return "<unknown " + n + ">";
    }

    public String asString() {
        return this.Xt == 3 ? (String)this.cont : null;
    }

    public int asInt() {
        return this.Xt == 1 ? (Integer)this.cont : 0;
    }

    public double asDouble() {
        return this.Xt == 2 ? (Double)this.cont : 0.0;
    }

    public Vector asVector() {
        return this.Xt == 16 ? (Vector)this.cont : null;
    }

    public RFactor asFactor() {
        return this.Xt == 127 ? (RFactor)this.cont : null;
    }

    public RList asList() {
        return this.Xt == 17 ? (RList)this.cont : null;
    }

    public RBool asBool() {
        return this.Xt == 17 ? (RBool)this.cont : null;
    }

    public double[] asDoubleArray() {
        if (this.Xt == 33) {
            return (double[])this.cont;
        }
        if (this.Xt == 2) {
            double[] dArray = new double[]{this.asDouble()};
            return dArray;
        }
        if (this.Xt == 1) {
            double[] dArray = new double[]{((Integer)this.cont).doubleValue()};
            return dArray;
        }
        if (this.Xt == 32) {
            int[] nArray = this.asIntArray();
            if (nArray == null) {
                return null;
            }
            double[] dArray = new double[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                dArray[i] = nArray[i];
            }
            return dArray;
        }
        return null;
    }

    public int[] asIntArray() {
        if (this.Xt == 32) {
            return (int[])this.cont;
        }
        if (this.Xt == 1) {
            int[] nArray = new int[]{this.asInt()};
            return nArray;
        }
        return null;
    }

    public double[][] asDoubleMatrix() {
        if (this.Xt != 33 || this.attr == null || this.attr.Xt != 17) {
            return null;
        }
        REXP rEXP = this.attr.asList().getHead();
        if (rEXP == null || rEXP.Xt != 32) {
            return null;
        }
        int[] nArray = rEXP.asIntArray();
        if (nArray == null || nArray.length != 2) {
            return null;
        }
        int n = nArray[0];
        int n2 = nArray[1];
        double[][] dArray = new double[n][n2];
        double[] dArray2 = this.asDoubleArray();
        if (dArray2 == null) {
            return null;
        }
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            int n4 = 0;
            while (n4 < n) {
                dArray[n4++][i] = dArray2[n3++];
            }
        }
        return dArray;
    }

    public double[][] asMatrix() {
        return this.asDoubleMatrix();
    }

    public String toString() {
        int n;
        Object object;
        StringBuffer stringBuffer = new StringBuffer("[" + REXP.xtName(this.Xt) + " ");
        if (this.attr != null) {
            stringBuffer.append("\nattr=" + this.attr + "\n ");
        }
        if (this.Xt == 2) {
            stringBuffer.append((Double)this.cont);
        }
        if (this.Xt == 1) {
            stringBuffer.append((Integer)this.cont);
        }
        if (this.Xt == 6) {
            stringBuffer.append((RBool)this.cont);
        }
        if (this.Xt == 127) {
            stringBuffer.append((RFactor)this.cont);
        }
        if (this.Xt == 33) {
            object = (double[])this.cont;
            stringBuffer.append("(");
            for (n = 0; n < ((double[])object).length; ++n) {
                stringBuffer.append(object[n]);
                if (n < ((double[])object).length - 1) {
                    stringBuffer.append(", ");
                }
                if (n != 99) continue;
                stringBuffer.append("... (" + (((Object)object).length - 100) + " more values follow)");
                break;
            }
            stringBuffer.append(")");
        }
        if (this.Xt == 32) {
            object = (int[])this.cont;
            stringBuffer.append("(");
            for (n = 0; n < ((double[])object).length; ++n) {
                stringBuffer.append((int)object[n]);
                if (n < ((Object)object).length - 1) {
                    stringBuffer.append(", ");
                }
                if (n != 99) continue;
                stringBuffer.append("... (" + (((Object)object).length - 100) + " more values follow)");
                break;
            }
            stringBuffer.append(")");
        }
        if (this.Xt == 36) {
            object = (RBool[])this.cont;
            stringBuffer.append("(");
            for (n = 0; n < ((double[])object).length; ++n) {
                stringBuffer.append(object[n]);
                if (n >= ((Object)object).length - 1) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append(")");
        }
        if (this.Xt == 16) {
            object = (Vector)this.cont;
            stringBuffer.append("(");
            for (n = 0; n < ((Vector)object).size(); ++n) {
                stringBuffer.append(((REXP)((Vector)object).elementAt(n)).toString());
                if (n >= ((Vector)object).size() - 1) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append(")");
        }
        if (this.Xt == 3) {
            stringBuffer.append("\"");
            stringBuffer.append((String)this.cont);
            stringBuffer.append("\"");
        }
        if (this.Xt == 5) {
            stringBuffer.append((String)this.cont);
        }
        if (this.Xt == 17 || this.Xt == 4) {
            object = (RList)this.cont;
            stringBuffer.append(((RList)object).head);
            stringBuffer.append(" <-> ");
            stringBuffer.append(((RList)object).body);
        }
        if (this.Xt == 48) {
            stringBuffer.append((Integer)this.cont);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

