/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.util;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.jfree.xml.util.AttributeDefinition;
import org.jfree.xml.util.BasicTypeSupport;
import org.jfree.xml.util.ConstructorDefinition;
import org.jfree.xml.util.LookupDefinition;
import org.jfree.xml.util.ObjectDescriptionException;
import org.jfree.xml.util.PropertyDefinition;

public final class GenericObjectFactory {
    private final ConstructorDefinition[] constructorDefinitions;
    private final PropertyDefinition[] propertyDefinitions;
    private final LookupDefinition[] lookupDefinitions;
    private final AttributeDefinition[] attributeDefinitions;
    private final String[] orderedPropertyNames;
    private final HashMap propertyInfos;
    private final HashMap propertyValues;
    private final Class baseClass;
    private final String registerName;
    static /* synthetic */ Class class$java$lang$Object;

    public GenericObjectFactory(Class clazz, String string, ConstructorDefinition[] constructorDefinitionArray, PropertyDefinition[] propertyDefinitionArray, LookupDefinition[] lookupDefinitionArray, AttributeDefinition[] attributeDefinitionArray, String[] stringArray) throws ObjectDescriptionException {
        if (clazz == null) {
            throw new NullPointerException("BaseClass cannot be null.");
        }
        this.baseClass = clazz;
        this.registerName = string;
        this.propertyInfos = new HashMap();
        this.propertyValues = new HashMap();
        this.constructorDefinitions = constructorDefinitionArray;
        this.propertyDefinitions = propertyDefinitionArray;
        this.lookupDefinitions = lookupDefinitionArray;
        this.attributeDefinitions = attributeDefinitionArray;
        this.orderedPropertyNames = stringArray;
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz, class$java$lang$Object == null ? (class$java$lang$Object = GenericObjectFactory.class$("java.lang.Object")) : class$java$lang$Object);
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                this.propertyInfos.put(propertyDescriptorArray[i].getName(), propertyDescriptorArray[i]);
            }
        }
        catch (IntrospectionException introspectionException) {
            throw new ObjectDescriptionException("This is an ugly solution right now ... dirty hack attack");
        }
    }

    private GenericObjectFactory(GenericObjectFactory genericObjectFactory) {
        this.baseClass = genericObjectFactory.baseClass;
        this.propertyValues = new HashMap();
        this.orderedPropertyNames = genericObjectFactory.orderedPropertyNames;
        this.constructorDefinitions = genericObjectFactory.constructorDefinitions;
        this.propertyDefinitions = genericObjectFactory.propertyDefinitions;
        this.attributeDefinitions = genericObjectFactory.attributeDefinitions;
        this.propertyInfos = genericObjectFactory.propertyInfos;
        this.registerName = genericObjectFactory.registerName;
        this.lookupDefinitions = genericObjectFactory.lookupDefinitions;
    }

    public GenericObjectFactory getInstance() {
        return new GenericObjectFactory(this);
    }

    public String getRegisterName() {
        return this.registerName;
    }

    private PropertyDescriptor getPropertyDescriptor(String string) {
        return (PropertyDescriptor)this.propertyInfos.get(string);
    }

    public Class getTypeForTagName(String string) throws ObjectDescriptionException {
        PropertyDefinition propertyDefinition = this.getPropertyDefinitionByTagName(string);
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(propertyDefinition.getPropertyName());
        if (propertyDescriptor == null) {
            throw new ObjectDescriptionException("Invalid Definition: " + propertyDefinition.getPropertyName());
        }
        return propertyDescriptor.getPropertyType();
    }

    public PropertyDefinition getPropertyDefinitionByPropertyName(String string) throws ObjectDescriptionException {
        for (int i = 0; i < this.propertyDefinitions.length; ++i) {
            PropertyDefinition propertyDefinition = this.propertyDefinitions[i];
            if (!propertyDefinition.getPropertyName().equals(string)) continue;
            return propertyDefinition;
        }
        throw new ObjectDescriptionException("This tag is not defined for this kind of object. : " + string);
    }

    public PropertyDefinition getPropertyDefinitionByTagName(String string) throws ObjectDescriptionException {
        for (int i = 0; i < this.propertyDefinitions.length; ++i) {
            PropertyDefinition propertyDefinition = this.propertyDefinitions[i];
            if (!propertyDefinition.getElementName().equals(string)) continue;
            return propertyDefinition;
        }
        throw new ObjectDescriptionException("This tag is not defined for this kind of object. : " + string);
    }

    public ConstructorDefinition[] getConstructorDefinitions() {
        return this.constructorDefinitions;
    }

    public AttributeDefinition[] getAttributeDefinitions() {
        return this.attributeDefinitions;
    }

    public PropertyDefinition[] getPropertyDefinitions() {
        return this.propertyDefinitions;
    }

    public String[] getOrderedPropertyNames() {
        return this.orderedPropertyNames;
    }

    public LookupDefinition[] getLookupDefinitions() {
        return this.lookupDefinitions;
    }

    public Object getProperty(String string) {
        return this.propertyValues.get(string);
    }

    public Object createObject() throws ObjectDescriptionException {
        ConstructorDefinition constructorDefinition;
        Class[] classArray = new Class[this.constructorDefinitions.length];
        Object[] objectArray = new Object[this.constructorDefinitions.length];
        for (int i = 0; i < classArray.length; ++i) {
            constructorDefinition = this.constructorDefinitions[i];
            classArray[i] = constructorDefinition.getType();
            objectArray[i] = constructorDefinition.isNull() ? null : this.getProperty(constructorDefinition.getPropertyName());
        }
        try {
            Constructor constructor = this.baseClass.getConstructor(classArray);
            System.out.println("Invoking: " + constructor);
            constructorDefinition = constructor.newInstance(objectArray);
            return constructorDefinition;
        }
        catch (Exception exception) {
            throw new ObjectDescriptionException("Ugh! Constructor made a buuuh!", exception);
        }
    }

    public void setProperty(String string, Object object) throws ObjectDescriptionException {
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(string);
        if (propertyDescriptor == null) {
            throw new ObjectDescriptionException("Unknown property " + string);
        }
        if (!this.isAssignableOrPrimitive(propertyDescriptor.getPropertyType(), object.getClass())) {
            throw new ObjectDescriptionException("Invalid value: " + propertyDescriptor.getPropertyType() + " vs. " + object.getClass());
        }
        this.propertyValues.put(string, object);
    }

    private boolean isAssignableOrPrimitive(Class clazz, Class clazz2) {
        if (BasicTypeSupport.isBasicDataType(clazz)) {
            return true;
        }
        return clazz.isAssignableFrom(clazz2);
    }

    private boolean isConstructorProperty(String string) {
        for (int i = 0; i < this.constructorDefinitions.length; ++i) {
            ConstructorDefinition constructorDefinition = this.constructorDefinitions[i];
            if (!string.equals(constructorDefinition.getPropertyName())) continue;
            return true;
        }
        return false;
    }

    public void writeObjectProperties(Object object) throws ObjectDescriptionException {
        for (int i = 0; i < this.orderedPropertyNames.length; ++i) {
            try {
                Object object2;
                String string = this.orderedPropertyNames[i];
                if (this.isConstructorProperty(string) || (object2 = this.getProperty(string)) == null) continue;
                PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(string);
                Method method = propertyDescriptor.getWriteMethod();
                method.invoke(object, object2);
                continue;
            }
            catch (Exception exception) {
                throw new ObjectDescriptionException("Failed to set properties.", exception);
            }
        }
    }

    public void readProperties(Object object) throws ObjectDescriptionException {
        for (int i = 0; i < this.orderedPropertyNames.length; ++i) {
            try {
                String string = this.orderedPropertyNames[i];
                System.out.println("Handle " + string);
                PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(string);
                if (propertyDescriptor == null) {
                    throw new IllegalStateException("No property defined: " + string);
                }
                Method method = propertyDescriptor.getReadMethod();
                Object object2 = method.invoke(object, new Object[0]);
                if (object2 == null) continue;
                this.setProperty(string, object2);
                continue;
            }
            catch (Exception exception) {
                throw new ObjectDescriptionException("Failed to set properties.", exception);
            }
        }
    }

    public Class getBaseClass() {
        return this.baseClass;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

